/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.module;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.ModuleScreen;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.mantle.client.screen.SliderWidget;
import slimeknights.tconstruct.tables.client.inventory.module.GenericScreen;

public class DynamicContainerScreen<P extends MultiModuleScreen<?>, C extends AbstractContainerMenu>
extends ModuleScreen<P, C> {
    protected static final ScalableElementScreen slot = GenericScreen.slot;
    private static final ScalableElementScreen slotEmpty = GenericScreen.slotEmpty;
    protected static final ElementScreen sliderNormal = GenericScreen.sliderNormal;
    protected static final ElementScreen sliderLow = GenericScreen.sliderLow;
    protected static final ElementScreen sliderHigh = GenericScreen.sliderHigh;
    protected static final ElementScreen sliderTop = GenericScreen.sliderTop;
    protected static final ElementScreen sliderBottom = GenericScreen.sliderBottom;
    protected static final ScalableElementScreen sliderBackground = GenericScreen.sliderBackground;
    protected SliderWidget slider = new SliderWidget(sliderNormal, sliderHigh, sliderLow, sliderTop, sliderBottom, sliderBackground);
    protected int columns;
    protected int rows;
    protected int slotCount;
    protected boolean sliderActive;
    protected int firstSlotId;
    protected int lastSlotId;
    protected final AbstractContainerMenu container;

    public DynamicContainerScreen(P parent, C container, Inventory playerInventory, Component title) {
        super(parent, container, playerInventory, title, false, false);
        this.container = container;
        this.xOffset = 7;
        this.yOffset = 17;
        this.f_97726_ = 162;
        this.f_97727_ = 54;
        this.slotCount = ((AbstractContainerMenu)container).f_38839_.size();
        this.firstSlotId = 0;
        this.lastSlotId = this.slotCount;
    }

    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        this.f_97735_ = parentX + this.xOffset;
        this.f_97736_ = parentY + this.yOffset;
        this.columns = this.f_97726_ / DynamicContainerScreen.slot.w;
        this.rows = this.f_97727_ / DynamicContainerScreen.slot.h;
        this.sliderActive = this.slotCount > this.columns * this.rows;
        this.updateSlider();
        if (this.sliderActive) {
            this.columns = (this.f_97726_ - this.slider.width) / DynamicContainerScreen.slot.w;
            this.updateSlider();
        }
        this.updateSlots();
    }

    protected void updateSlider() {
        int max = 0;
        if (this.sliderActive) {
            this.slider.show();
            max = (this.slotCount - 1) / this.columns - this.rows + 1;
        } else {
            this.slider.hide();
        }
        this.slider.setPosition(this.f_97735_ + this.f_97726_ - this.slider.width, this.f_97736_);
        this.slider.setSize(this.f_97727_);
        this.slider.setSliderParameters(0, max, 1);
    }

    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.sliderActive) {
            return false;
        }
        if (mouseButton == 0 && mouseX >= (double)this.slider.xPos && mouseY >= (double)this.slider.yPos && mouseX <= (double)(this.slider.xPos + this.slider.width) && mouseY <= (double)(this.slider.yPos + this.slider.height)) {
            this.slider.handleMouseClicked((int)mouseX, (int)mouseY, mouseButton);
            return true;
        }
        return false;
    }

    public boolean handleMouseReleased(double mouseX, double mouseY, int state) {
        if (!this.sliderActive) {
            return false;
        }
        this.slider.handleMouseReleased();
        return mouseX >= (double)this.slider.xPos && mouseY >= (double)this.slider.yPos && mouseX <= (double)(this.slider.xPos + this.slider.width) && mouseY <= (double)(this.slider.yPos + this.slider.height);
    }

    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollData) {
        if (!this.sliderActive) {
            return false;
        }
        return this.slider.mouseScrolled(scrollData, !this.isMouseOverFullSlot(mouseX, mouseY) && this.isMouseInModule((int)mouseX, (int)mouseY));
    }

    public void update(int mouseX, int mouseY) {
        if (!this.sliderActive) {
            return;
        }
        this.slider.update(mouseX, mouseY);
        this.updateSlots();
    }

    public boolean shouldDrawSlot(Slot slot) {
        if (!this.slider.isEnabled()) {
            return true;
        }
        int index = slot.getSlotIndex();
        return this.firstSlotId <= index && this.lastSlotId > index;
    }

    public void updateSlots() {
        int oldFirstSlot = this.firstSlotId;
        int oldLastSlot = this.lastSlotId;
        this.firstSlotId = this.slider.getValue() * this.columns;
        this.lastSlotId = Math.min(this.slotCount, this.firstSlotId + this.rows * this.columns);
        if (oldFirstSlot != this.firstSlotId || oldLastSlot != this.lastSlotId) {
            for (Slot slot : this.container.f_38839_) {
                if (this.shouldDrawSlot(slot)) {
                    int offset = slot.getSlotIndex() - this.firstSlotId;
                    int x = offset % this.columns * DynamicContainerScreen.slot.w;
                    int y = offset / this.columns * DynamicContainerScreen.slot.h;
                    slot.f_40220_ = this.xOffset + x + 1;
                    slot.f_40221_ = this.yOffset + y + 1;
                    continue;
                }
                slot.f_40220_ = 0;
                slot.f_40221_ = 0;
            }
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int y;
        if (!this.slider.isHidden()) {
            this.slider.draw(graphics);
            this.updateSlots();
        }
        int fullRows = (this.lastSlotId - this.firstSlotId) / this.columns;
        int w = this.columns * DynamicContainerScreen.slot.w;
        for (y = 0; y < fullRows * DynamicContainerScreen.slot.h && y < this.f_97727_; y += DynamicContainerScreen.slot.h) {
            slot.drawScaledX(graphics, this.f_97735_, this.f_97736_ + y, w);
        }
        int slotsLeft = (this.lastSlotId - this.firstSlotId) % this.columns;
        if (slotsLeft > 0) {
            slot.drawScaledX(graphics, this.f_97735_, this.f_97736_ + y, slotsLeft * DynamicContainerScreen.slot.w);
            slotEmpty.drawScaledX(graphics, this.f_97735_ + slotsLeft * DynamicContainerScreen.slot.w, this.f_97736_ + y, w - slotsLeft * DynamicContainerScreen.slot.w);
        }
    }
}

