/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client;

import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.imb11.fog.client.FogManager;
import dev.imb11.fog.client.command.FogClientCommands;
import dev.imb11.fog.client.registry.FogRegistry;
import dev.imb11.fog.client.resource.FogResourceReloader;
import dev.imb11.fog.client.util.FogKeybinds;
import dev.imb11.fog.config.FogConfig;
import java.nio.file.Path;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FogClient {
    @NotNull
    public static final String MOD_ID = "fog";
    @NotNull
    public static final String MOD_NAME = "Fog";
    @NotNull
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fog");

    public static Path getConfigPath(String configFileName, String configExtension) {
        return FMLLoader.getGamePath().resolve("config").resolve(MOD_ID).resolve(configFileName + "." + configExtension);
    }

    public static boolean isModInstalled(String modid) {
        return FMLLoader.getLoadingModList().getModFileById(modid) != null;
    }

    public static Path getConfigFolder() {
        return FMLLoader.getGamePath().resolve("config").resolve(MOD_ID);
    }

    public static void initialize() {
        LOGGER.info("Loading {}.", (Object)MOD_NAME);
        FogConfig.load();
        FogClientCommands.register();
        FogKeybinds.init();
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new FogResourceReloader());
        ClientTickEvent.CLIENT_LEVEL_POST.register(world -> FogManager.getInstance().onEndTick((ClientLevel)world));
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(clientPlayerEntity -> {
            FogManager.INSTANCE = new FogManager();
            FogRegistry.resetCaches();
        });
    }
}

