/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.factoryBoard;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packager.repackager.RepackagerBlockEntity;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FactoryPanelBlockEntity
extends SmartBlockEntity {
    public EnumMap<FactoryPanelBlock.PanelSlot, FactoryPanelBehaviour> panels;
    public boolean redraw;
    public boolean restocker = false;
    public VoxelShape lastShape;
    public AdvancementBehaviour advancements;

    public FactoryPanelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_(8.0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.panels = new EnumMap(FactoryPanelBlock.PanelSlot.class);
        this.redraw = true;
        for (FactoryPanelBlock.PanelSlot slot : FactoryPanelBlock.PanelSlot.values()) {
            FactoryPanelBehaviour e = new FactoryPanelBehaviour(this, slot);
            this.panels.put(slot, e);
            behaviours.add(e);
        }
        this.advancements = new AdvancementBehaviour(this, AllAdvancements.FACTORY_GAUGE);
        behaviours.add(this.advancements);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.activePanels() == 0) {
            this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
        }
        if (AllBlocks.FACTORY_GAUGE.has(this.m_58900_())) {
            boolean shouldBeRestocker = AllBlocks.PACKAGER.has(this.f_58857_.m_8055_(this.f_58858_.m_121945_(FactoryPanelBlock.connectedDirection(this.m_58900_()).m_122424_())));
            if (this.restocker == shouldBeRestocker) {
                return;
            }
            this.restocker = shouldBeRestocker;
            this.redraw = true;
            this.sendData();
        }
    }

    @Nullable
    public PackagerBlockEntity getRestockedPackager() {
        BlockState state = this.m_58900_();
        if (!this.restocker || !AllBlocks.FACTORY_GAUGE.has(state)) {
            return null;
        }
        BlockPos packagerPos = this.f_58858_.m_121945_(FactoryPanelBlock.connectedDirection(state).m_122424_());
        if (!this.f_58857_.m_46749_(packagerPos)) {
            return null;
        }
        BlockEntity be = this.f_58857_.m_7702_(packagerPos);
        if (be == null || !(be instanceof PackagerBlockEntity)) {
            return null;
        }
        PackagerBlockEntity pbe = (PackagerBlockEntity)be;
        if (pbe instanceof RepackagerBlockEntity) {
            return null;
        }
        return pbe;
    }

    public int activePanels() {
        int result = 0;
        for (FactoryPanelBehaviour panelBehaviour : this.panels.values()) {
            if (!panelBehaviour.isActive()) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void remove() {
        for (FactoryPanelBehaviour panelBehaviour : this.panels.values()) {
            if (!panelBehaviour.isActive()) continue;
            panelBehaviour.disconnectAll();
        }
        super.remove();
    }

    @Override
    public void destroy() {
        super.destroy();
        int panelCount = this.activePanels();
        if (panelCount > 1) {
            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)AllBlocks.FACTORY_GAUGE.asStack(panelCount - 1));
        }
    }

    public boolean addPanel(FactoryPanelBlock.PanelSlot slot, UUID frequency) {
        FactoryPanelBehaviour behaviour = this.panels.get((Object)slot);
        if (behaviour != null && !behaviour.isActive()) {
            behaviour.enable();
            if (frequency != null) {
                behaviour.setNetwork(frequency);
            }
            this.redraw = true;
            this.lastShape = null;
            if (this.activePanels() > 1) {
                SoundType soundType = this.m_58900_().m_60827_();
                this.f_58857_.m_5594_(null, this.f_58858_, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public boolean removePanel(FactoryPanelBlock.PanelSlot slot) {
        FactoryPanelBehaviour behaviour = this.panels.get((Object)slot);
        if (behaviour != null && behaviour.isActive()) {
            behaviour.disable();
            this.redraw = true;
            this.lastShape = null;
            if (this.activePanels() > 0) {
                SoundType soundType = this.m_58900_().m_60827_();
                this.f_58857_.m_5594_(null, this.f_58858_, soundType.m_56775_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public VoxelShape getShape() {
        if (this.lastShape != null) {
            return this.lastShape;
        }
        float xRot = 57.295776f * FactoryPanelBlock.getXRot(this.m_58900_()) + 90.0f;
        float yRot = 57.295776f * FactoryPanelBlock.getYRot(this.m_58900_());
        Direction connectedDirection = FactoryPanelBlock.connectedDirection(this.m_58900_());
        Vec3 inflateAxes = VecHelper.axisAlingedPlaneOf((Direction)connectedDirection);
        this.lastShape = Shapes.m_83040_();
        for (FactoryPanelBehaviour behaviour : this.panels.values()) {
            if (!behaviour.isActive()) continue;
            FactoryPanelPosition panelPosition = behaviour.getPanelPosition();
            Vec3 vec = new Vec3(0.25 + (double)panelPosition.slot().xOffset * 0.5, 0.0625, 0.25 + (double)panelPosition.slot().yOffset * 0.5);
            vec = VecHelper.rotateCentered((Vec3)vec, (double)180.0, (Direction.Axis)Direction.Axis.Y);
            vec = VecHelper.rotateCentered((Vec3)vec, (double)xRot, (Direction.Axis)Direction.Axis.X);
            vec = VecHelper.rotateCentered((Vec3)vec, (double)yRot, (Direction.Axis)Direction.Axis.Y);
            AABB bb = new AABB(vec, vec).m_82400_(0.0625).m_82377_(inflateAxes.f_82479_ * 3.0 / 16.0, inflateAxes.f_82480_ * 3.0 / 16.0, inflateAxes.f_82481_ * 3.0 / 16.0);
            this.lastShape = Shapes.m_83110_((VoxelShape)this.lastShape, (VoxelShape)Shapes.m_83064_((AABB)bb));
        }
        return this.lastShape;
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.restocker = tag.m_128471_("Restocker");
        if (clientPacket && tag.m_128441_("Redraw")) {
            this.lastShape = null;
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
        }
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128379_("Restocker", this.restocker);
        if (clientPacket && this.redraw) {
            NBTHelper.putMarker((CompoundTag)tag, (String)"Redraw");
            this.redraw = false;
        }
    }
}

