/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.data.RenderData;
import mekanism.client.render.data.ValveRenderData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.Direction;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public final class ModelRenderer {
    private static final int BLOCK_STAGES = 1000;
    private static final Map<RenderData, Int2ObjectMap<MekanismRenderer.Model3D>> cachedCenterData = new Object2ObjectOpenHashMap();
    private static final Map<ValveRenderData, Float2ObjectMap<MekanismRenderer.Model3D>> cachedValveFluids = new Object2ObjectOpenHashMap();

    private ModelRenderer() {
    }

    public static int getStage(FluidStack stack, int stages, double scale) {
        return ModelRenderer.getStage(MekanismUtils.lighterThanAirGas(stack), stages, scale);
    }

    public static int getStage(boolean gaseous, int stages, double scale) {
        if (gaseous) {
            return stages - 1;
        }
        return Math.min(stages - 1, (int)(scale * (double)(stages - 1)));
    }

    public static MekanismRenderer.Model3D getModel(RenderData data, double scale) {
        int maxStages = Math.max(data.height * 1000, 1);
        int stage = data.height == 0 ? 1 : (data.isGaseous() ? maxStages : Math.min(maxStages, (int)(scale * (double)maxStages)));
        return (MekanismRenderer.Model3D)cachedCenterData.computeIfAbsent(data, d -> new Int2ObjectOpenHashMap()).computeIfAbsent(stage, s -> new MekanismRenderer.Model3D().setTexture(data.getTexture()).xBounds(0.01f, (float)data.length - 0.02f).yBounds(0.01f, (float)data.height * ((float)s / (float)maxStages) - 0.02f).zBounds(0.01f, (float)data.width - 0.02f));
    }

    public static float getActualHeight(MekanismRenderer.Model3D model) {
        return model.maxY + 0.02f;
    }

    @Nullable
    public static MekanismRenderer.Model3D getValveModel(ValveRenderData data, float height) {
        block6: {
            switch (data.getSide()) {
                case DOWN: {
                    if (height >= 0.49f) {
                        break;
                    }
                    break block6;
                }
                case UP: {
                    if (height >= (float)data.height) {
                        break;
                    }
                    break block6;
                }
                default: {
                    if (!(height - (float)data.getValveFluidHeight() >= 0.69f)) break block6;
                }
            }
            return null;
        }
        return (MekanismRenderer.Model3D)cachedValveFluids.computeIfAbsent(data, d -> new Float2ObjectOpenHashMap()).computeIfAbsent(height, fluidHeight -> {
            MekanismRenderer.Model3D model = new MekanismRenderer.Model3D().prepFlowing(data.fluidType).setSideRender(Direction.DOWN, fluidHeight == 0.0f).xBounds(0.3f, 0.7f).zBounds(0.3f, 0.7f);
            Direction side = data.getSide();
            if (side.m_122434_().m_122479_()) {
                model.yBounds(fluidHeight - (float)data.getValveFluidHeight() + 0.01f, 0.7f);
            }
            return switch (side) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> model.yBounds(fluidHeight + 1.01f, 1.5f);
                case Direction.UP -> model.yBounds(fluidHeight - (float)data.height - 0.01f, -0.01f);
                case Direction.NORTH -> model.zBounds(1.02f, 1.4f);
                case Direction.SOUTH -> model.zBounds(-0.4f, -0.03f);
                case Direction.WEST -> model.xBounds(1.02f, 1.4f);
                case Direction.EAST -> model.xBounds(-0.4f, -0.03f);
            };
        });
    }

    public static void resetCachedModels() {
        cachedCenterData.clear();
        cachedValveFluids.clear();
    }
}

