/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.config;

import dev.imb11.sounds.api.config.ConfiguredSound;
import dev.imb11.sounds.api.config.DynamicConfiguredSound;
import dev.imb11.sounds.config.SoundsConfig;
import dev.imb11.sounds.config.utils.ConfigGroup;
import dev.imb11.sounds.sound.context.RepeaterSoundContext;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class WorldSoundsConfig
extends ConfigGroup<WorldSoundsConfig>
implements YetAnotherConfigLib.ConfigBackedBuilder<WorldSoundsConfig> {
    @SerialEntry
    public DynamicConfiguredSound<Integer, RepeaterSoundContext> repeaterUseSoundEffect = new DynamicConfiguredSound("repeaterUse", SoundEvents.f_12444_, true, 0.95f, 0.3f, true);
    @SerialEntry
    public ConfiguredSound jukeboxUseSoundEffect = new ConfiguredSound("jukeboxUse", (Holder.Reference<SoundEvent>)SoundEvents.f_12208_, true, 0.8f, 0.75f);
    @SerialEntry
    public ConfiguredSound daylightDetectorUseSoundEffect = new ConfiguredSound("daylightDetectorUse", (Holder.Reference<SoundEvent>)SoundEvents.f_12215_, true, 0.8f, 0.45f);
    @SerialEntry
    public ConfiguredSound furnaceMinecartFuelSoundEffect = new ConfiguredSound("furnaceMinecartFuel", SoundEvents.f_11836_, true, 1.9f, 0.2f);
    @SerialEntry
    public ConfiguredSound frostWalkerSoundEffect = new ConfiguredSound("frostWalker", SoundEvents.f_144201_, true, 2.0f, 0.5f);
    @SerialEntry
    public ConfiguredSound leadSnappingSoundEffect = new ConfiguredSound("leadSnapping", SoundEvents.f_12033_, true, 1.0f, 0.5f);
    @SerialEntry
    public ConfiguredSound bowPullSoundEffect = new ConfiguredSound("bowPull", SoundEvents.f_11842_, true, 1.0f, 0.25f);
    @SerialEntry
    public ConfiguredSound plantPotFillSoundEffect = new ConfiguredSound("plantPotFill", SoundEvents.f_11991_, true, 0.5f, 0.4f);
    @SerialEntry
    public ConfiguredSound cakeEatSoundEffect = new ConfiguredSound("cakeEat", SoundEvents.f_11912_, true, 1.2f, 0.7f);
    @SerialEntry
    public boolean enableEnderpearlVariety = true;
    @SerialEntry
    public boolean disableBlocksEntirely = false;

    public WorldSoundsConfig() {
        super(WorldSoundsConfig.class);
    }

    @Override
    public YetAnotherConfigLib getYACL() {
        return YetAnotherConfigLib.create(this.getHandler(), (YetAnotherConfigLib.ConfigBackedBuilder)this);
    }

    @Override
    public ResourceLocation getImage() {
        return ResourceLocation.m_214293_((String)"sounds", (String)"textures/gui/world_sounds.webp");
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)"sounds.config.world");
    }

    @Override
    public String getID() {
        return "world";
    }

    public YetAnotherConfigLib.Builder build(WorldSoundsConfig defaults, WorldSoundsConfig config, YetAnotherConfigLib.Builder builder) {
        builder.title(Component.m_130674_((String)"World Sounds"));
        builder.category(ConfigCategory.createBuilder().name((Component)Component.m_237115_((String)"sounds.config.world.mechanics")).group(config.repeaterUseSoundEffect.getOptionGroup(defaults.repeaterUseSoundEffect)).group(config.jukeboxUseSoundEffect.getOptionGroup(defaults.jukeboxUseSoundEffect)).group(config.daylightDetectorUseSoundEffect.getOptionGroup(defaults.daylightDetectorUseSoundEffect)).group(config.furnaceMinecartFuelSoundEffect.getOptionGroup(defaults.furnaceMinecartFuelSoundEffect)).build());
        builder.category(ConfigCategory.createBuilder().name((Component)Component.m_237115_((String)"sounds.config.world.blocks")).option(SoundsConfig.HELPER.get("disableBlocksEntirely", defaults.disableBlocksEntirely, () -> config.disableBlocksEntirely, v1 -> {
            config.disableBlocksEntirely = v1;
        })).option((Option)LabelOption.create((Component)Component.m_237115_((String)"sounds.config.world.blocks.description"))).option((Option)ButtonOption.createBuilder().name(Component.m_130674_((String)"Open Wiki")).description(OptionDescription.EMPTY).action((screen, option) -> Util.m_137581_().m_137646_("https://docs.imb11.dev/sounds/data/custom-block-sounds")).build()).build());
        builder.category(ConfigCategory.createBuilder().name((Component)Component.m_237115_((String)"sounds.config.world.actions")).option(SoundsConfig.HELPER.get("enableEnderpearlVariety", defaults.enableEnderpearlVariety, () -> config.enableEnderpearlVariety, v -> {
            config.enableEnderpearlVariety = v;
        })).group(config.frostWalkerSoundEffect.getOptionGroup(defaults.frostWalkerSoundEffect)).group(config.leadSnappingSoundEffect.getOptionGroup(defaults.leadSnappingSoundEffect)).group(config.bowPullSoundEffect.getOptionGroup(defaults.bowPullSoundEffect)).group(config.plantPotFillSoundEffect.getOptionGroup(defaults.plantPotFillSoundEffect)).group(config.cakeEatSoundEffect.getOptionGroup(defaults.cakeEatSoundEffect)).build());
        return builder;
    }
}

