/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.entity;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.mobs.module.ForgottenModule;
import org.violetmoon.quark.content.tools.base.RuneColor;
import org.violetmoon.quark.content.tools.module.ColorRunesModule;

public class Forgotten
extends Skeleton {
    public static final EntityDataAccessor<ItemStack> SHEATHED_ITEM = SynchedEntityData.m_135353_(Forgotten.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final ResourceLocation FORGOTTEN_LOOT_TABLE = new ResourceLocation("quark", "entities/forgotten");

    public Forgotten(EntityType<? extends Forgotten> type, Level world) {
        super(type, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHEATHED_ITEM, (Object)ItemStack.f_41583_);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData ilivingentitydata = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.m_32164_();
        return ilivingentitydata;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            boolean isUsingBow;
            boolean shouldUseBow;
            LivingEntity target = this.m_5448_();
            boolean bl = shouldUseBow = target == null;
            if (!shouldUseBow) {
                MobEffectInstance eff = target.m_21124_(MobEffects.f_19610_);
                boolean bl2 = shouldUseBow = eff == null || eff.m_19557_() < 20;
            }
            if (shouldUseBow != (isUsingBow = this.m_21205_().m_41720_() instanceof BowItem)) {
                this.swap();
            }
        }
        double w = this.m_20205_() * 2.0f;
        double h = this.m_20206_();
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123770_, this.m_20185_() + Math.random() * w - w / 2.0, this.m_20186_() + Math.random() * h, this.m_20189_() + Math.random() * w - w / 2.0, 0.0, 0.0, 0.0);
    }

    private void swap() {
        ItemStack curr = this.m_21205_();
        ItemStack off = (ItemStack)this.f_19804_.m_135370_(SHEATHED_ITEM);
        this.m_21008_(InteractionHand.MAIN_HAND, off);
        this.f_19804_.m_135381_(SHEATHED_ITEM, (Object)curr);
        Stream stream = this.f_21345_.m_25386_();
        stream.map(WrappedGoal::m_26015_).filter(g -> g instanceof MeleeAttackGoal || g instanceof RangedBowAttackGoal).forEach(Goal::m_8041_);
        this.m_32164_();
    }

    @NotNull
    protected ResourceLocation m_7582_() {
        return FORGOTTEN_LOOT_TABLE;
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        CompoundTag sheathed = new CompoundTag();
        ((ItemStack)this.f_19804_.m_135370_(SHEATHED_ITEM)).m_41739_(sheathed);
        compound.m_128365_("sheathed", (Tag)sheathed);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        CompoundTag sheathed = compound.m_128469_("sheathed");
        this.f_19804_.m_135381_(SHEATHED_ITEM, (Object)ItemStack.m_41712_((CompoundTag)sheathed));
    }

    protected float m_6431_(@NotNull Pose poseIn, @NotNull EntityDimensions sizeIn) {
        return 2.1f;
    }

    protected void m_7472_(@NotNull DamageSource source, int looting, boolean recentlyHitIn) {
    }

    public boolean m_21531_() {
        return false;
    }

    protected void m_213945_(@NotNull RandomSource rand, @NotNull DifficultyInstance difficulty) {
        super.m_213945_(rand, difficulty);
        this.prepareEquipment();
    }

    public void prepareEquipment() {
        DyeColor color;
        RuneColor rune;
        ItemStack bow = new ItemStack((ItemLike)Items.f_42411_);
        ItemStack sheathed = new ItemStack((ItemLike)Items.f_42383_);
        EnchantmentHelper.m_220292_((RandomSource)this.f_19796_, (ItemStack)bow, (int)20, (boolean)false);
        EnchantmentHelper.m_220292_((RandomSource)this.f_19796_, (ItemStack)sheathed, (int)20, (boolean)false);
        if (Quark.ZETA.modules.isEnabled(ColorRunesModule.class) && this.f_19796_.m_188499_() && (rune = RuneColor.byDyeColor(color = DyeColor.values()[this.f_19796_.m_188503_(DyeColor.values().length)])) != null) {
            ColorRunesModule.withRune(bow, rune);
            ColorRunesModule.withRune(sheathed, rune);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, bow);
        this.f_19804_.m_135381_(SHEATHED_ITEM, (Object)sheathed);
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ForgottenModule.forgotten_hat));
    }

    @NotNull
    protected AbstractArrow m_7932_(@NotNull ItemStack arrowStack, float distanceFactor) {
        AbstractArrow arrow = super.m_7932_(arrowStack, distanceFactor);
        if (arrow instanceof Arrow) {
            Arrow arrowInstance = (Arrow)arrow;
            ItemStack stack = new ItemStack((ItemLike)Items.f_42738_);
            PotionUtils.m_43552_((ItemStack)stack, (Collection)ImmutableSet.of((Object)new MobEffectInstance(MobEffects.f_19610_, 100, 0)));
            arrowInstance.m_36878_(stack);
        }
        return arrow;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

