/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui.option;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.option.SpruceOption;
import org.thinkingstudio.obsidianui.widget.SpruceWidget;
import org.thinkingstudio.obsidianui.widget.text.SpruceNamedTextFieldWidget;
import org.thinkingstudio.obsidianui.widget.text.SpruceTextFieldWidget;

public class SpruceFloatInputOption
extends SpruceOption {
    private final Supplier<Float> getter;
    private final Consumer<Float> setter;

    public SpruceFloatInputOption(String key, Supplier<Float> getter, Consumer<Float> setter, @Nullable Component tooltip) {
        super(key);
        this.getter = getter;
        this.setter = setter;
        this.setTooltip(tooltip);
    }

    @Override
    public SpruceWidget createWidget(Position position, int width) {
        SpruceTextFieldWidget textField = new SpruceTextFieldWidget(position, width, 20, this.getPrefix());
        textField.setText(String.valueOf(this.get()));
        textField.setTextPredicate(SpruceTextFieldWidget.FLOAT_INPUT_PREDICATE);
        textField.setRenderTextProvider((displayedText, offset) -> {
            try {
                Float.parseFloat(textField.getText());
                return FormattedCharSequence.m_13714_((String)displayedText, (Style)Style.f_131099_);
            }
            catch (NumberFormatException e) {
                return FormattedCharSequence.m_13714_((String)displayedText, (Style)Style.f_131099_.m_131140_(ChatFormatting.RED));
            }
        });
        textField.setChangedListener(input -> {
            float value;
            try {
                value = Float.parseFloat(input);
            }
            catch (NumberFormatException e) {
                value = 0.0f;
            }
            this.set(value);
        });
        this.getOptionTooltip().ifPresent(textField::setTooltip);
        return new SpruceNamedTextFieldWidget(textField);
    }

    public void set(float value) {
        this.setter.accept(Float.valueOf(value));
    }

    public float get() {
        return this.getter.get().floatValue();
    }
}

