/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.mojang.blaze3d.platform.InputConstants;
import com.railwayteam.railways.registry.forge.CRKeysImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.lwjgl.glfw.GLFW;

public enum CRKeys {
    BOGEY_MENU("bogey_menu", 342),
    CYCLE_MENU("cycle_menu", 342);

    private KeyMapping keybind;
    private final String description;
    private final int key;
    private final boolean modifiable;
    public static final Set<KeyMapping> NON_CONFLICTING_KEYMAPPINGS;

    private CRKeys(String description, int defaultKey) {
        this.description = "railways.keyinfo." + description;
        this.key = defaultKey;
        this.modifiable = !description.isEmpty();
    }

    public static void register() {
        for (CRKeys key : CRKeys.values()) {
            if (!key.modifiable) continue;
            key.keybind = new KeyMapping(key.description, key.key, "Steam 'n' Rails");
            NON_CONFLICTING_KEYMAPPINGS.add(key.keybind);
            CRKeys.registerKeyBinding(key.keybind);
        }
    }

    public static void fixBinds() {
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        for (CRKeys key : CRKeys.values()) {
            if (key.keybind == null || key.keybind.m_90862_()) continue;
            key.keybind.m_7249_(InputConstants.m_84830_((long)window, (int)key.getBoundCode()));
        }
    }

    public KeyMapping getKeybind() {
        return this.keybind;
    }

    public boolean isPressed() {
        if (!this.modifiable) {
            return CRKeys.isKeyDown(this.key);
        }
        return this.keybind.m_90857_();
    }

    public String getBoundKey() {
        return this.keybind.m_90863_().getString().toUpperCase();
    }

    public int getBoundCode() {
        return CRKeys.getBoundCode(this.keybind);
    }

    public static boolean isKeyDown(int key) {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key);
    }

    public static boolean isMouseButtonDown(int button) {
        return GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)button) == 1;
    }

    public static boolean ctrlDown() {
        return Screen.m_96637_();
    }

    public static boolean shiftDown() {
        return Screen.m_96638_();
    }

    public static boolean altDown() {
        return Screen.m_96639_();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerKeyBinding(KeyMapping keyMapping) {
        CRKeysImpl.registerKeyBinding(keyMapping);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static int getBoundCode(KeyMapping keyMapping) {
        return CRKeysImpl.getBoundCode(keyMapping);
    }

    static {
        NON_CONFLICTING_KEYMAPPINGS = new HashSet<KeyMapping>();
    }
}

