/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util.packet;

import com.railwayteam.railways.mixin.AccessorTrain;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.trains.entity.Train;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChopTrainEndPacket
implements S2CPacket {
    final UUID trainId;
    final int numberOfCarriages;
    final boolean doubleEnded;

    public ChopTrainEndPacket(Train train, int numberOfCarriages, boolean doubleEnded) {
        this.trainId = train.id;
        this.numberOfCarriages = numberOfCarriages;
        this.doubleEnded = doubleEnded;
    }

    public ChopTrainEndPacket(FriendlyByteBuf buf) {
        this.trainId = buf.m_130259_();
        this.numberOfCarriages = buf.readInt();
        this.doubleEnded = buf.readBoolean();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.trainId);
        buffer.writeInt(this.numberOfCarriages);
        buffer.writeBoolean(this.doubleEnded);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        Train train;
        ClientLevel level = mc.f_91073_;
        if (level != null && (train = (Train)CreateClient.RAILWAYS.trains.get(this.trainId)) != null) {
            for (int i = 0; i < this.numberOfCarriages; ++i) {
                train.carriages.remove(train.carriages.size() - 1);
                train.carriageSpacing.remove(train.carriageSpacing.size() - 1);
            }
            double[] originalStress = ((AccessorTrain)train).railways$getStress();
            double[] newStress = new double[originalStress.length - this.numberOfCarriages];
            System.arraycopy(originalStress, 0, newStress, 0, newStress.length);
            ((AccessorTrain)train).railways$setStress(newStress);
            train.doubleEnded = this.doubleEnded;
        }
    }
}

