/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.impl;

import com.google.common.collect.ImmutableSet;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionEventListener;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.StateManager;
import dev.isxander.yacl3.gui.controllers.LabelController;
import dev.isxander.yacl3.impl.OptionImpl;
import dev.isxander.yacl3.impl.SelfContainedBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class LabelOptionImpl
extends OptionImpl<Component>
implements LabelOption {
    public LabelOptionImpl(@NotNull StateManager<Component> stateManager, @NotNull Collection<OptionEventListener<Component>> optionEventListeners) {
        super((Component)Component.m_237113_((String)"Label Option"), xva$0 -> OptionDescription.of(xva$0), LabelController::new, stateManager, true, (ImmutableSet<OptionFlag>)ImmutableSet.of(), optionEventListeners);
    }

    public LabelOptionImpl(Component label) {
        this(StateManager.createImmutable(label), (Collection<OptionEventListener<Component>>)ImmutableSet.of());
    }

    @Override
    @NotNull
    public Component label() {
        return (Component)this.stateManager().get();
    }

    @Override
    public void setAvailable(boolean available) {
        throw new UnsupportedOperationException("Cannot change availability of label option");
    }

    @ApiStatus.Internal
    public static final class BuilderImpl
    implements LabelOption.Builder {
        private StateManager<Component> stateManager;
        private final List<Component> lines = new ArrayList<Component>();

        @Override
        public LabelOption.Builder state(@NotNull StateManager<Component> stateManager) {
            Validate.notNull(stateManager, (String)"`stateManager` must not be null", (Object[])new Object[0]);
            Validate.isTrue((boolean)this.lines.isEmpty(), (String)"Cannot set state manager if lines have already been defined", (Object[])new Object[0]);
            this.stateManager = stateManager;
            return this;
        }

        @Override
        public LabelOption.Builder line(@NotNull Component line) {
            Validate.isTrue((this.stateManager == null ? 1 : 0) != 0, (String)".line() is a helper to create a state manager for you at build. If you have defined a custom state manager, do not use .line()", (Object[])new Object[0]);
            Validate.notNull((Object)line, (String)"`line` must not be null", (Object[])new Object[0]);
            this.lines.add(line);
            return this;
        }

        @Override
        public LabelOption.Builder lines(@NotNull Collection<? extends Component> lines) {
            Validate.isTrue((this.stateManager == null ? 1 : 0) != 0, (String)".lines() is a helper to create a state manager for you at build. If you have defined a custom state manager, do not use .lines()", (Object[])new Object[0]);
            this.lines.addAll(lines);
            return this;
        }

        @Override
        public LabelOption build() {
            Validate.isTrue((this.stateManager != null || !this.lines.isEmpty() ? 1 : 0) != 0, (String)"Cannot build label option without a state manager or lines", (Object[])new Object[0]);
            if (!this.lines.isEmpty()) {
                MutableComponent text = Component.m_237119_();
                Iterator<Component> iterator = this.lines.iterator();
                while (iterator.hasNext()) {
                    text.m_7220_(iterator.next());
                    if (!iterator.hasNext()) continue;
                    text.m_130946_("\n");
                }
                this.stateManager = StateManager.createSimple(new SelfContainedBinding<MutableComponent>(text));
            }
            return new LabelOptionImpl(this.stateManager, (Collection<OptionEventListener<Component>>)ImmutableSet.of());
        }
    }
}

