/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal;

import guideme.Guide;
import guideme.Guides;
import guideme.PageAnchor;
import guideme.internal.GuideRegistry;
import guideme.internal.MutableGuide;
import guideme.internal.screen.GuideScreen;
import guideme.internal.util.Platform;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.commands.Commands;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.resource.ResourcePackLoader;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GuideOnStartup {
    private static final Logger LOG = LoggerFactory.getLogger(GuideOnStartup.class);

    private GuideOnStartup() {
    }

    public static void init(IEventBus modBus) {
        Set<ResourceLocation> guidesToValidate = GuideOnStartup.getGuideIdsToValidate();
        ShowOnStartup showOnStartup = GuideOnStartup.getShowOnStartup();
        if (!guidesToValidate.isEmpty() || showOnStartup != null) {
            MutableBoolean guideOpenedOnce = new MutableBoolean(false);
            MinecraftForge.EVENT_BUS.addListener(e -> {
                if (e.getNewScreen() instanceof TitleScreen && !guideOpenedOnce.booleanValue()) {
                    guideOpenedOnce.setTrue();
                    GuideOnStartup.runDatapackReload();
                    for (ResourceLocation guideId : guidesToValidate) {
                        MutableGuide guide = GuideRegistry.getById(guideId);
                        if (guide == null) {
                            LOG.error("Cannot validate guide '{}' since it does not exist.", (Object)guideId);
                            continue;
                        }
                        guide.validateAll();
                    }
                    if (showOnStartup != null) {
                        Guide guide = Guides.getById(showOnStartup.guideId);
                        if (guide == null) {
                            LOG.error("Cannot show guide '{}' since it does not exist.", (Object)showOnStartup.guideId);
                        } else {
                            try {
                                PageAnchor anchor = showOnStartup.anchor;
                                if (anchor == null) {
                                    anchor = PageAnchor.page(guide.getStartPage());
                                }
                                e.setNewScreen((Screen)GuideScreen.openNew(guide, anchor));
                            }
                            catch (Exception ex) {
                                LOG.error("Failed to open {}", (Object)showOnStartup, (Object)ex);
                                System.exit(1);
                            }
                        }
                    }
                }
            });
        }
    }

    private static ShowOnStartup getShowOnStartup() {
        String showOnStartup = System.getProperty("guideme.showOnStartup");
        if (showOnStartup == null) {
            return null;
        }
        String[] parts = showOnStartup.split("!", 2);
        ResourceLocation guideId = new ResourceLocation(parts[0]);
        PageAnchor page = null;
        if (parts.length > 1) {
            page = PageAnchor.parse(parts[1]);
        }
        return new ShowOnStartup(guideId, page);
    }

    private static Set<ResourceLocation> getGuideIdsToValidate() {
        LinkedHashSet<ResourceLocation> guidesToValidate = new LinkedHashSet<ResourceLocation>();
        String validateGuideIds = System.getProperty("guideme.validateAtStartup");
        if (validateGuideIds != null) {
            String[] guideIds;
            for (String guideId : guideIds = validateGuideIds.split(",")) {
                guidesToValidate.add(new ResourceLocation(guideId));
            }
        }
        return guidesToValidate;
    }

    public static CompletableFuture<Minecraft> afterClientStart(IEventBus modEventBus) {
        CompletableFuture<Minecraft> future = new CompletableFuture<Minecraft>();
        modEventBus.addListener(evt -> {
            CompletableFuture reload;
            Minecraft client = Minecraft.m_91087_();
            Overlay patt5041$temp = client.m_91265_();
            if (patt5041$temp instanceof LoadingOverlay) {
                LoadingOverlay loadingOverlay = (LoadingOverlay)patt5041$temp;
                reload = loadingOverlay.f_96164_.m_7237_();
            } else {
                reload = CompletableFuture.completedFuture(null);
            }
            reload.whenCompleteAsync((o, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                } else {
                    future.complete(client);
                }
            }, (Executor)client);
        });
        return future;
    }

    public static void runDatapackReload() {
        try {
            LayeredRegistryAccess layeredAccess = RegistryLayer.m_245849_();
            PackRepository packRepository = new PackRepository(new RepositorySource[]{new ServerPacksSource()});
            ResourcePackLoader.loadResourcePacks((PackRepository)packRepository, ServerLifecycleHooks::buildPackFinder);
            packRepository.m_10506_();
            packRepository.m_10509_(packRepository.m_10514_());
            MultiPackResourceManager resourceManager = new MultiPackResourceManager(PackType.SERVER_DATA, packRepository.m_10525_());
            RegistryAccess.Frozen worldgenLayer = RegistryDataLoader.m_247207_((ResourceManager)resourceManager, (RegistryAccess)layeredAccess.m_246035_((Object)RegistryLayer.WORLDGEN), (List)RegistryDataLoader.f_243803_);
            layeredAccess = layeredAccess.m_247705_((Object)RegistryLayer.WORLDGEN, new RegistryAccess.Frozen[]{worldgenLayer});
            ReloadableServerResources stuff = (ReloadableServerResources)ReloadableServerResources.m_247740_((ResourceManager)resourceManager, (RegistryAccess.Frozen)layeredAccess.m_246035_((Object)RegistryLayer.RELOADABLE), (FeatureFlagSet)FeatureFlagSet.m_246902_(), (Commands.CommandSelection)Commands.CommandSelection.ALL, (int)0, (Executor)Util.m_183991_(), command -> {
                try {
                    command.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }).get();
            stuff.m_206868_((RegistryAccess)layeredAccess.m_247579_());
            Platform.fallbackClientRecipeManager = stuff.m_206887_();
            Platform.fallbackClientRegistryAccess = layeredAccess.m_247579_();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private record ShowOnStartup(ResourceLocation guideId, @Nullable PageAnchor anchor) {
    }
}

