/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;

@Mod.EventBusSubscriber
public class FogManager {
    private static final int INTERP_MAX = 80;
    private static final Map<ResourceKey<Level>, FogManager> FOG_MANAGERS = new HashMap<ResourceKey<Level>, FogManager>();
    private double interpolation;
    private FogEvent lastEvent = null;
    private final LinkedHashMap<UUID, FogEvent> fogEvents = new LinkedHashMap();

    private static <K, V> Map.Entry<K, V> lastEntry(LinkedHashMap<K, V> map) {
        Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
        Map.Entry<K, V> last = null;
        while (it.hasNext()) {
            last = it.next();
        }
        return last;
    }

    public static void createEvent(Entity entity, FogEvent event) {
        FogManager.createEvent((ResourceKey<Level>)entity.f_19853_.m_46472_(), entity.m_20148_(), event);
    }

    public static void createEvent(ResourceKey<Level> dimension, UUID id, FogEvent event) {
        FogManager manager = FogManager.getManagerFor(dimension);
        if (manager.fogEvents.isEmpty()) {
            manager.interpolation = 80.0;
        }
        manager.fogEvents.put(id, event);
    }

    public static void stopEvent(UUID id) {
        for (FogManager manager : FOG_MANAGERS.values()) {
            if (!manager.fogEvents.containsKey(id)) continue;
            manager.lastEvent = (FogEvent)manager.fogEvents.remove(id);
            if (!manager.fogEvents.isEmpty()) continue;
            manager.interpolation = 80.0;
        }
    }

    private static FogManager getManagerFor(ResourceKey<Level> dimension) {
        return FOG_MANAGERS.computeIfAbsent(dimension, dim -> new FogManager());
    }

    public static void clear() {
        FOG_MANAGERS.clear();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void fog(ViewportEvent.ComputeFogColor event) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            FogManager manager = FogManager.getManagerFor((ResourceKey<Level>)Minecraft.m_91087_().f_91074_.f_19853_.m_46472_());
            if (!manager.fogEvents.isEmpty() || manager.lastEvent != null) {
                float fogBlue;
                float fogGreen;
                float fogRed;
                FogEvent fogEvent;
                FogEvent fogEvent2 = fogEvent = manager.fogEvents.isEmpty() ? manager.lastEvent : FogManager.lastEntry(manager.fogEvents).getValue();
                if (fogEvent.color.isPresent()) {
                    fogRed = fogEvent.color.get().x;
                    fogGreen = fogEvent.color.get().y;
                    fogBlue = fogEvent.color.get().z;
                } else {
                    fogRed = event.getRed();
                    fogGreen = event.getGreen();
                    fogBlue = event.getBlue();
                }
                if (fogEvent.fullbright) {
                    float f9 = Math.max(fogRed, Math.max(fogGreen, fogBlue));
                    fogRed /= f9;
                    fogGreen /= f9;
                    fogBlue /= f9;
                }
                if (manager.interpolation > 0.0) {
                    manager.interpolation -= event.getPartialTick();
                    float f = Mth.m_14036_((float)((float)(manager.interpolation / 80.0)), (float)0.0f, (float)1.0f);
                    if (manager.fogEvents.isEmpty()) {
                        f = 1.0f - f;
                    }
                    event.setRed(Mth.m_14179_((float)f, (float)fogRed, (float)event.getRed()));
                    event.setGreen(Mth.m_14179_((float)f, (float)fogGreen, (float)event.getGreen()));
                    event.setBlue(Mth.m_14179_((float)f, (float)fogBlue, (float)event.getBlue()));
                    if (manager.interpolation <= 0.0) {
                        manager.lastEvent = null;
                    }
                } else {
                    event.setRed(fogRed);
                    event.setGreen(fogGreen);
                    event.setBlue(fogBlue);
                    manager.lastEvent = null;
                }
            }
        }
    }

    public record FogEvent(Optional<Vector3f> color, boolean fullbright) {
    }
}

