/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.util;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.attribute.IMagicAttribute;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.events.SpellTeleportEvent;
import io.redspace.ironsspellbooks.api.item.UpgradeData;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.IPresetSpellContainer;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.ISpellContainerMutable;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.compat.Curios;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.VisualFallingBlockEntity;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.spells.root.PreventDismount;
import io.redspace.ironsspellbooks.entity.spells.shield.ShieldEntity;
import io.redspace.ironsspellbooks.item.CastingItem;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.item.UniqueItem;
import io.redspace.ironsspellbooks.network.casting.CancelCastPacket;
import io.redspace.ironsspellbooks.network.casting.SyncTargetingDataPacket;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.setup.PacketDistributor;
import io.redspace.ironsspellbooks.util.ModTags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockCollisions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;

public class Utils {
    public static final RandomSource random = RandomSource.m_216337_();
    public static final Predicate<Holder<Attribute>> ONLY_MAGIC_ATTRIBUTES = attribute -> attribute.m_203334_() instanceof IMagicAttribute;
    public static final Predicate<Holder<Attribute>> NON_BASE_ATTRIBUTES = attribute -> attribute != ForgeMod.ENTITY_REACH.get() && attribute != Attributes.f_22281_ && attribute != Attributes.f_22283_ && attribute != Attributes.f_22282_;

    public static long getServerTick() {
        return IronsSpellbooks.OVERWORLD.m_46467_();
    }

    public static String getStackTraceAsString() {
        Stream<StackTraceElement> trace = Arrays.stream(Thread.currentThread().getStackTrace());
        StringBuffer sb = new StringBuffer();
        trace.forEach(item -> {
            sb.append(item.toString());
            sb.append("\n");
        });
        return sb.toString();
    }

    public static void spawnInWorld(Level level, BlockPos pos, ItemStack remaining) {
        if (!remaining.m_41619_()) {
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, remaining);
            itemEntity.m_32010_(40);
            itemEntity.m_20256_(itemEntity.m_20184_().m_82542_(0.0, 1.0, 0.0));
            level.m_7967_((Entity)itemEntity);
        }
    }

    public static boolean canBeUpgraded(ItemStack stack) {
        Item item = stack.m_41720_();
        boolean isUpgradeable = stack.m_204117_(ModTags.CAN_BE_UPGRADED);
        return !ServerConfigs.UPGRADE_BLACKLIST_ITEMS.contains(item) && (stack.m_41720_() instanceof SpellBook || stack.m_41720_() instanceof ArmorItem || stack.m_41720_() instanceof CastingItem || ServerConfigs.UPGRADE_WHITELIST_ITEMS.contains(item) || isUpgradeable);
    }

    public static String timeFromTicks(float ticks, int decimalPlaces) {
        float ticks_to_seconds = 20.0f;
        float seconds_to_minutes = 60.0f;
        String affix = "s";
        float time = ticks / ticks_to_seconds;
        if (time > seconds_to_minutes) {
            time /= seconds_to_minutes;
            affix = "m";
        }
        return Utils.stringTruncation(time, decimalPlaces) + affix;
    }

    public static boolean handleSpellTeleport(AbstractSpell spell, Entity entity, Vec3 destination) {
        SpellTeleportEvent event = new SpellTeleportEvent(spell, entity, destination.f_82479_, destination.f_82480_, destination.f_82481_);
        MinecraftForge.EVENT_BUS.post((Event)event);
        boolean canceled = event.isCanceled();
        if (!canceled) {
            entity.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        }
        return canceled;
    }

    public static double softCapFormula(double x) {
        return x <= 1.5 ? x : -0.25 * (1.0 / (x - 1.0)) + 2.0;
    }

    @Nullable
    public static ItemStack getPlayerSpellbookStack(@NotNull Player player) {
        return CuriosApi.getCuriosHelper().findCurio((LivingEntity)player, Curios.SPELLBOOK_SLOT, 0).map(SlotResult::stack).orElse(null);
    }

    public static void setPlayerSpellbookStack(@NotNull Player player, ItemStack itemStack) {
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curios -> curios.setEquippedCurio(Curios.SPELLBOOK_SLOT, 0, itemStack));
    }

    public static String stringTruncation(double f, int decimalPlaces) {
        if (f == Math.floor(f)) {
            return Integer.toString((int)f);
        }
        double multiplier = Math.pow(10.0, decimalPlaces);
        double truncatedValue = Math.floor(f * multiplier) / multiplier;
        String result = Double.toString(truncatedValue);
        result = (result = result.replaceAll("0*$", "")).endsWith(".") ? result.substring(0, result.length() - 1) : result;
        return result;
    }

    public static float intPow(float f, int exponent) {
        if (exponent == 0) {
            return 1.0f;
        }
        float b = f;
        for (int i = 1; i < Math.abs(exponent); ++i) {
            b *= f;
        }
        return exponent < 0 ? 1.0f / b : b;
    }

    public static double intPow(double d, int exponent) {
        if (exponent == 0) {
            return 1.0;
        }
        double b = d;
        for (int i = 1; i < Math.abs(exponent); ++i) {
            b *= d;
        }
        return exponent < 0 ? 1.0 / b : b;
    }

    public static float getAngle(Vec2 a, Vec2 b) {
        return Utils.getAngle(a.f_82470_, a.f_82471_, b.f_82470_, b.f_82471_);
    }

    public static float getAngle(double ax, double ay, double bx, double by) {
        return (float)Math.atan2(by - ay, bx - ax) + 3.141f;
    }

    public static BlockHitResult getTargetOld(Level level, Player player, ClipContext.Fluid clipContext, double reach) {
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        Vec3 vec3 = player.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3 vec31 = vec3.m_82520_((double)f6 * reach, (double)f5 * reach, (double)f7 * reach);
        return level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, clipContext, (Entity)player));
    }

    public static BlockHitResult getTargetBlock(Level level, LivingEntity entity, ClipContext.Fluid clipContext, double reach) {
        Vec3 rotation = entity.m_20154_().m_82541_().m_82490_(reach);
        Vec3 pos = entity.m_146892_();
        Vec3 dest = rotation.m_82549_(pos);
        return level.m_45547_(new ClipContext(pos, dest, ClipContext.Block.COLLIDER, clipContext, (Entity)entity));
    }

    public static boolean hasLineOfSight(Level level, Vec3 start, Vec3 end, boolean checkForShields) {
        HitResult shieldImpact;
        List shieldEntities;
        if (checkForShields && (shieldEntities = level.m_45976_(ShieldEntity.class, new AABB(start, end))).size() > 0 && (shieldImpact = Utils.checkEntityIntersecting((Entity)shieldEntities.get(0), start, end, 0.0f)).m_6662_() != HitResult.Type.MISS) {
            end = shieldImpact.m_82450_();
        }
        return level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_6662_() == HitResult.Type.MISS;
    }

    public static boolean hasLineOfSight(Level level, Entity entity1, Entity entity2, boolean checkForShields) {
        return Utils.hasLineOfSight(level, entity1.m_146892_(), entity2.m_20191_().m_82399_(), checkForShields);
    }

    public static BlockHitResult raycastForBlock(Level level, Vec3 start, Vec3 end, ClipContext.Fluid clipContext) {
        return level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, clipContext, null));
    }

    public static HitResult checkEntityIntersecting(Entity entity, Vec3 start, Vec3 end, float bbInflation) {
        Vec3 hitPos = null;
        if (entity.isMultipartEntity()) {
            for (PartEntity p : entity.getParts()) {
                Vec3 hit = p.m_20191_().m_82400_((double)bbInflation).m_82371_(start, end).orElse(null);
                if (hit == null) continue;
                hitPos = hit;
                break;
            }
        } else {
            hitPos = entity.m_20191_().m_82400_((double)bbInflation).m_82371_(start, end).orElse(null);
        }
        if (hitPos != null) {
            return new EntityHitResult(entity, hitPos);
        }
        return BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.UP, (BlockPos)BlockPos.m_274446_((Position)end));
    }

    public static Vec3 getPositionFromEntityLookDirection(Entity originEntity, float distance) {
        Vec3 start = originEntity.m_146892_();
        return originEntity.m_20154_().m_82541_().m_82490_((double)distance).m_82549_(start);
    }

    public static HitResult raycastForEntity(Level level, Entity originEntity, float distance, boolean checkForBlocks) {
        Vec3 start = originEntity.m_146892_();
        Vec3 end = originEntity.m_20154_().m_82541_().m_82490_((double)distance).m_82549_(start);
        return Utils.raycastForEntity(level, originEntity, start, end, checkForBlocks);
    }

    public static HitResult raycastForEntity(Level level, Entity originEntity, float distance, boolean checkForBlocks, float bbInflation) {
        Vec3 start = originEntity.m_146892_();
        Vec3 end = originEntity.m_20154_().m_82541_().m_82490_((double)distance).m_82549_(start);
        return Utils.internalRaycastForEntity(level, originEntity, start, end, checkForBlocks, bbInflation, Utils::canHitWithRaycast);
    }

    public static HitResult raycastForEntity(Level level, Entity originEntity, Vec3 start, Vec3 end, boolean checkForBlocks) {
        return Utils.internalRaycastForEntity(level, originEntity, start, end, checkForBlocks, 0.0f, Utils::canHitWithRaycast);
    }

    public static HitResult raycastForEntity(Level level, Entity originEntity, Vec3 start, Vec3 end, boolean checkForBlocks, float bbInflation, Predicate<? super Entity> filter) {
        return Utils.internalRaycastForEntity(level, originEntity, start, end, checkForBlocks, bbInflation, filter);
    }

    public static HitResult raycastForEntityOfClass(Level level, Entity originEntity, Vec3 start, Vec3 end, boolean checkForBlocks, Class<? extends Entity> c) {
        return Utils.internalRaycastForEntity(level, originEntity, start, end, checkForBlocks, 0.0f, entity -> entity.getClass() == c);
    }

    public static void releaseUsingHelper(LivingEntity entity, ItemStack itemStack, int ticksUsed) {
        ServerPlayer serverPlayer;
        MagicData pmd;
        if (entity instanceof ServerPlayer && (pmd = MagicData.getPlayerMagicData((LivingEntity)(serverPlayer = (ServerPlayer)entity))).isCasting()) {
            Utils.serverSideCancelCast(serverPlayer);
            serverPlayer.m_5810_();
        }
    }

    public static boolean serverSideInitiateCast(ServerPlayer serverPlayer) {
        SpellSelectionManager ssm = new SpellSelectionManager((Player)serverPlayer);
        SpellSelectionManager.SelectionOption spellItem = ssm.getSelection();
        if (spellItem != null) {
            SpellData spellData = ssm.getSelectedSpellData();
            if (spellData != SpellData.EMPTY) {
                MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
                if (playerMagicData.isCasting() && !playerMagicData.getCastingSpellId().equals(spellData.getSpell().getSpellId())) {
                    CancelCastPacket.cancelCast(serverPlayer, playerMagicData.getCastType() != CastType.LONG);
                }
                return spellData.getSpell().attemptInitiateCast(ItemStack.f_41583_, spellData.getSpell().getLevelFor(spellData.getLevel(), (LivingEntity)serverPlayer), serverPlayer.f_19853_, (Player)serverPlayer, spellItem.getCastSource(), true, spellItem.slot);
            }
        } else if (Utils.getPlayerSpellbookStack((Player)serverPlayer) == null) {
            Item item;
            ItemStack heldSpellbookStack = serverPlayer.m_21205_();
            if (!(heldSpellbookStack.m_41720_() instanceof SpellBook)) {
                heldSpellbookStack = serverPlayer.m_21206_();
            }
            if ((item = heldSpellbookStack.m_41720_()) instanceof SpellBook) {
                SpellBook spellBook = (SpellBook)item;
                spellBook.onEquipFromUse(new SlotContext(Curios.SPELLBOOK_SLOT, (LivingEntity)serverPlayer, 0, false, true), heldSpellbookStack);
                Utils.setPlayerSpellbookStack((Player)serverPlayer, heldSpellbookStack.m_41620_(1));
            }
        }
        return false;
    }

    public static double signedMin(double a, double b) {
        return (double)(a < 0.0 ? -1 : 1) * Math.min(Math.abs(a), Math.abs(b));
    }

    public static boolean serverSideInitiateQuickCast(ServerPlayer serverPlayer, int slot) {
        SpellData spellData;
        SpellSelectionManager.SelectionOption spellSelection = new SpellSelectionManager((Player)serverPlayer).getSpellSlot(slot);
        if (spellSelection != null && (spellData = spellSelection.spellData) != SpellData.EMPTY) {
            MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
            if (playerMagicData.isCasting() && !playerMagicData.getCastingSpellId().equals(spellData.getSpell().getSpellId())) {
                CancelCastPacket.cancelCast(serverPlayer, playerMagicData.getCastType() != CastType.LONG);
            }
            return spellData.getSpell().attemptInitiateCast(ItemStack.f_41583_, spellData.getSpell().getLevelFor(spellData.getLevel(), (LivingEntity)serverPlayer), serverPlayer.f_19853_, (Player)serverPlayer, CastSource.SPELLBOOK, true, Curios.SPELLBOOK_SLOT);
        }
        return false;
    }

    private static HitResult internalRaycastForEntity(Level level, Entity originEntity, Vec3 start, Vec3 end, boolean checkForBlocks, float bbInflation, Predicate<? super Entity> filter) {
        BlockHitResult blockHitResult = null;
        if (checkForBlocks) {
            blockHitResult = level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, originEntity));
            end = blockHitResult.m_82450_();
        }
        AABB range = originEntity.m_20191_().m_82369_(end.m_82546_(start));
        ArrayList<HitResult> hits = new ArrayList<HitResult>();
        List entities = level.m_6249_(originEntity, range, filter);
        for (Entity target : entities) {
            HitResult hit = Utils.checkEntityIntersecting(target, start, end, bbInflation);
            if (hit.m_6662_() == HitResult.Type.MISS) continue;
            hits.add(hit);
        }
        if (!hits.isEmpty()) {
            hits.sort(Comparator.comparingDouble(o -> o.m_82450_().m_82557_(start)));
            return (HitResult)hits.get(0);
        }
        if (checkForBlocks) {
            return blockHitResult;
        }
        return BlockHitResult.m_82426_((Vec3)end, (Direction)Direction.UP, (BlockPos)BlockPos.m_274446_((Position)end));
    }

    public static void serverSideCancelCast(ServerPlayer serverPlayer) {
        CancelCastPacket.cancelCast(serverPlayer, MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getCastingSpell().getSpell().getCastType() == CastType.CONTINUOUS);
    }

    public static void serverSideCancelCast(ServerPlayer serverPlayer, boolean triggerCooldown) {
        CancelCastPacket.cancelCast(serverPlayer, triggerCooldown);
    }

    public static float smoothstep(float a, float b, float x) {
        x = 6.0f * (x * x * x * x * x) - 15.0f * (x * x * x * x) + 10.0f * (x * x * x);
        return a + (b - a) * x;
    }

    public static boolean canHitWithRaycast(Entity entity) {
        return entity.m_6087_() && entity.m_6084_() && !entity.m_5833_();
    }

    public static int applyCooldownReduction(int baseTicks, @org.jetbrains.annotations.Nullable LivingEntity livingEntity) {
        double modifier = livingEntity == null ? 1.0 : livingEntity.m_21133_((Attribute)AttributeRegistry.COOLDOWN_REDUCTION.get());
        return (int)((double)baseTicks * (2.0 - Utils.softCapFormula(modifier)));
    }

    public static Vec2 rotationFromDirection(Vec3 vector) {
        float pitch = (float)Math.asin(vector.f_82480_);
        float yaw = (float)Math.atan2(vector.f_82479_, vector.f_82481_);
        return new Vec2(pitch, yaw);
    }

    public static boolean doMeleeAttack(Mob attacker, Entity target, DamageSource damageSource) {
        boolean flag;
        if (attacker.f_19853_.f_46443_) {
            return false;
        }
        float f = (float)attacker.m_21133_(Attributes.f_22281_);
        float f1 = (float)attacker.m_21133_(Attributes.f_22282_);
        if (target instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)attacker.m_21205_(), (MobType)((LivingEntity)target).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)attacker);
        }
        if (flag = DamageSources.applyDamage(target, f, damageSource)) {
            if (f1 > 0.0f && target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                ((LivingEntity)target).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(attacker.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attacker.m_146908_() * ((float)Math.PI / 180)))));
                attacker.m_20256_(attacker.m_20184_().m_82542_(0.6, 1.0, 0.6));
                livingTarget.m_6703_((LivingEntity)attacker);
            }
            EnchantmentHelper.m_44896_((LivingEntity)attacker, (Entity)target);
            attacker.m_21335_(target);
        }
        return flag;
    }

    public static double getRandomScaled(double scale) {
        return (2.0 * Math.random() - 1.0) * scale;
    }

    public static Vec3 getRandomVec3(double scale) {
        return new Vec3(Utils.getRandomScaled(scale), Utils.getRandomScaled(scale), Utils.getRandomScaled(scale));
    }

    public static Vector3f getRandomVec3f(double scale) {
        return new Vector3f((float)Utils.getRandomScaled(scale), (float)Utils.getRandomScaled(scale), (float)Utils.getRandomScaled(scale));
    }

    public static Vector3f v3f(Vec3 vec3) {
        return new Vector3f((float)vec3.f_82479_, (float)vec3.f_82480_, (float)vec3.f_82481_);
    }

    public static Vec3 v3d(Vector3f vec3) {
        return new Vec3((double)vec3.x, (double)vec3.y, (double)vec3.z);
    }

    public static Vec3 lerp(float f, Vec3 a, Vec3 b) {
        return a.m_82549_(b.m_82546_(a).m_82490_((double)f));
    }

    public static boolean shouldHealEntity(Entity healer, Entity target) {
        if (healer instanceof NeutralMob) {
            LivingEntity livingEntity;
            NeutralMob neutralMob = (NeutralMob)healer;
            if (target instanceof LivingEntity && neutralMob.m_21674_(livingEntity = (LivingEntity)target)) {
                return false;
            }
        }
        if (healer == target) {
            return true;
        }
        if (target.m_6095_().m_204039_(ModTags.ALWAYS_HEAL) && !(healer instanceof Enemy)) {
            return true;
        }
        if (target.m_7307_(healer) || healer.m_7307_(target)) {
            return true;
        }
        if (healer.m_5647_() != null) {
            return target.m_20031_(healer.m_5647_());
        }
        if (healer instanceof Player) {
            return target instanceof Player;
        }
        return healer.m_6095_().m_20674_() == target.m_6095_().m_20674_() && healer instanceof Enemy ^ target instanceof Enemy;
    }

    public static boolean canImbue(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof UniqueItem) {
            return false;
        }
        Item item = itemStack.m_41720_();
        if (ServerConfigs.IMBUE_BLACKLIST_ITEMS.contains(item)) {
            return false;
        }
        if (ServerConfigs.IMBUE_WHITELIST_ITEMS.contains(item)) {
            return true;
        }
        if (itemStack.m_41720_() instanceof SwordItem) {
            return true;
        }
        if (ISpellContainer.isSpellContainer(itemStack) && !(itemStack.m_41720_() instanceof Scroll) && !(itemStack.m_41720_() instanceof SpellBook)) {
            return true;
        }
        return itemStack.m_204117_(ModTags.CAN_BE_IMBUED);
    }

    public static ItemStack handleShriving(ItemStack baseStack) {
        ItemStack result = baseStack.m_41777_();
        if (result.m_150930_((Item)ItemRegistry.SCROLL.get())) {
            return ItemStack.f_41583_;
        }
        boolean hasResult = false;
        if (ISpellContainer.isSpellContainer(result) && !(result.m_41720_() instanceof SpellBook) && !(result.m_41720_() instanceof UniqueItem)) {
            if (result.m_41720_() instanceof IPresetSpellContainer) {
                ISpellContainerMutable spellContainer = ISpellContainer.get(result).mutableCopy();
                spellContainer.getActiveSpells().forEach(spellData -> spellContainer.removeSpell(spellData.getSpell()));
                ISpellContainer.set(result, spellContainer.toImmutable());
            } else {
                ISpellContainer.remove(result);
            }
            hasResult = true;
        }
        if (UpgradeData.hasUpgradeData(result)) {
            UpgradeData.removeUpgradeData(result);
            hasResult = true;
        }
        if (hasResult) {
            return result;
        }
        return ItemStack.f_41583_;
    }

    public static boolean validAntiMagicTarget(Entity entity) {
        return !entity.m_5833_() && (entity instanceof AntiMagicSusceptible || entity instanceof Player || entity instanceof IMagicEntity);
    }

    public static float findRelativeGroundLevel(Level level, Vec3 start, int maxSteps) {
        if (level.m_8055_(BlockPos.m_274446_((Position)start)).m_60828_((BlockGetter)level, BlockPos.m_274446_((Position)start))) {
            for (int i = 0; i < maxSteps; ++i) {
                BlockPos pos = BlockPos.m_274446_((Position)(start = start.m_82520_(0.0, 1.0, 0.0)));
                if (level.m_8055_(pos).m_60828_((BlockGetter)level, pos)) continue;
                return pos.m_123342_();
            }
        }
        return (float)level.m_45547_((ClipContext)new ClipContext((Vec3)start, (Vec3)start.m_82520_((double)0.0, (double)((double)(-maxSteps)), (double)0.0), (ClipContext.Block)ClipContext.Block.COLLIDER, (ClipContext.Fluid)ClipContext.Fluid.NONE, null)).m_82450_().f_82480_;
    }

    public static Vec3 moveToRelativeGroundLevel(Level level, Vec3 start, int maxSteps) {
        return Utils.moveToRelativeGroundLevel(level, start, maxSteps, maxSteps);
    }

    public static Vec3 moveToRelativeGroundLevel(Level level, Vec3 start, int maxStepsUp, int maxStepsDown) {
        BlockCollisions blockcollisions = new BlockCollisions((CollisionGetter)level, null, new AABB(0.0, 0.0, 0.0, 0.5, 0.5, 0.5).m_82383_(start), true, (p_286215_, p_286216_) -> p_286216_);
        if (blockcollisions.hasNext()) {
            for (int i = 1; i < maxStepsUp; ++i) {
                blockcollisions = new BlockCollisions((CollisionGetter)level, null, new AABB(0.0, 0.0, 0.0, 0.5, 0.5, 0.5).m_82383_(start.m_82520_(0.0, (double)i, 0.0)), true, (p_286215_, p_286216_) -> p_286216_);
                if (blockcollisions.hasNext()) continue;
                start = start.m_82520_(0.0, (double)i, 0.0);
                break;
            }
        }
        return level.m_45547_(new ClipContext(start, start.m_82520_(0.0, (double)(-maxStepsDown), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_82450_();
    }

    public static boolean checkMonsterSpawnRules(ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return !pLevel.m_204166_(pPos).m_203565_(Biomes.f_220594_) && !pLevel.m_204166_(pPos).m_203656_(Tags.Biomes.IS_MUSHROOM) && pLevel.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)pLevel, (BlockPos)pPos, (RandomSource)pRandom) && Monster.m_217057_((EntityType)((EntityType)EntityRegistry.NECROMANCER.get()), (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public static void sendTargetedNotification(ServerPlayer target, LivingEntity caster, AbstractSpell spell) {
        target.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"ui.irons_spellbooks.spell_target_warning", (Object[])new Object[]{caster.m_5446_().getString(), spell.getDisplayName((Player)target)}).m_130940_(ChatFormatting.LIGHT_PURPLE)));
    }

    public static boolean preCastTargetHelper(Level level, LivingEntity caster, MagicData playerMagicData, AbstractSpell spell, int range, float aimAssist) {
        return Utils.preCastTargetHelper(level, caster, playerMagicData, spell, range, aimAssist, true);
    }

    public static boolean preCastTargetHelper(Level level, LivingEntity caster, MagicData playerMagicData, AbstractSpell spell, int range, float aimAssist, boolean sendFailureMessage) {
        return Utils.preCastTargetHelper(level, caster, playerMagicData, spell, range, aimAssist, sendFailureMessage, x -> true);
    }

    public static boolean preCastTargetHelper(Level level, LivingEntity caster, MagicData playerMagicData, AbstractSpell spell, int range, float aimAssist, boolean sendFailureMessage, Predicate<LivingEntity> filter) {
        HitResult target = Utils.raycastForEntity(caster.f_19853_, (Entity)caster, range, true, aimAssist);
        LivingEntity livingTarget = null;
        if (target instanceof EntityHitResult) {
            LivingEntity livingEntity;
            EntityHitResult entityHit = (EntityHitResult)target;
            Entity entity = entityHit.m_82443_();
            if (entity instanceof LivingEntity && filter.test(livingEntity = (LivingEntity)entity)) {
                livingTarget = livingEntity;
            } else {
                Entity entity2;
                LivingEntity livingParent;
                PartEntity partEntity;
                entity = entityHit.m_82443_();
                if (entity instanceof PartEntity && (entity = (partEntity = (PartEntity)entity).getParent()) instanceof LivingEntity && !caster.equals((Object)(livingParent = (LivingEntity)entity)) && filter.test(livingParent)) {
                    livingTarget = livingParent;
                } else if (entityHit.m_82443_() instanceof PreventDismount && (entity2 = entityHit.m_82443_().m_146895_()) instanceof LivingEntity) {
                    LivingEntity livingRooted;
                    livingTarget = livingRooted = (LivingEntity)entity2;
                }
            }
        }
        if (livingTarget != null) {
            ServerPlayer serverPlayer;
            playerMagicData.setAdditionalCastData(new TargetEntityCastData(livingTarget));
            if (caster instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)caster;
                if (spell.getCastType() != CastType.INSTANT) {
                    PacketDistributor.sendToPlayer(serverPlayer, new SyncTargetingDataPacket(livingTarget, spell));
                }
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"ui.irons_spellbooks.spell_target_success", (Object[])new Object[]{livingTarget.m_5446_().getString(), spell.getDisplayName((Player)serverPlayer)}).m_130940_(ChatFormatting.GREEN)));
            }
            if (livingTarget instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)livingTarget;
                Utils.sendTargetedNotification(serverPlayer, caster, spell);
            }
            return true;
        }
        if (sendFailureMessage && caster instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)caster;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"ui.irons_spellbooks.cast_error_target").m_130940_(ChatFormatting.RED)));
        }
        return false;
    }

    public static void doMobBreakSuffocatingBlocks(LivingEntity entity) {
        Utils.doMobBreakSuffocatingBlocks(entity, Vec3.f_82478_);
    }

    public static void doMobBreakSuffocatingBlocks(LivingEntity entity, Vec3 offset) {
        if (ForgeEventFactory.getMobGriefingEvent((Level)entity.f_19853_, (Entity)entity)) {
            int l = Mth.m_14143_((float)(entity.m_20205_() / 2.0f + 1.0f));
            int i1 = Mth.m_14167_((float)entity.m_20206_());
            Vec3i o = new Vec3i(Math.round((float)offset.f_82479_), Math.round((float)offset.f_82480_), Math.round((float)offset.f_82481_));
            for (BlockPos blockpos : BlockPos.m_121976_((int)(entity.m_146903_() - l + o.m_123341_()), (int)(entity.m_146904_() + o.m_123342_()), (int)(entity.m_146907_() - l + o.m_123343_()), (int)(entity.m_146903_() + l + o.m_123341_()), (int)(entity.m_146904_() + i1 + o.m_123342_()), (int)(entity.m_146907_() + l + o.m_123343_()))) {
                BlockState blockstate = entity.f_19853_.m_8055_(blockpos);
                if (!blockstate.canEntityDestroy((BlockGetter)entity.m_9236_(), blockpos, (Entity)entity) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)entity, (BlockPos)blockpos, (BlockState)blockstate) || !entity.f_19853_.m_46953_(blockpos, true, (Entity)entity)) continue;
                entity.f_19853_.m_5898_(null, 1022, entity.m_20183_(), 0);
            }
        }
    }

    public static Vector3f deconstructRGB(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return new Vector3f((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
    }

    public static int packRGB(Vector3f color) {
        int red = (int)(color.x() * 255.0f);
        int green = (int)(color.y() * 255.0f);
        int blue = (int)(color.z() * 255.0f);
        return red << 16 | green << 8 | blue;
    }

    public static CompoundTag saveAllItems(CompoundTag pTag, NonNullList<ItemStack> pList, String location) {
        ListTag listtag = new ListTag();
        for (int i = 0; i < pList.size(); ++i) {
            ItemStack itemstack = (ItemStack)pList.get(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundtag);
            listtag.add((Object)compoundtag);
        }
        if (!listtag.isEmpty()) {
            pTag.m_128365_(location, (Tag)listtag);
        }
        return pTag;
    }

    public static void loadAllItems(CompoundTag pTag, NonNullList<ItemStack> pList, String location) {
        ListTag listtag = pTag.m_128437_(location, 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j < 0 || j >= pList.size()) continue;
            pList.set(j, (Object)ItemStack.m_41712_((CompoundTag)compoundtag));
        }
    }

    public static float getWeaponDamage(LivingEntity entity, MobType entityForDamageBonus) {
        if (entity != null) {
            float fist;
            float weapon = (float)entity.m_21133_(Attributes.f_22281_);
            if (weapon <= (fist = (float)entity.m_21172_(Attributes.f_22281_))) {
                weapon -= fist;
            }
            float enchant = EnchantmentHelper.m_44833_((ItemStack)entity.m_21205_(), (MobType)entityForDamageBonus);
            return weapon + enchant;
        }
        return 0.0f;
    }

    public static float getWeaponDamage(LivingEntity entity) {
        return Utils.getWeaponDamage(entity, MobType.f_21640_);
    }

    public static float clampedKnockbackResistanceFactor(Entity entity, float min, float max) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return Mth.m_14036_((float)(1.0f - (float)living.m_21133_(Attributes.f_22278_)), (float)min, (float)max);
        }
        return max;
    }

    public static int getEnchantmentLevel(Level level, ItemStack stack, Enchantment enchantment) {
        return stack.getEnchantmentLevel(enchantment);
    }

    @org.jetbrains.annotations.Nullable
    public static Holder<Enchantment> enchantmentFromKey(RegistryAccess registryAccess, ResourceKey<Enchantment> enchantmentkey) {
        Enchantment enchantment;
        Registry reg = registryAccess.m_6632_(Registries.f_256762_).orElse(null);
        if (reg != null && (enchantment = (Enchantment)reg.m_6246_(enchantmentkey)) != null) {
            return reg.m_263177_((Object)enchantment);
        }
        return null;
    }

    public static void createTremorBlock(Level level, BlockPos blockPos, float impulseStrength) {
        if (level.m_8055_(blockPos.m_7494_()).m_60795_() || level.m_8055_(blockPos.m_7494_().m_7494_()).m_60795_()) {
            VisualFallingBlockEntity fallingblockentity = new VisualFallingBlockEntity(level, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), level.m_8055_(blockPos), 10);
            fallingblockentity.m_20334_(0.0, impulseStrength, 0.0);
            level.m_7967_((Entity)fallingblockentity);
            if (!level.m_8055_(blockPos.m_7494_()).m_60795_()) {
                VisualFallingBlockEntity fallingblockentity2 = new VisualFallingBlockEntity(level, blockPos.m_123341_(), blockPos.m_123342_() + 1, blockPos.m_123343_(), level.m_8055_(blockPos.m_7494_()), 10);
                fallingblockentity2.m_20334_(0.0, impulseStrength, 0.0);
                level.m_7967_((Entity)fallingblockentity2);
            }
        }
    }

    public static void createTremorBlockWithState(Level level, BlockState state, BlockPos blockPos, float impulseStrength) {
        VisualFallingBlockEntity fallingblockentity = new VisualFallingBlockEntity(level, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), state, 10);
        fallingblockentity.m_20334_(0.0, impulseStrength, 0.0);
        level.m_7967_((Entity)fallingblockentity);
    }

    public static ItemStack setPotion(ItemStack itemStack, Holder<Potion> potion) {
        return PotionUtils.m_43549_((ItemStack)itemStack, (Potion)((Potion)potion.get()));
    }

    public static ItemStack setPotion(ItemStack itemStack, Potion potion) {
        return PotionUtils.m_43549_((ItemStack)itemStack, (Potion)potion);
    }

    public static void performTaunt(LivingEntity newTarget, float range, Predicate<Entity> selector) {
        Utils.performTaunt(newTarget, newTarget.f_19853_.m_6249_((Entity)newTarget, newTarget.m_20191_().m_82377_((double)range, (double)range, (double)range), entity -> entity.m_20280_((Entity)newTarget) < (double)(range * range) && selector.test((Entity)entity)));
    }

    public static void performTaunt(LivingEntity newTarget, List<Entity> targets) {
        targets.forEach(entity -> {
            if (entity instanceof Mob) {
                Mob tauntmob = (Mob)entity;
                MagicManager.spawnParticles(tauntmob.f_19853_, (ParticleOptions)ParticleTypes.f_123792_, tauntmob.m_20185_(), tauntmob.m_20188_() + (tauntmob.m_20191_().f_82292_ - tauntmob.m_20188_()) * 2.0, tauntmob.m_20189_(), 5, 0.3, 0.3, 0.3, 0.0, false);
                tauntmob.m_6710_(newTarget);
            }
        });
    }

    public static void particleTrail(Level level, Vec3 a, Vec3 b, ParticleOptions particleType) {
        double d = a.m_82554_(b) * 4.0;
        int i = 0;
        while ((double)i < d) {
            double p = (double)i / d;
            Vec3 vec = a.m_82549_(b.m_82546_(a).m_82490_(p));
            MagicManager.spawnParticles(level, particleType, vec.f_82479_, vec.f_82480_, vec.f_82481_, 1, 0.0, 0.0, 0.0, 0.0, true);
            ++i;
        }
    }

    public static Quaternionf rotationBetweenVectors(Vector3f from, Vector3f to) {
        Vector3f toNorm;
        Vector3f fromNorm = new Vector3f((Vector3fc)from).normalize();
        float dot = fromNorm.dot((Vector3fc)(toNorm = new Vector3f((Vector3fc)to).normalize()));
        if (dot >= 0.9999f) {
            return new Quaternionf().identity();
        }
        if (dot <= -0.9999f) {
            Vector3f perpendicular = new Vector3f(1.0f, 0.0f, 0.0f);
            if (Math.abs(fromNorm.x) > 0.9f) {
                perpendicular.set(0.0f, 1.0f, 0.0f);
            }
            perpendicular.cross((Vector3fc)fromNorm).normalize();
            return new Quaternionf().rotationAxis((float)Math.PI, (Vector3fc)perpendicular);
        }
        Vector3f axis = new Vector3f((Vector3fc)fromNorm).cross((Vector3fc)toNorm).normalize();
        float angle = (float)Math.acos(dot);
        return new Quaternionf().rotationAxis(angle, (Vector3fc)axis);
    }

    public static void addFreezeTicks(LivingEntity target, int ticks) {
        Utils.addFreezeTicks(target, ticks, target.m_146891_() * 5);
    }

    public static void addFreezeTicks(LivingEntity target, int ticks, int cap) {
        target.m_146917_(Math.min(target.m_146888_() + ticks, cap < 0 ? Integer.MAX_VALUE : cap));
    }

    public static Vec3 slerp(double t, Vec3 from, Vec3 to) {
        from = from.m_82541_();
        to = to.m_82541_();
        double dot = from.m_82526_(to);
        double theta = Math.acos(dot) * t;
        Vec3 relative = to.m_82546_(from.m_82490_(dot)).m_82541_();
        Vec3 result = from.m_82490_(Math.cos(theta)).m_82549_(relative.m_82490_(Math.sin(theta)));
        return result;
    }
}

