/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.modifier;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public interface BiomeContext {
    public static final Predicate<BiomeContext> OVERWORLD_BIOME = context -> MultiNoiseBiomeSourceParameterList.Preset.f_273915_.m_274593_().anyMatch(context::is);

    public ResourceKey<Biome> resource();

    public Biome biome();

    public boolean is(TagKey<Biome> var1);

    public boolean is(ResourceKey<Biome> var1);

    public boolean is(Predicate<BiomeContext> var1);

    public boolean hasFeature(ResourceKey<PlacedFeature> var1);

    default public boolean hasEntity(Supplier<EntityType<?>> entities) {
        return this.hasEntity((Set<Supplier<EntityType<?>>>)ImmutableSet.of(entities));
    }

    default public boolean hasEntity(Set<Supplier<EntityType<?>>> entitySet) {
        Set entities = entitySet.stream().map(Supplier::get).collect(Collectors.toSet());
        MobSpawnSettings settings = this.biome().m_47518_();
        return Arrays.stream(MobCategory.values()).flatMap(category -> settings.m_151798_(category).m_146338_().stream()).anyMatch(spawner -> entities.contains(spawner.f_48404_));
    }
}

