/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.mixin.client.emissive;

import com.blackgear.platform.client.v2.emissive.EmissiveSpriteHolder;
import com.blackgear.platform.client.v2.emissive.EmissiveSpriteLoader;
import com.blackgear.platform.client.v2.emissive.SpriteLoaderStitchContext;
import com.blackgear.platform.client.v2.emissive.SpriteResourceLoaderContext;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpriteLoader.class})
public class SpriteLoaderMixin {
    @Shadow
    @Final
    private ResourceLocation f_244500_;

    @ModifyArg(method={"loadAndStitch"}, at=@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;supplyAsync(Ljava/util/function/Supplier;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;", ordinal=0), index=0)
    private Supplier<List<Supplier<SpriteContents>>> platform$wrapContents(Supplier<List<Supplier<SpriteContents>>> contents) {
        EmissiveSpriteLoader context = EmissiveSpriteLoader.THREAD_LOCAL.get();
        if (context == null) {
            return contents;
        }
        EmissiveSpriteLoader.Controller control = context.getController(this.f_244500_);
        if (control == null) {
            return contents;
        }
        return () -> {
            SpriteResourceLoaderContext.THREAD_LOCAL.set(control::setEmissiveMappings);
            try {
                List list = (List)contents.get();
                return list;
            }
            finally {
                SpriteResourceLoaderContext.THREAD_LOCAL.remove();
            }
        };
    }

    @ModifyArg(method={"loadAndStitch"}, at=@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;thenApply(Ljava/util/function/Function;)Ljava/util/concurrent/CompletableFuture;", ordinal=0), index=0)
    private Function<List<SpriteContents>, SpriteLoader.Preparations> platform$wrapPreparations(Function<List<SpriteContents>, SpriteLoader.Preparations> preparations) {
        EmissiveSpriteLoader context = EmissiveSpriteLoader.THREAD_LOCAL.get();
        if (context == null) {
            return preparations;
        }
        final EmissiveSpriteLoader.Controller control = context.getController(this.f_244500_);
        if (control == null) {
            return preparations;
        }
        return contents -> {
            final Map<ResourceLocation, ResourceLocation> emissiveMappings = control.getEmissiveMappings();
            if (emissiveMappings == null) {
                return (SpriteLoader.Preparations)preparations.apply((List<SpriteContents>)contents);
            }
            SpriteLoaderStitchContext stitch = new SpriteLoaderStitchContext(){

                @Override
                public Map<ResourceLocation, ResourceLocation> getEmissiveMappings() {
                    return emissiveMappings;
                }

                @Override
                public void markHasEmissives() {
                    control.markHasEmissives();
                }
            };
            SpriteLoaderStitchContext.THREAD_LOCAL.set(stitch);
            try {
                SpriteLoader.Preparations preparations2 = (SpriteLoader.Preparations)preparations.apply((List<SpriteContents>)contents);
                return preparations2;
            }
            finally {
                SpriteLoaderStitchContext.THREAD_LOCAL.remove();
            }
        };
    }

    @Inject(method={"stitch"}, at={@At(value="RETURN")})
    private void platform$linkEmissiveSprites(List<SpriteContents> spriteContentsList, int mipmapLevels, Executor executor, CallbackInfoReturnable<SpriteLoader.Preparations> cir) {
        SpriteLoaderStitchContext context = SpriteLoaderStitchContext.THREAD_LOCAL.get();
        if (context == null) {
            return;
        }
        Map<ResourceLocation, ResourceLocation> emissiveMappings = context.getEmissiveMappings();
        Map sprites = ((SpriteLoader.Preparations)cir.getReturnValue()).f_243807_();
        emissiveMappings.forEach((id, emissiveId) -> {
            TextureAtlasSprite originalSprite = (TextureAtlasSprite)sprites.get(id);
            if (originalSprite == null) {
                return;
            }
            TextureAtlasSprite emissiveSprite = (TextureAtlasSprite)sprites.get(emissiveId);
            if (emissiveSprite != null) {
                ((EmissiveSpriteHolder)originalSprite).setEmissiveSprite(emissiveSprite);
                context.markHasEmissives();
            }
        });
    }
}

