/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.clickthrough.helpers;

import cc.cassian.clickthrough.ClickThrough;
import cc.cassian.clickthrough.compat.FastItemFramesCompat;
import cc.cassian.clickthrough.config.ModConfig;
import cc.cassian.clickthrough.config.ModLists;
import cc.cassian.clickthrough.helpers.forge.ModHelpersImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ModHelpers {
    public static ModConfig config = ModConfig.get();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isLoaded(String mod) {
        return ModHelpersImpl.isLoaded(mod);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean clothConfigInstalled() {
        return ModHelpersImpl.clothConfigInstalled();
    }

    public static boolean architecturyInstalled() {
        return ModHelpers.isLoaded("architectury");
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerKeybind() {
        ModHelpersImpl.registerKeybind();
    }

    public static String getSignRowText(SignBlockEntity sign, int row) {
        StringBuilder builder = new StringBuilder();
        return sign.m_277142_().m_277138_(row, true).getString();
    }

    public static Component fieldName(Field field) {
        return Component.m_237115_((String)("clickthrough.config." + field.getName()));
    }

    public static <T> T fieldGet(Object instance, Field field) {
        try {
            return (T)field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Consumer<T> fieldSetter(Object instance, Field field) {
        return t -> {
            try {
                field.set(instance, t);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isTaggedAsContainer(BlockState state) {
        return ModHelpersImpl.isTaggedAsContainer(state);
    }

    public static boolean isClickableBlockAt(BlockPos pos, ClientLevel world) {
        if (!ModConfig.get().onlycontainers) {
            return true;
        }
        BlockEntity entity = world.m_7702_(pos);
        BlockState state = world.m_8055_(pos);
        if (entity instanceof BaseContainerBlockEntity) {
            return true;
        }
        return ModHelpers.isTaggedAsContainer(state) || ModLists.containers.contains(state.m_60734_());
    }

    public static HitResult switchCrosshairTarget(HitResult crosshairTarget, LocalPlayer player, ClientLevel world) {
        if (!ModConfig.get().isActive) {
            return crosshairTarget;
        }
        ClickThrough.isDyeOnSign = false;
        if (crosshairTarget != null) {
            Entity entity;
            if (crosshairTarget.m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)crosshairTarget).m_82443_()) instanceof ItemFrame) {
                ItemFrame itemFrame = (ItemFrame)entity;
                BlockPos attachedPos = itemFrame.m_31748_().m_121945_(itemFrame.m_6350_().m_122424_());
                if (!player.m_6144_() && ModHelpers.isClickableBlockAt(attachedPos, world)) {
                    return new BlockHitResult(crosshairTarget.m_82450_(), itemFrame.m_6350_(), attachedPos, false);
                }
            } else if (crosshairTarget instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)crosshairTarget;
                BlockPos blockPos = blockHitResult.m_82425_();
                BlockState state = world.m_8055_(blockPos);
                Block block = state.m_60734_();
                if (block instanceof WallSignBlock) {
                    BlockPos attachedPos = blockPos.m_121945_(((Direction)state.m_61143_((Property)WallSignBlock.f_58064_)).m_122424_());
                    if (!ModHelpers.isClickableBlockAt(attachedPos, world)) {
                        return crosshairTarget;
                    }
                    BlockEntity entity2 = world.m_7702_(blockPos);
                    if (!(entity2 instanceof SignBlockEntity)) {
                        return crosshairTarget;
                    }
                    Item item = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
                    if (item instanceof DyeItem || item == Items.f_151056_) {
                        if (ModConfig.get().sneaktodye) {
                            ClickThrough.isDyeOnSign = true;
                            if (!player.m_6144_()) {
                                return new BlockHitResult(crosshairTarget.m_82450_(), blockHitResult.m_82434_(), attachedPos, false);
                            }
                        }
                    } else if (!player.m_6144_()) {
                        return new BlockHitResult(crosshairTarget.m_82450_(), blockHitResult.m_82434_(), attachedPos, false);
                    }
                } else if (block instanceof WallBannerBlock) {
                    BlockPos attachedPos = blockPos.m_121945_(((Direction)state.m_61143_((Property)WallBannerBlock.f_57916_)).m_122424_());
                    if (ModHelpers.isClickableBlockAt(attachedPos, world)) {
                        return new BlockHitResult(crosshairTarget.m_82450_(), blockHitResult.m_82434_(), attachedPos, false);
                    }
                } else if (ModHelpers.isLoaded("fastitemframes")) {
                    return FastItemFramesCompat.passthrough(block, state, blockPos, world, crosshairTarget, player);
                }
            }
        }
        return crosshairTarget;
    }
}

