/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.model;

import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedMaterials;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.DrawerModelProperties;
import com.jaquadro.minecraft.storagedrawers.block.tile.modelprops.FramedModelProperties;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.client.model.ModelContextSupplier;
import com.jaquadro.minecraft.storagedrawers.client.model.ParentModel;
import com.jaquadro.minecraft.storagedrawers.client.model.context.ModelContext;
import com.jaquadro.minecraft.storagedrawers.client.model.decorator.ModelDecorator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class PlatformDecoratedModel<C extends ModelContext>
extends ParentModel
implements IDynamicBakedModel {
    private final ModelDecorator<C> decorator;
    private final ModelContextSupplier<C> contextSupplier;

    public PlatformDecoratedModel(BakedModel parent, ModelDecorator<C> decorator, ModelContextSupplier<C> contextSupplier) {
        super(parent);
        this.decorator = decorator;
        this.contextSupplier = contextSupplier;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType type) {
        if (state == null) {
            return this.parent.getQuads(state, side, rand, extraData, type);
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Supplier<ModelContext> supplier = () -> this.contextSupplier.makeContext(state, side, rand, extraData, type);
        if (this.decorator.shouldRenderBase(supplier)) {
            quads.addAll(this.parent.getQuads(state, side, rand, extraData, type));
        }
        BiConsumer<BakedModel, RenderType> emitModel = (model, renderType) -> {
            if (model != null && renderType == type) {
                quads.addAll(model.getQuads(state, side, rand, extraData, type));
            }
        };
        try {
            this.decorator.emitQuads(supplier, emitModel);
        }
        catch (Exception e) {
            return quads;
        }
        return quads;
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        Item item;
        ItemStack side;
        MaterialData matData = null;
        if (data.has(DrawerModelProperties.MATERIAL)) {
            matData = new MaterialData((IFramedMaterials)data.get(DrawerModelProperties.MATERIAL));
        } else if (data.has(FramedModelProperties.MATERIAL)) {
            matData = new MaterialData((IFramedMaterials)data.get(FramedModelProperties.MATERIAL));
        }
        if (matData != null && (side = matData.getEffectiveSide()) != ItemStack.f_41583_ && (item = side.m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            BakedModel model = renderer.m_174264_(side, null, null, 0);
            return model.m_6160_();
        }
        return this.parent.getParticleIcon(data);
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of(this.decorator.getRenderTypes(state));
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        return this.decorator.getRenderTypes(itemStack);
    }

    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        if (this.decorator.shouldRenderItem()) {
            return List.of(new ItemRender(itemStack));
        }
        return this.parent.getRenderPasses(itemStack, fabulous);
    }

    public class ItemRender
    extends ParentModel {
        private ItemStack stack;
        private List<RenderType> lastRenderTypes;
        private int nextRenderType;

        public ItemRender(ItemStack stack) {
            super(PlatformDecoratedModel.this.parent);
            this.lastRenderTypes = new ArrayList<RenderType>();
            this.stack = stack;
        }

        @Override
        public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            ModelDecorator<ModelContext> decorator = PlatformDecoratedModel.this.decorator;
            Supplier<ModelContext> supplier = () -> PlatformDecoratedModel.this.contextSupplier.makeContext(this.stack);
            if (decorator.shouldRenderBase(supplier, this.stack)) {
                quads.addAll(PlatformDecoratedModel.this.parent.m_213637_(state, side, rand));
            }
            RenderType limitRenderType = this.nextRenderType < this.lastRenderTypes.size() ? this.lastRenderTypes.get(this.nextRenderType) : null;
            BiConsumer<BakedModel, RenderType> emitModel = (model, renderType) -> {
                if (renderType == RenderType.m_110451_()) {
                    renderType = Sheets.m_110789_();
                } else if (renderType == RenderType.m_110457_()) {
                    renderType = Sheets.m_110790_();
                } else if (renderType == RenderType.m_110466_()) {
                    renderType = Sheets.m_110792_();
                }
                if (limitRenderType != null && limitRenderType != renderType) {
                    return;
                }
                if (model != null) {
                    quads.addAll(model.m_213637_(state, side, rand));
                }
            };
            try {
                decorator.emitItemQuads(supplier, emitModel, this.stack);
                if (side == null) {
                    ++this.nextRenderType;
                }
            }
            catch (Exception e) {
                return quads;
            }
            return quads;
        }

        public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
            return PlatformDecoratedModel.this.parent.getRenderPasses(itemStack, fabulous);
        }

        public TextureAtlasSprite getParticleIcon(ModelData data) {
            return PlatformDecoratedModel.this.parent.getParticleIcon(data);
        }

        public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
            return PlatformDecoratedModel.this.getRenderTypes(state, rand, data);
        }

        public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
            this.lastRenderTypes = PlatformDecoratedModel.this.getRenderTypes(itemStack, fabulous);
            this.nextRenderType = 0;
            return this.lastRenderTypes;
        }
    }
}

