/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.enchantment;

import com.enderio.base.common.init.EIOEnchantments;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SoulBoundHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void deathHandler(LivingDropsEvent event) {
        if (event.getEntity() == null || event.getEntity() instanceof FakePlayer || event.isCanceled()) {
            return;
        }
        if (event.getEntity().m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
            return;
        }
        ArrayList<ItemStack> soulItems = new ArrayList<ItemStack>();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Iterator iter = event.getDrops().iterator();
            while (iter.hasNext()) {
                ItemEntity ei = (ItemEntity)iter.next();
                ItemStack item = ei.m_32055_();
                if (!SoulBoundHandler.isSoulBound(item)) continue;
                if (player.m_36356_(item)) {
                    iter.remove();
                }
                soulItems.add(item);
            }
            if (soulItems.isEmpty()) {
                return;
            }
            soulItems.forEach(arg_0 -> ((Player)player).m_36356_(arg_0));
        }
    }

    @SubscribeEvent
    public static void reviveHandler(PlayerEvent.Clone event) {
        if (!event.getOriginal().m_21224_()) {
            return;
        }
        if (event.getEntity().m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
            return;
        }
        event.getOriginal().m_150109_().f_35974_.forEach(item -> event.getEntity().m_36356_(item));
        event.getOriginal().m_150109_().f_35975_.forEach(armor -> event.getEntity().m_36356_(armor));
        event.getOriginal().m_150109_().f_35976_.forEach(offhand -> event.getEntity().m_36356_(offhand));
    }

    public static boolean isSoulBound(ItemStack item) {
        return item.getEnchantmentLevel((Enchantment)EIOEnchantments.SOULBOUND.get()) > 0;
    }
}

