/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.data.recipe;

import com.enderio.EnderIO;
import com.enderio.base.common.init.EIORecipes;
import com.enderio.core.data.recipes.EnderRecipeProvider;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class FireCraftingRecipeProvider
extends EnderRecipeProvider {
    public FireCraftingRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> finishedRecipeConsumer) {
        finishedRecipeConsumer.accept(new FinishedFireRecipe(EnderIO.loc("fire_crafting/infinity"), EnderIO.loc("fire_crafting/infinity"), 1, List.of(Blocks.f_50752_), List.of(), List.of(Level.f_46428_.m_135782_())));
    }

    protected static class FinishedFireRecipe
    extends EnderRecipeProvider.EnderFinishedRecipe {
        private final ResourceLocation lootTable;
        private final int maxItemDrops;
        private final List<Block> bases;
        private final List<TagKey<Block>> baseTags;
        private final List<ResourceLocation> dimensions;

        public FinishedFireRecipe(ResourceLocation id, ResourceLocation lootTable, int maxItemDrops, List<Block> bases, List<TagKey<Block>> baseTags, List<ResourceLocation> dimensions) {
            super(id);
            this.lootTable = lootTable;
            this.maxItemDrops = maxItemDrops;
            this.bases = bases;
            this.baseTags = baseTags;
            this.dimensions = dimensions;
        }

        @Override
        protected Set<String> getModDependencies() {
            return Set.of(this.lootTable.m_135827_());
        }

        @Override
        public void m_7917_(JsonObject json) {
            JsonObject obj;
            JsonArray basesJson = new JsonArray();
            for (Block block : this.bases) {
                obj = new JsonObject();
                obj.addProperty("block", ForgeRegistries.BLOCKS.getKey((Object)block).toString());
                basesJson.add((JsonElement)obj);
            }
            for (TagKey tagKey : this.baseTags) {
                obj = new JsonObject();
                obj.addProperty("tag", tagKey.f_203868_().toString());
                basesJson.add((JsonElement)obj);
            }
            JsonArray dimensionsJson = new JsonArray();
            for (ResourceLocation dimension : this.dimensions) {
                dimensionsJson.add(dimension.toString());
            }
            json.addProperty("loot_table", this.lootTable.toString());
            json.addProperty("max_item_drops", (Number)this.maxItemDrops);
            json.add("base_blocks", (JsonElement)basesJson);
            json.add("dimensions", (JsonElement)dimensionsJson);
            super.m_7917_(json);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)EIORecipes.FIRE_CRAFTING.serializer().get();
        }
    }
}

