/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.client.render.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.ai.brain.GlareBrain;
import com.faboslav.friendsandfoes.common.entity.ai.pathing.CachedPathHolder;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesCriterias;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.util.MovementUtil;
import com.faboslav.friendsandfoes.common.util.RandomGenerator;
import com.faboslav.friendsandfoes.common.util.particle.ParticleSpawner;
import com.mojang.serialization.Dynamic;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class GlareEntity
extends TamableAnimal
implements FlyingAnimal,
AnimatedEntity {
    private static final Vec3i ITEM_PICKUP_RANGE_EXPANDER = new Vec3i(1, 1, 1);
    public static final Predicate<ItemEntity> PICKABLE_FOOD_FILTER;
    private static final int GRUMPY_BITMASK = 2;
    private static final float MOVEMENT_SPEED = 0.1f;
    public static final int MIN_EYE_ANIMATION_TICK_AMOUNT = 10;
    public static final int LIGHT_THRESHOLD = 5;
    private static final EntityDataAccessor<Byte> GLARE_FLAGS;
    private Vec2 targetEyesPositionOffset;
    public CachedPathHolder cachedPathHolder = new CachedPathHolder();
    private AnimationContextTracker animationContextTracker;

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.animationContextTracker = new AnimationContextTracker();
        }
        return this.animationContextTracker;
    }

    public GlareEntity(EntityType<? extends GlareEntity> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new GlareMoveControl(this, 24, true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
        this.m_21553_(true);
        this.targetEyesPositionOffset = new Vec2(0.0f, 0.0f);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        GlareBrain.setDarkSpotLocatingCooldown(this);
        GlareBrain.setLocatingGlowBerriesCooldown(this);
        GlareBrain.setItemPickupCooldown(this);
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GLARE_FLAGS, (Object)0);
    }

    private boolean hasGlareFlag(int bitmask) {
        return ((Byte)this.f_19804_.m_135370_(GLARE_FLAGS) & bitmask) != 0;
    }

    private void setGlareFlag(int bitmask, boolean value) {
        byte glareFlags = (Byte)this.f_19804_.m_135370_(GLARE_FLAGS);
        if (value) {
            this.f_19804_.m_135381_(GLARE_FLAGS, (Object)((byte)(glareFlags | bitmask)));
        } else {
            this.f_19804_.m_135381_(GLARE_FLAGS, (Object)((byte)(glareFlags & ~bitmask)));
        }
    }

    public static boolean canSpawn(EntityType<GlareEntity> glareEntityEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        BlockState blockState = serverWorldAccess.m_8055_(blockPos.m_7495_());
        boolean isBelowSurfaceLevel = blockPos.m_123342_() < 63;
        boolean isSkyHidden = !serverWorldAccess.m_45527_(blockPos);
        boolean isBlockPosLightEnough = serverWorldAccess.m_46849_(blockPos, 0) > 5;
        boolean isRelatedBlock = blockState.m_204336_(FriendsAndFoesTags.GLARES_SPAWNABLE_ON);
        return isBelowSurfaceLevel && isRelatedBlock && isSkyHidden && isBlockPosLightEnough;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_() && this.m_6084_() && this.f_19797_ % 10 == 0) {
            this.m_5634_(1.0f);
        }
    }

    public void m_8119_() {
        if (!FriendsAndFoes.getConfig().enableGlare) {
            this.m_146870_();
        }
        super.m_8119_();
        this.updateTargetEyesPositionOffset();
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("glareBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("glareMemoryUpdate");
        GlareBrain.updateMemories(this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("glareActivityUpdate");
        GlareBrain.updateActivities(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public void m_7023_(Vec3 movementInput) {
        if (this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, movementInput);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, movementInput);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(this.m_6113_(), movementInput);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
            }
        }
        this.m_267651_(false);
    }

    protected Vec3i m_213552_() {
        return ITEM_PICKUP_RANGE_EXPANDER;
    }

    public boolean m_7243_(ItemStack itemStack) {
        return !itemStack.m_41619_() && itemStack.m_41720_() == Items.f_151079_ && super.m_7243_(itemStack);
    }

    public boolean m_21531_() {
        return !this.isItemPickupCoolingDown() && !this.isHoldingItem();
    }

    public boolean isHoldingItem() {
        return !this.m_21120_(InteractionHand.MAIN_HAND).m_41619_();
    }

    public boolean m_7066_(ItemStack stack) {
        return false;
    }

    private boolean isItemPickupCoolingDown() {
        return this.m_6274_().m_21876_(MemoryModuleType.f_217781_, MemoryStatus.VALUE_PRESENT);
    }

    private void dropItem(ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.m_9236_().m_7967_((Entity)itemEntity);
    }

    protected void m_7581_(ItemEntity item) {
        ItemStack itemStack = item.m_32055_();
        if (this.m_7252_(itemStack) && PICKABLE_FOOD_FILTER.test(item)) {
            int i = itemStack.m_41613_();
            if (i > 1) {
                this.dropItem(itemStack.m_41620_(i - 1));
            }
            ItemParticleOption particleEffect = new ItemParticleOption(ParticleTypes.f_123752_, itemStack);
            this.m_5634_(itemStack.m_41720_().m_41473_().m_38744_());
            this.playEatSound(itemStack);
            ParticleSpawner.spawnParticles((LivingEntity)this, (ParticleOptions)particleEffect, 7, 0.1);
            GlareBrain.setItemPickupCooldown(this);
            item.m_146870_();
        }
    }

    public Vec2 getTargetEyesPositionOffset() {
        return this.targetEyesPositionOffset;
    }

    public void setTargetEyesPositionOffset(float xEyePositionOffset, float yEyePositionOffset) {
        this.targetEyesPositionOffset = new Vec2(xEyePositionOffset, yEyePositionOffset);
    }

    private void updateTargetEyesPositionOffset() {
        if (this.f_19797_ % 10 != 0 || this.m_217043_().m_216332_(0, 2) != 0) {
            return;
        }
        this.setTargetEyesPositionOffset(-0.5f + this.m_217043_().m_188501_(), -0.4f + this.m_217043_().m_188501_() * 0.8f);
    }

    public static AttributeSupplier.Builder createGlareAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22280_, (double)0.1f).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, world){

            public boolean m_6342_(BlockPos pos) {
                boolean isValidPos = !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_() && !this.f_26495_.m_8055_(pos.m_7495_()).m_278721_();
                return isValidPos;
            }
        };
        birdNavigation.m_26440_(false);
        birdNavigation.m_7008_(false);
        birdNavigation.m_26443_(true);
        return birdNavigation;
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return GlareBrain.create(dynamic);
    }

    public Brain<GlareEntity> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    protected SoundEvent m_7515_() {
        return FriendsAndFoesSoundEvents.ENTITY_GLARE_AMBIENT.get();
    }

    public void m_8032_() {
        SoundEvent soundEvent = this.m_7515_();
        this.m_5496_(soundEvent, 0.025f, RandomGenerator.generateFloat(0.85f, 1.25f));
    }

    private SoundEvent getGrumpinessSound() {
        return FriendsAndFoesSoundEvents.ENTITY_GLARE_GRUMPINESS.get();
    }

    public void playGrumpinessSound() {
        SoundEvent soundEvent = this.getGrumpinessSound();
        this.m_5496_(soundEvent, 0.05f, RandomGenerator.generateFloat(1.2f, 1.3f));
    }

    private SoundEvent getGrumpinessShortSound() {
        return FriendsAndFoesSoundEvents.ENTITY_GLARE_GRUMPINESS_SHORT.get();
    }

    public void playGrumpinessShortSound() {
        SoundEvent soundEvent = this.getGrumpinessShortSound();
        this.m_5496_(soundEvent, 0.05f, RandomGenerator.generateFloat(1.2f, 1.3f));
    }

    private SoundEvent getRustleSound() {
        return FriendsAndFoesSoundEvents.ENTITY_GLARE_RUSTLE.get();
    }

    public void playRustleSound() {
        SoundEvent soundEvent = this.getRustleSound();
        this.m_5496_(soundEvent, 0.1f, 0.1f);
    }

    private SoundEvent getShakeSound() {
        return FriendsAndFoesSoundEvents.ENTITY_GLARE_SHAKE.get();
    }

    public void playShakeSound() {
        SoundEvent soundEvent = this.getShakeSound();
        this.m_5496_(soundEvent, 0.1f, 0.1f);
    }

    public SoundEvent m_7866_(ItemStack stack) {
        return FriendsAndFoesSoundEvents.ENTITY_GLARE_EAT.get();
    }

    public void playEatSound(ItemStack stack) {
        SoundEvent soundEvent = this.m_7866_(stack);
        this.m_5496_(soundEvent, 1.0f, 1.0f);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return FriendsAndFoesSoundEvents.ENTITY_GLARE_HURT.get();
    }

    protected void m_6677_(DamageSource source) {
        this.f_21363_ = -this.m_8100_();
        this.m_5496_(this.m_7975_(source), 1.0f, 0.5f);
    }

    protected SoundEvent m_5592_() {
        return FriendsAndFoesSoundEvents.ENTITY_GLARE_DEATH.get();
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item itemInHand = itemStack.m_41720_();
        boolean interactionResult = false;
        if (itemInHand == Items.f_151079_) {
            if (this.m_21824_() && this.m_21223_() < this.m_21233_() && !this.m_6898_(itemStack)) {
                interactionResult = this.tryToHealWithGlowBerries(player, itemStack);
            } else if (!this.m_21824_()) {
                interactionResult = this.tryToTameWithGlowBerries(player, itemStack);
            }
        }
        if (interactionResult) {
            this.m_146852_(GameEvent.f_223708_, (Entity)this);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        InteractionResult actionResult = super.m_6071_(player, hand);
        if (this.m_21830_((LivingEntity)player) && !actionResult.m_19077_()) {
            this.m_21839_(!this.m_21827_());
            if (this.m_21827_()) {
                MovementUtil.stopMovement((Mob)this);
            }
            return InteractionResult.SUCCESS;
        }
        return actionResult;
    }

    private boolean tryToHealWithGlowBerries(Player player, ItemStack itemStack) {
        if (this.m_21223_() == this.m_21233_()) {
            return false;
        }
        if (this.m_9236_().m_5776_()) {
            return true;
        }
        Item glowBerries = itemStack.m_41720_();
        if (glowBerries.m_41473_() == null) {
            return false;
        }
        this.m_5634_(glowBerries.m_41473_().m_38744_());
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        this.playEatSound(itemStack);
        ItemParticleOption particleEffect = new ItemParticleOption(ParticleTypes.f_123752_, itemStack);
        ParticleSpawner.spawnParticles((LivingEntity)this, (ParticleOptions)particleEffect, 7, 0.1);
        return true;
    }

    private boolean tryToTameWithGlowBerries(Player player, ItemStack itemStack) {
        if (this.m_9236_().m_5776_()) {
            return true;
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        this.playEatSound(itemStack);
        if (this.m_217043_().m_188503_(3) == 0) {
            this.m_21828_(player);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
        return true;
    }

    public boolean m_21827_() {
        return this.m_21825_();
    }

    public void m_21839_(boolean isSitting) {
        super.m_21839_(isSitting);
        super.m_21837_(isSitting);
    }

    @Nullable
    public GlobalPos getGlowBerriesPos() {
        return this.m_6274_().m_257414_(FriendsAndFoesMemoryModuleTypes.GLARE_GLOW_BERRIES_POS.get()).orElse(null);
    }

    public boolean canEatGlowBerriesAt(BlockPos pos) {
        BlockState blockState = this.m_9236_().m_8055_(pos);
        return CaveVines.m_152951_((BlockState)blockState);
    }

    @Nullable
    public GlobalPos getDarkSpotPos() {
        return this.m_6274_().m_257414_(FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get()).orElse(null);
    }

    public boolean isDarkSpotDark(BlockPos pos) {
        return this.m_9236_().m_45517_(LightLayer.BLOCK, pos) == 0;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    protected void m_203347_(TagKey<Fluid> tagKey) {
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_();
    }

    protected void m_21834_(boolean positive) {
        SimpleParticleType particleEffect = positive ? ParticleTypes.f_123750_ : ParticleTypes.f_123762_;
        for (int i = 0; i < 7; ++i) {
            double d = this.m_217043_().m_188583_() * 0.02;
            double e = this.m_217043_().m_188583_() * 0.02;
            double f = this.m_217043_().m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleEffect, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d, e, f);
        }
    }

    public void m_7105_(boolean tamed) {
        super.m_7105_(tamed);
        if (tamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
            this.m_21153_(this.m_21233_());
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(10.0);
        }
    }

    public void m_21828_(Player owner) {
        this.m_7105_(true);
        this.m_21816_(owner.m_20148_());
        if (owner instanceof ServerPlayer) {
            FriendsAndFoesCriterias.TAME_GLARE.trigger((ServerPlayer)owner, this);
        }
    }

    public EntityGetter m_9236_() {
        return this.m_9236_();
    }

    public boolean m_6898_(ItemStack itemStack) {
        return GlareBrain.getTemptItems().test(itemStack);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob entity) {
        GlareEntity glareEntity = (GlareEntity)FriendsAndFoesEntityTypes.GLARE.get().m_20615_((Level)serverWorld);
        if (!this.m_21824_()) {
            return null;
        }
        glareEntity.m_21816_(this.m_21805_());
        glareEntity.m_7105_(true);
        GlareBrain.setDarkSpotLocatingCooldown(this);
        GlareBrain.setLocatingGlowBerriesCooldown(this);
        GlareBrain.setItemPickupCooldown(this);
        return glareEntity;
    }

    public boolean m_7848_(Animal other) {
        if (other == this || !this.m_21824_() || !(other instanceof GlareEntity)) {
            return false;
        }
        GlareEntity glare = (GlareEntity)other;
        if (!glare.m_21824_() || glare.m_21825_()) {
            return false;
        }
        return this.m_27593_() && glare.m_27593_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().m_5776_()) {
            this.m_21839_(false);
            this.m_21573_().m_26517_(0.0);
            this.m_21573_().m_26573_();
        }
        return super.m_6469_(source, amount);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * 0.6, 0.0);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        if (this.m_6162_()) {
            return 0.5f;
        }
        return 1.0f;
    }

    public float m_6113_() {
        if (this.m_6162_()) {
            return 0.05f;
        }
        return 0.1f;
    }

    public void setGrumpy(boolean grumpy) {
        this.setGlareFlag(2, grumpy);
    }

    public boolean isGrumpy() {
        return this.hasGlareFlag(2);
    }

    static {
        GLARE_FLAGS = SynchedEntityData.m_135353_(GlareEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        PICKABLE_FOOD_FILTER = itemEntity -> itemEntity.m_32055_().m_204117_(FriendsAndFoesTags.GLARE_FOOD_ITEMS) && itemEntity.m_6084_() && !itemEntity.m_32063_();
    }

    final class GlareMoveControl
    extends FlyingMoveControl {
        public GlareMoveControl(GlareEntity glare, int maxPitchChange, boolean noGravity) {
            super((Mob)glare, maxPitchChange, noGravity);
        }

        public void m_8126_() {
            if (GlareEntity.this.m_21827_()) {
                return;
            }
            super.m_8126_();
        }
    }
}

