/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.DumpAllTagsCommand;
import slimeknights.mantle.command.DumpTagCommand;
import slimeknights.mantle.command.GeneratePackHelper;

public class DumpLootModifiers {
    protected static final ResourceLocation GLOBAL_LOOT_MODIFIERS = new ResourceLocation("forge", "loot_modifiers/global_loot_modifiers.json");
    private static final String LOOT_MODIFIER_PATH = GLOBAL_LOOT_MODIFIERS.m_135827_() + "/" + GLOBAL_LOOT_MODIFIERS.m_135815_();
    private static final Component LOOT_MODIFIER_SUCCESS_LOG = Component.m_237115_((String)"command.mantle.dump_loot_modifiers.success_log");
    protected static final SimpleCommandExceptionType ERROR_READING_LOOT_MODIFIERS = new SimpleCommandExceptionType((Message)Component.m_237110_((String)"command.mantle.dump_loot_modifiers.read_error", (Object[])new Object[]{GLOBAL_LOOT_MODIFIERS}));

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(1))).then(Commands.m_82127_((String)"save").executes(source -> DumpLootModifiers.run((CommandContext<CommandSourceStack>)source, true)))).then(Commands.m_82127_((String)"log").executes(source -> DumpLootModifiers.run((CommandContext<CommandSourceStack>)source, false)));
    }

    private static int run(CommandContext<CommandSourceStack> context, boolean saveFile) throws CommandSyntaxException {
        ArrayList<ResourceLocation> finalLocations = new ArrayList<ResourceLocation>();
        ResourceManager manager = ((CommandSourceStack)context.getSource()).m_81377_().m_177941_();
        for (Object resource : manager.m_213829_(GLOBAL_LOOT_MODIFIERS)) {
            try {
                BufferedReader reader = resource.m_215508_();
                try {
                    JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)DumpTagCommand.GSON, (Reader)reader, JsonObject.class);
                    if (json == null) {
                        Mantle.logger.error("Couldn't load global loot modifiers from {} in data pack {} as it is empty or null", (Object)GLOBAL_LOOT_MODIFIERS, (Object)resource.m_215506_());
                        continue;
                    }
                    if (GsonHelper.m_13855_((JsonObject)json, (String)"replace", (boolean)false)) {
                        finalLocations.clear();
                    }
                    JsonArray entryList = GsonHelper.m_13933_((JsonObject)json, (String)"entries");
                    for (JsonElement entry : entryList) {
                        ResourceLocation res = ResourceLocation.m_135820_((String)GsonHelper.m_13805_((JsonElement)entry, (String)"entry"));
                        if (res == null) continue;
                        finalLocations.remove(res);
                        finalLocations.add(res);
                    }
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (IOException | RuntimeException ex) {
                Mantle.logger.error("Couldn't read global loot modifier list {} in data pack {}", (Object)GLOBAL_LOOT_MODIFIERS, (Object)resource.m_215506_(), (Object)ex);
            }
        }
        JsonArray entries = new JsonArray();
        for (ResourceLocation location : finalLocations) {
            entries.add(location.toString());
        }
        JsonObject json = new JsonObject();
        json.addProperty("replace", Boolean.valueOf(false));
        json.add("entries", (JsonElement)entries);
        if (saveFile) {
            File output = new File(DumpAllTagsCommand.getOutputFile(context), LOOT_MODIFIER_PATH);
            Path path = output.toPath();
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    writer.write(DumpTagCommand.GSON.toJson((JsonElement)json));
                }
            }
            catch (IOException ex) {
                Mantle.logger.error("Couldn't save global loot manager to {}", (Object)path, (Object)ex);
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.mantle.dump_loot_modifiers.success_save", (Object[])new Object[]{GeneratePackHelper.getOutputComponent(output)}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> LOOT_MODIFIER_SUCCESS_LOG, true);
            Mantle.logger.info("Dump of global loot modifiers:\n{}", (Object)DumpTagCommand.GSON.toJson((JsonElement)json));
        }
        return finalLocations.size();
    }
}

