/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagLoader;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.DumpAllTagsCommand;
import slimeknights.mantle.command.GeneratePackHelper;
import slimeknights.mantle.command.ViewTagCommand;
import slimeknights.mantle.command.argument.TagSource;
import slimeknights.mantle.command.argument.TagSourceArgument;
import slimeknights.mantle.util.JsonHelper;

public class DumpTagCommand {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(1))).then(Action.LOG.build())).then(Action.SAVE.build())).then(Action.SOURCES.build());
    }

    private static int run(CommandContext<CommandSourceStack> context, Action action) throws CommandSyntaxException {
        return DumpTagCommand.runGeneric(context, TagSourceArgument.get(context), action);
    }

    public static void parseTag(List<Resource> resources, List<TagLoader.EntryWithSource> list, ResourceLocation regName, ResourceLocation tagName, ResourceLocation path) {
        for (Resource resource : resources) {
            String packId = resource.m_215506_();
            try {
                BufferedReader reader = resource.m_215508_();
                try {
                    TagFile tagfile = (TagFile)JsonHelper.parse(TagFile.f_215958_, reader);
                    if (tagfile.f_215960_()) {
                        list.clear();
                    }
                    tagfile.f_215959_().forEach(tag -> list.add(new TagLoader.EntryWithSource(tag, packId)));
                    tagfile.remove().forEach(tag -> list.add(new TagLoader.EntryWithSource(tag, packId, true)));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (IOException | RuntimeException ex) {
                Mantle.logger.error("Couldn't read {} tag list {} from {} in data pack {}", (Object)regName, (Object)tagName, (Object)path, (Object)packId, (Object)ex);
            }
        }
    }

    public static String tagToJson(List<TagLoader.EntryWithSource> entries) {
        return GSON.toJson(JsonHelper.serialize(TagFile.f_215958_, new TagFile(entries.stream().filter(e -> !e.remove()).map(TagLoader.EntryWithSource::f_216042_).toList(), true, entries.stream().filter(TagLoader.EntryWithSource::remove).map(TagLoader.EntryWithSource::f_216042_).toList())));
    }

    public static void saveTag(List<TagLoader.EntryWithSource> entries, Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(DumpTagCommand.tagToJson(entries));
            }
        }
        catch (IOException ex) {
            Mantle.logger.error("Couldn't save tag to {}", (Object)path, (Object)ex);
        }
    }

    private static <T> int runGeneric(CommandContext<CommandSourceStack> context, TagSource<T> registry, Action action) throws CommandSyntaxException {
        ResourceLocation path;
        ResourceLocation regName = registry.key().m_135782_();
        ResourceLocation name = (ResourceLocation)context.getArgument("name", ResourceLocation.class);
        ResourceManager manager = ((CommandSourceStack)context.getSource()).m_81377_().m_177941_();
        List resources = manager.m_213829_(path = new ResourceLocation(name.m_135827_(), registry.folder() + "/" + name.m_135815_() + ".json"));
        if (resources.isEmpty() && !registry.hasTag(name)) {
            throw ViewTagCommand.TAG_NOT_FOUND.create((Object)regName, (Object)name);
        }
        ArrayList<TagLoader.EntryWithSource> list = new ArrayList<TagLoader.EntryWithSource>();
        DumpTagCommand.parseTag(resources, list, regName, name, path);
        switch (action) {
            case SAVE: {
                Path output = DumpAllTagsCommand.getOutputFile(context).toPath().resolve(path.m_135827_() + "/" + path.m_135815_());
                DumpTagCommand.saveTag(list, output);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.mantle.dump_tag.success_log", (Object[])new Object[]{regName, name, GeneratePackHelper.getOutputComponent(output)}), true);
                break;
            }
            case LOG: {
                MutableComponent message = Component.m_237110_((String)"command.mantle.dump_tag.success", (Object[])new Object[]{regName, name});
                ((CommandSourceStack)context.getSource()).m_288197_(() -> DumpTagCommand.lambda$runGeneric$5((Component)message), true);
                Mantle.logger.info("Tag dump of {} tag '{}':\n{}", (Object)regName, (Object)name, (Object)DumpTagCommand.tagToJson(list));
                break;
            }
            case SOURCES: {
                MutableComponent message = Component.m_237110_((String)"command.mantle.dump_tag.success", (Object[])new Object[]{regName, name});
                ((CommandSourceStack)context.getSource()).m_288197_(() -> DumpTagCommand.lambda$runGeneric$6((Component)message), true);
                StringBuilder builder = new StringBuilder();
                builder.append("Tag list dump of ").append(regName).append(" tag ").append(name).append(" with sources:");
                for (TagLoader.EntryWithSource entry : list) {
                    if (entry.remove()) {
                        builder.append("\n- '");
                    } else {
                        builder.append("\n+ '");
                    }
                    builder.append(entry.f_216042_()).append("' from '").append(entry.f_216043_()).append('\'');
                }
                Mantle.logger.info(builder.toString());
            }
        }
        return resources.size();
    }

    private static /* synthetic */ Component lambda$runGeneric$6(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$runGeneric$5(Component message) {
        return message;
    }

    private static enum Action {
        SAVE,
        LOG,
        SOURCES;


        public ArgumentBuilder<CommandSourceStack, ?> build() {
            return Commands.m_82127_((String)this.name().toLowerCase()).then(TagSourceArgument.argument().then(TagSourceArgument.tagArgument("name").executes(context -> DumpTagCommand.run((CommandContext<CommandSourceStack>)context, this))));
        }
    }
}

