/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.common;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.util.typed.TypedMap;

public record GsonLoadable<T>(Gson gson, Class<T> classType) implements Loadable<T>
{
    @Override
    public T convert(JsonElement json, String s, TypedMap context) {
        return (T)this.gson.fromJson(json, this.classType);
    }

    @Override
    public JsonElement serialize(T object) {
        return this.gson.toJsonTree(object, this.classType);
    }

    @Override
    public T decode(FriendlyByteBuf buffer, TypedMap context) {
        CompoundTag tag = buffer.m_130261_();
        if (tag != null) {
            return (T)this.gson.fromJson((JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)tag), this.classType);
        }
        throw new DecoderException("Failed to decode: " + this.classType.getSimpleName());
    }

    @Override
    public void encode(FriendlyByteBuf buffer, T object) {
        Tag tag = (Tag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, this.gson.toJsonTree(object, this.classType));
        if (tag.m_7060_() != 10) {
            throw new EncoderException("Serialized wrong NBT tag type " + tag);
        }
        buffer.m_130079_((CompoundTag)tag);
    }
}

