/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.utils;

import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.utils.ItemUtils;
import earth.terrarium.adastra.common.utils.ModUtils;
import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.fluid.FluidApi;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.impl.WrappedBlockFluidContainer;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.material.Fluid;

public class TransferUtils {
    public static void pushEnergyNearby(ContainerMachineBlockEntity machine, BlockPos pos, long amount, ConfigurationEntry sideConfig, Predicate<Direction> filter) {
        EnergyContainer container = EnergyContainer.of((BlockEntity)machine, null);
        if (container == null) {
            return;
        }
        if (container.getStoredEnergy() == 0L) {
            return;
        }
        for (Map.Entry<Direction, Configuration> entry : sideConfig.sides().entrySet()) {
            EnergyContainer nearbyContainer;
            BlockEntity nearbyEntity;
            Direction direction;
            Configuration configuration = entry.getValue();
            if (!configuration.canPush() || !filter.test(direction = ModUtils.relative(machine, entry.getKey())) || (nearbyEntity = machine.level().m_7702_(pos.m_121945_(direction))) == null || (nearbyContainer = EnergyContainer.of((BlockEntity)nearbyEntity, (Direction)direction.m_122424_())) == null) continue;
            EnergyApi.moveEnergy((EnergyContainer)container, (EnergyContainer)nearbyContainer, (long)amount, (boolean)false);
        }
    }

    public static void pullEnergyNearby(ContainerMachineBlockEntity machine, BlockPos pos, long amount, ConfigurationEntry sideConfig, Predicate<Direction> filter) {
        EnergyContainer container = EnergyContainer.of((BlockEntity)machine, null);
        if (container == null) {
            return;
        }
        for (Map.Entry<Direction, Configuration> entry : sideConfig.sides().entrySet()) {
            EnergyContainer nearbyContainer;
            BlockEntity nearbyEntity;
            Direction direction;
            Configuration configuration = entry.getValue();
            if (!configuration.canPull() || !filter.test(direction = ModUtils.relative(machine, entry.getKey())) || (nearbyEntity = machine.level().m_7702_(pos.m_121945_(direction))) == null || (nearbyContainer = EnergyContainer.of((BlockEntity)nearbyEntity, (Direction)direction.m_122424_())) == null) continue;
            EnergyApi.moveEnergy((EnergyContainer)nearbyContainer, (EnergyContainer)container, (long)amount, (boolean)false);
        }
    }

    public static void pushFluidNearby(ContainerMachineBlockEntity machine, BlockPos pos, WrappedBlockFluidContainer container, long amount, int tank, ConfigurationEntry sideConfig, Predicate<Direction> filter) {
        if (container.isEmpty()) {
            return;
        }
        for (Map.Entry<Direction, Configuration> entry : sideConfig.sides().entrySet()) {
            FluidHolder holder;
            FluidContainer nearbyContainer;
            BlockEntity nearbyEntity;
            Direction direction;
            Configuration configuration = entry.getValue();
            if (!configuration.canPush() || !filter.test(direction = ModUtils.relative(machine, entry.getKey())) || (nearbyEntity = machine.level().m_7702_(pos.m_121945_(direction))) == null || !FluidContainer.holdsFluid((BlockEntity)nearbyEntity, (Direction)direction) || (nearbyContainer = FluidContainer.of((BlockEntity)nearbyEntity, (Direction)direction.m_122424_())) == null || (holder = (FluidHolder)container.getFluids().get(tank)).isEmpty() || FluidApi.moveFluid((FluidContainer)container, (FluidContainer)nearbyContainer, (FluidHolder)FluidHolder.ofMillibuckets((Fluid)holder.getFluid(), (long)amount), (boolean)false) <= 0L) continue;
            machine.sync();
        }
    }

    public static void pullFluidNearby(ContainerMachineBlockEntity machine, BlockPos pos, WrappedBlockFluidContainer container, long amount, int tank, ConfigurationEntry sideConfig, Predicate<Direction> filter) {
        for (Map.Entry<Direction, Configuration> entry : sideConfig.sides().entrySet()) {
            FluidHolder holder;
            FluidContainer nearbyContainer;
            BlockEntity nearbyEntity;
            Direction direction;
            Configuration configuration = entry.getValue();
            if (!configuration.canPull() || !filter.test(direction = ModUtils.relative(machine, entry.getKey())) || (nearbyEntity = machine.level().m_7702_(pos.m_121945_(direction))) == null || !FluidContainer.holdsFluid((BlockEntity)nearbyEntity, (Direction)direction) || (nearbyContainer = FluidContainer.of((BlockEntity)nearbyEntity, (Direction)direction.m_122424_())) == null || (holder = (FluidHolder)nearbyContainer.getFluids().get(tank)).isEmpty() || FluidApi.moveFluid((FluidContainer)nearbyContainer, (FluidContainer)container, (FluidHolder)FluidHolder.ofMillibuckets((Fluid)holder.getFluid(), (long)amount), (boolean)false) <= 0L) continue;
            machine.sync();
        }
    }

    public static void pushItemsNearby(ContainerMachineBlockEntity machine, BlockPos pos, int[] slots, ConfigurationEntry sideConfig, Predicate<Direction> filter) {
        if (machine.m_7983_()) {
            return;
        }
        for (Map.Entry<Direction, Configuration> entry : sideConfig.sides().entrySet()) {
            Container nearbyContainer;
            Direction direction;
            Configuration configuration = entry.getValue();
            if (!configuration.canPush() || !filter.test(direction = ModUtils.relative(machine, entry.getKey())) || (nearbyContainer = HopperBlockEntity.m_59390_((Level)machine.level(), (BlockPos)pos.m_121945_(direction))) == null) continue;
            ItemUtils.push(machine, nearbyContainer, slots, direction);
        }
    }

    public static void pullItemsNearby(ContainerMachineBlockEntity machine, BlockPos pos, int[] slots, ConfigurationEntry sideConfig, Predicate<Direction> filter) {
        for (Map.Entry<Direction, Configuration> entry : sideConfig.sides().entrySet()) {
            Container nearbyContainer;
            Direction direction;
            Configuration configuration = entry.getValue();
            if (!configuration.canPull() || !filter.test(direction = ModUtils.relative(machine, entry.getKey())) || (nearbyContainer = HopperBlockEntity.m_59390_((Level)machine.level(), (BlockPos)pos.m_121945_(direction))) == null) continue;
            ItemUtils.pull(nearbyContainer, machine, slots, direction);
        }
    }
}

