/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.capability;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BLHBlockItemHandlerItemStack
implements IItemHandler {
    public final ItemStack stack;
    public final int slotLimit;

    public BLHBlockItemHandlerItemStack(ItemStack stack, int slotLimit) {
        this.stack = stack;
        this.slotLimit = slotLimit;
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        ItemStack copied = this.getStack();
        copied.m_41764_(this.getAmount());
        return copied;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.isItemValid(slot, stack)) {
            int amount = this.getSlotLimit(slot);
            int stored = this.getAmount();
            int inserted = Math.min(amount - stored, stack.m_41613_());
            if (this.getVoid()) {
                inserted = stack.m_41613_();
            }
            if (!simulate) {
                this.setStack(stack);
                this.setAmount(Math.min(stored + inserted, amount));
            }
            if (inserted == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - inserted));
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack blStack = this.getStack();
        int stored = this.getAmount();
        if (blStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (stored <= amount) {
            ItemStack out = blStack.m_41777_();
            int newAmount = stored;
            if (!simulate) {
                this.setAmount(0);
            }
            out.m_41764_(newAmount);
            return out;
        }
        if (!simulate) {
            this.setAmount(stored - amount);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)blStack, (int)amount);
    }

    public int getSlotLimit(int slot) {
        return this.slotLimit;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        ItemStack current = this.getStack();
        return current.m_41619_() || ItemStack.m_150942_((ItemStack)current, (ItemStack)stack);
    }

    public int getAmount() {
        CompoundTag tag = this.getTag();
        if (tag != null && tag.m_128441_("stored")) {
            return tag.m_128451_("stored");
        }
        return 0;
    }

    public ItemStack getStack() {
        CompoundTag tag = this.getTag();
        if (tag != null && tag.m_128441_("blStack")) {
            return ItemStack.m_41712_((CompoundTag)tag.m_128469_("blStack"));
        }
        return ItemStack.f_41583_;
    }

    public boolean getVoid() {
        CompoundTag tag = this.getTag();
        if (tag != null && tag.m_128441_("voidItems")) {
            return tag.m_128471_("voidItems");
        }
        return true;
    }

    private void setAmount(int amount) {
        CompoundTag tag = this.getTag();
        if (tag == null) {
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.m_128365_("BlockEntityTag", (Tag)new CompoundTag());
            this.stack.m_41751_(compoundNBT);
        }
        this.stack.m_41783_().m_128469_("BlockEntityTag").m_128405_("stored", amount);
    }

    private void setStack(ItemStack stack) {
        CompoundTag tag = this.getTag();
        if (tag == null) {
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.m_128365_("BlockEntityTag", (Tag)new CompoundTag());
            this.stack.m_41751_(compoundNBT);
        }
        if (!stack.m_41619_()) {
            stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
        }
        this.stack.m_41783_().m_128469_("BlockEntityTag").m_128365_("blStack", (Tag)stack.serializeNBT());
        this.stack.m_41783_().m_128469_("BlockEntityTag").m_128379_("hasNBT", stack.m_41782_());
    }

    private CompoundTag getTag() {
        if (this.stack.m_41782_() && this.stack.m_41783_().m_128441_("BlockEntityTag")) {
            return this.stack.m_41783_().m_128469_("BlockEntityTag");
        }
        return null;
    }
}

