/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.client.screen.codex.pages.recipe.vanilla;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.client.screen.codex.pages.BookPage;
import com.sammy.malum.client.screen.codex.screens.AbstractMalumScreen;
import com.sammy.malum.client.screen.codex.screens.EntryScreen;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.fml.ModList;

public class CraftingPage
extends BookPage {
    private final ItemStack outputStack;
    private final List<ItemStack> inputStacks;

    public CraftingPage(ItemStack outputStack, List<ItemStack> inputStacks) {
        super(MalumMod.malumPath("textures/gui/book/pages/crafting_page.png"));
        this.outputStack = outputStack;
        this.inputStacks = inputStacks;
    }

    public CraftingPage(ItemStack outputStack, ItemStack ... inputStacks) {
        this(outputStack, List.of(inputStacks));
    }

    public CraftingPage(Item outputItem, Item ... inputItems) {
        this(outputItem.m_7968_(), inputItems);
    }

    public CraftingPage(ItemStack outputStack, Item ... inputItems) {
        this(outputStack, Arrays.stream(inputItems).map(Item::m_7968_).toList());
    }

    @Override
    public void render(EntryScreen screen, GuiGraphics guiGraphics, int left, int top, int mouseX, int mouseY, float partialTicks, boolean isRepeat) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack stack;
                int index = i * 3 + j;
                if (this.inputStacks.size() <= index || (stack = this.inputStacks.get(index)).m_41619_()) continue;
                int itemPosX = left + 41 + j * 22;
                int itemPosY = top + 34 + i * 22;
                ArcanaCodexHelper.renderItem((AbstractMalumScreen)screen, guiGraphics, stack, itemPosX, itemPosY, mouseX, mouseY);
            }
        }
        ArcanaCodexHelper.renderItem((AbstractMalumScreen)screen, guiGraphics, this.outputStack, left + 63, top + 126, mouseX, mouseY);
    }

    public static CraftingPage fullPage(Item output, Item input) {
        return CraftingPage.fullPage(output.m_7968_(), input.m_7968_());
    }

    public static CraftingPage fullPage(ItemStack output, ItemStack input) {
        return new CraftingPage(output, input, input, input, input, input, input, input, input, input);
    }

    public static CraftingPage scythePage(Item scythe, Item metal, Item reagent) {
        return CraftingPage.scythePage(scythe.m_7968_(), metal.m_7968_(), reagent.m_7968_());
    }

    public static CraftingPage scythePage(ItemStack scythe, ItemStack metal, ItemStack reagent) {
        ItemStack stick = Items.f_42398_.m_7968_();
        ItemStack empty = Items.f_41852_.m_7968_();
        return new CraftingPage(scythe, metal, metal, reagent, empty, stick, metal, stick, empty, empty);
    }

    public static CraftingPage broochPage(Item brooch, Item ingot, Item block) {
        return CraftingPage.broochPage(brooch.m_7968_(), Items.f_42454_.m_7968_(), ingot.m_7968_(), block.m_7968_());
    }

    public static CraftingPage broochPage(ItemStack brooch, ItemStack material, ItemStack ingot, ItemStack block) {
        ItemStack empty = Items.f_41852_.m_7968_();
        return new CraftingPage(brooch, empty, material, empty, material, ingot, material, empty, block, empty);
    }

    public static CraftingPage ringPage(Item ring, Item reagent) {
        return CraftingPage.ringPage(ring.m_7968_(), Items.f_42454_.m_7968_(), reagent.m_7968_());
    }

    public static CraftingPage ringPage(ItemStack ring, ItemStack material, ItemStack reagent) {
        ItemStack empty = Items.f_41852_.m_7968_();
        return new CraftingPage(ring, reagent, material, empty, material, empty, material, empty, material, empty);
    }

    public static CraftingPage itemPedestalPage(Item pedestal, Item fullBlock, Item slab) {
        return CraftingPage.itemPedestalPage(pedestal.m_7968_(), fullBlock.m_7968_(), slab.m_7968_());
    }

    public static CraftingPage itemPedestalPage(ItemStack pedestal, ItemStack fullBlock, ItemStack slab) {
        ItemStack empty = Items.f_41852_.m_7968_();
        return new CraftingPage(pedestal, slab, slab, slab, empty, fullBlock, empty, slab, slab, slab);
    }

    public static CraftingPage itemStandPage(Item stand, Item fullBlock, Item slab) {
        return CraftingPage.itemStandPage(stand.m_7968_(), fullBlock.m_7968_(), slab.m_7968_());
    }

    public static CraftingPage itemStandPage(ItemStack stand, ItemStack fullBlock, ItemStack slab) {
        ItemStack empty = Items.f_41852_.m_7968_();
        return new CraftingPage(stand, empty, empty, empty, slab, slab, slab, fullBlock, fullBlock, fullBlock);
    }

    public static CraftingPage toolPage(Item tool, Item metal) {
        return CraftingPage.toolPage(tool.m_7968_(), metal.m_7968_());
    }

    public static CraftingPage toolPage(ItemStack tool, ItemStack metal) {
        ItemStack stick = Items.f_42398_.m_7968_();
        ItemStack empty = Items.f_41852_.m_7968_();
        if (tool.m_41720_() instanceof SwordItem) {
            return new CraftingPage(tool, empty, metal, empty, empty, metal, empty, empty, stick, empty);
        }
        if (tool.m_41720_() instanceof AxeItem) {
            return new CraftingPage(tool, metal, metal, empty, metal, stick, empty, empty, stick, empty);
        }
        if (tool.m_41720_() instanceof HoeItem) {
            return new CraftingPage(tool, metal, metal, empty, empty, stick, empty, empty, stick, empty);
        }
        if (tool.m_41720_() instanceof ShovelItem) {
            return new CraftingPage(tool, empty, metal, empty, empty, stick, empty, empty, stick, empty);
        }
        if (tool.m_41720_() instanceof PickaxeItem) {
            return new CraftingPage(tool, metal, metal, metal, empty, stick, empty, empty, stick, empty);
        }
        return null;
    }

    public static CraftingPage knifePage(Item tool, Item metal) {
        return CraftingPage.knifePage(tool.m_7968_(), metal.m_7968_());
    }

    public static CraftingPage knifePage(ItemStack tool, ItemStack metal) {
        ItemStack stick = Items.f_42398_.m_7968_();
        ItemStack empty = Items.f_41852_.m_7968_();
        return new CraftingPage(tool, new ItemStack[]{empty, empty, empty, empty, metal, empty, stick, empty}){

            @Override
            public boolean isValid() {
                return ModList.get().isLoaded("farmersdelight");
            }
        };
    }
}

