/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.ritual_plinth;

import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.ritual_plinth.RitualSoundInstance;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.block.storage.jar.SpiritJarBlockEntity;
import com.sammy.malum.common.item.spirit.RitualShardItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.ritual.MalumRitualRecipeData;
import com.sammy.malum.core.systems.ritual.MalumRitualTier;
import com.sammy.malum.core.systems.ritual.MalumRitualType;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.ParticleEffectTypeRegistry;
import com.sammy.malum.registry.common.RitualRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.visual_effects.RitualPlinthParticleEffects;
import com.sammy.malum.visual_effects.networked.data.ColorEffectData;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import com.sammy.malum.visual_effects.networked.ritual.RitualPlinthAbsorbItemParticleEffect;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.registries.RegistryObject;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntity;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.recipe.IngredientWithCount;

public class RitualPlinthBlockEntity
extends LodestoneBlockEntity {
    private static final Vec3 PLINTH_ITEM_OFFSET = new Vec3(0.5, 1.375, 0.5);
    public MalumRitualType ritualType;
    public MalumRitualTier ritualTier;
    public int spiritAmount;
    public int progress;
    public float activeDuration;
    public boolean setupComplete;
    public Map<Object, Integer> absorptionProgress = new HashMap<Object, Integer>();
    public MalumRitualRecipeData ritualRecipe;
    public LodestoneBlockEntityInventory inventory;
    public LodestoneBlockEntityInventory extrasInventory;
    public LazyOptional<IItemHandler> internalInventory = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, this.extrasInventory}));
    public LazyOptional<IItemHandler> exposedInventory = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory}));

    public RitualPlinthBlockEntity(BlockEntityType<? extends RitualPlinthBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public RitualPlinthBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.RITUAL_PLINTH.get(), pos, state);
        this.inventory = new MalumBlockEntityInventory(1, 64, t -> this.ritualType != null && this.ritualType.isItemStackValid(this, (ItemStack)t) || this.ritualType == null && !(t.m_41720_() instanceof SpiritShardItem)){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                RitualPlinthBlockEntity.this.needsSync = true;
                BlockHelper.updateAndNotifyState((Level)RitualPlinthBlockEntity.this.f_58857_, (BlockPos)RitualPlinthBlockEntity.this.f_58858_);
            }
        };
        this.extrasInventory = new MalumBlockEntityInventory(8, 64){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                BlockHelper.updateAndNotifyState((Level)RitualPlinthBlockEntity.this.f_58857_, (BlockPos)RitualPlinthBlockEntity.this.f_58858_);
            }
        };
    }

    protected void m_183515_(CompoundTag compound) {
        if (this.spiritAmount != 0) {
            compound.m_128405_("spiritAmount", this.spiritAmount);
        }
        if (this.progress != 0) {
            compound.m_128405_("progress", this.progress);
        }
        if (this.setupComplete) {
            compound.m_128379_("setupComplete", true);
        }
        if (this.activeDuration != 0.0f) {
            compound.m_128350_("activeDuration", this.activeDuration);
        }
        if (this.ritualType != null) {
            compound.m_128359_("ritualType", this.ritualType.identifier.toString());
        }
        this.inventory.save(compound);
        this.extrasInventory.save(compound, "extrasInventory");
    }

    public void m_142466_(CompoundTag compound) {
        this.spiritAmount = compound.m_128451_("spiritAmount");
        this.progress = compound.m_128451_("progress");
        this.setupComplete = compound.m_128471_("setupComplete");
        this.activeDuration = compound.m_128457_("activeDuration");
        this.ritualType = RitualRegistry.get(new ResourceLocation(compound.m_128461_("ritualType")));
        this.ritualTier = MalumRitualTier.figureOutTier(this.spiritAmount);
        this.inventory.load(compound);
        this.extrasInventory.load(compound, "extrasInventory");
        super.m_142466_(compound);
    }

    public void onBreak(@Nullable Player player) {
        this.inventory.dumpItems(this.f_58857_, this.f_58858_);
        this.extrasInventory.dumpItems(this.f_58857_, this.f_58858_);
        if (this.ritualType != null && this.ritualTier != null) {
            ItemStack shard = new ItemStack((ItemLike)ItemRegistry.RITUAL_SHARD.get());
            shard.m_41751_(this.ritualType.createShardNBT(this.ritualTier));
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), shard));
        }
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        ItemStack stack;
        if (this.ritualType != null) {
            InteractionResult interactionResult = this.ritualType.onUsePlinth(this, player, hand);
            if (!interactionResult.equals((Object)InteractionResult.PASS)) {
                return interactionResult;
            }
        } else if (this.inventory.getStackInSlot(0).m_41619_() && this.extrasInventory.isEmpty() && (stack = player.m_21120_(hand)).m_41720_() instanceof RitualShardItem) {
            if (!this.f_58857_.f_46443_) {
                this.ritualType = RitualShardItem.getRitualType(stack);
                this.ritualTier = RitualShardItem.getRitualTier(stack);
                this.spiritAmount = this.ritualTier.spiritThreshold;
                this.setupComplete = true;
                ParticleEffectTypeRegistry.RITUAL_PLINTH_BEGINS_CHARGING.createPositionedEffect(this.f_58857_, new PositionEffectData(this.f_58858_), new ColorEffectData(this.ritualType.spirit));
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)SoundRegistry.RITUAL_BEGINS.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.f_58857_.f_46441_.m_188501_() * 0.2f);
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)SoundRegistry.RITUAL_COMPLETED.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.f_58857_.f_46441_.m_188501_() * 0.2f);
                player.m_21008_(hand, ItemStack.f_41583_);
                BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
            }
            return InteractionResult.SUCCESS;
        }
        this.inventory.interact(player.m_9236_(), player, hand);
        return InteractionResult.SUCCESS;
    }

    public void init() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        boolean wasLackingRecipe = this.ritualRecipe == null;
        this.ritualRecipe = RitualRegistry.RITUALS.stream().map(MalumRitualType::getRecipeData).filter(recipeData -> recipeData != null && recipeData.input.matches(stack)).findAny().orElse(null);
        if (this.ritualType == null && wasLackingRecipe && this.ritualRecipe != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)SoundRegistry.RITUAL_BEGINS.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.f_58857_.f_46441_.m_188501_() * 0.2f);
        }
        if (this.f_58857_.f_46443_) {
            RegistryObject<SoundEvent> soundEvent = null;
            Predicate<RitualPlinthBlockEntity> stopCondition = null;
            if (this.setupComplete) {
                soundEvent = SoundRegistry.COMPLETED_RITUAL_AMBIENCE;
                stopCondition = p -> false;
            } else if (this.ritualType != null) {
                soundEvent = SoundRegistry.RITUAL_EVOLUTION_AMBIENCE;
                stopCondition = p -> p.setupComplete || p.ritualType == null;
            } else if (wasLackingRecipe && this.ritualRecipe != null) {
                soundEvent = SoundRegistry.RITUAL_BEGINNING_AMBIENCE;
                stopCondition = p -> p.ritualRecipe == null || p.ritualType != null;
            }
            if (soundEvent != null) {
                RitualSoundInstance.playSound(this, soundEvent, stopCondition);
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.ritualType != null) {
            this.activeDuration += 1.0f;
            if (this.progress > 0) {
                --this.progress;
                if (!this.f_58857_.f_46443_) {
                    this.eatSpirits();
                    if (this.progress == 0) {
                        this.completeCharging();
                    }
                }
            } else if (!this.f_58857_.f_46443_) {
                this.ritualType.triggerRitualEffect(this);
            }
        } else if (this.ritualRecipe != null) {
            ++this.progress;
            if (!this.f_58857_.f_46443_ && this.progress > 60) {
                boolean success = this.consume();
                if (success) {
                    this.beginCharging();
                } else {
                    this.progress = 0;
                }
            }
        } else {
            this.progress = 0;
        }
        if (this.f_58857_.f_46443_) {
            ItemStack stack = this.inventory.getStackInSlot(0);
            if (!stack.m_41619_()) {
                boolean isItemValid;
                boolean bl = this.ritualType != null ? this.ritualType.isItemStackValid(this, stack) : (isItemValid = this.ritualRecipe != null && this.ritualRecipe.input.matches(stack));
                if (isItemValid) {
                    RitualPlinthParticleEffects.holdingPrimeItemPlinthParticles(this);
                }
            }
            if (this.ritualType != null) {
                RitualPlinthParticleEffects.riteActivePlinthParticles(this);
            }
        }
    }

    public boolean consume() {
        if (this.ritualRecipe.extraItems.isEmpty()) {
            return true;
        }
        this.extrasInventory.updateData();
        int extras = this.extrasInventory.nonEmptyItemAmount;
        if (extras < this.ritualRecipe.extraItems.size()) {
            Collection altarProviders = BlockHelper.getBlockEntities(IMalumSpecialItemAccessPoint.class, (Level)this.f_58857_, (BlockPos)this.f_58858_, (int)4);
            for (IMalumSpecialItemAccessPoint provider : altarProviders) {
                LodestoneBlockEntityInventory inventoryForAltar = provider.getSuppliedInventory();
                ItemStack providedStack = inventoryForAltar.getStackInSlot(0);
                IngredientWithCount requestedItem = this.ritualRecipe.extraItems.get(extras);
                if (!requestedItem.matches(providedStack)) continue;
                this.f_58857_.m_5594_(null, provider.getAccessPointBlockPos(), (SoundEvent)SoundRegistry.RITUAL_ABSORBS_ITEM.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.f_58857_.f_46441_.m_188501_() * 0.2f);
                ParticleEffectTypeRegistry.RITUAL_PLINTH_EATS_ITEM.createPositionedEffect(this.f_58857_, new PositionEffectData(this.f_58858_), new ColorEffectData(this.ritualRecipe.ritualType.spirit), RitualPlinthAbsorbItemParticleEffect.createData(provider.getItemPos(), providedStack));
                this.extrasInventory.insertItem(providedStack.m_41620_(requestedItem.count));
                inventoryForAltar.updateData();
                BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)provider.getAccessPointBlockPos());
                break;
            }
            return false;
        }
        return true;
    }

    public void beginCharging() {
        this.ritualType = this.ritualRecipe.ritualType;
        this.inventory.getStackInSlot(0).m_41774_(this.ritualRecipe.input.count);
        this.inventory.updateData();
        this.extrasInventory.clear();
        ParticleEffectTypeRegistry.RITUAL_PLINTH_BEGINS_CHARGING.createPositionedEffect(this.f_58857_, new PositionEffectData(this.f_58858_), new ColorEffectData(this.ritualType.spirit));
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.RITUAL_FORMS.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.f_58857_.f_46441_.m_188501_() * 0.2f);
        BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public void eatSpirits() {
        this.extrasInventory.updateData();
        Collection altarProviders = BlockHelper.getBlockEntities(IMalumSpecialItemAccessPoint.class, (Level)this.f_58857_, (BlockPos)this.f_58858_, (int)4);
        Collection jars = BlockHelper.getBlockEntities(SpiritJarBlockEntity.class, (Level)this.f_58857_, (BlockPos)this.f_58858_, (int)4);
        List<ItemEntity> itemEntities = this.f_58857_.m_45976_(ItemEntity.class, new AABB(this.f_58858_).m_82400_(4.0)).stream().filter(i -> i.m_32055_().m_41720_() instanceof SpiritShardItem).toList();
        int increase = 0;
        MalumSpiritType spirit = this.ritualType.spirit;
        for (IMalumSpecialItemAccessPoint altarProvider : altarProviders) {
            LodestoneBlockEntityInventory providerInventory = altarProvider.getSuppliedInventory();
            ItemStack stack = providerInventory.getStackInSlot(0);
            Item item = stack.m_41720_();
            if (!(item instanceof SpiritShardItem)) continue;
            SpiritShardItem spiritShardItem = (SpiritShardItem)item;
            if (!spiritShardItem.type.equals(spirit)) continue;
            this.absorptionProgress.compute(altarProvider, (p, i) -> i == null ? 1 : i + 1);
            if (this.absorptionProgress.get(altarProvider) < 5) continue;
            BlockPos accessPointBlockPos = altarProvider.getAccessPointBlockPos();
            int absorbedAmount = Math.min(stack.m_41613_(), this.ritualTier == null ? 4 : this.ritualTier.spiritThreshold / 16);
            increase += absorbedAmount;
            stack.m_41774_(absorbedAmount);
            providerInventory.onContentsChanged(0);
            this.f_58857_.m_5594_(null, accessPointBlockPos, (SoundEvent)SoundRegistry.RITUAL_ABSORBS_SPIRIT.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.f_58857_.f_46441_.m_188501_() * 0.2f);
            ParticleEffectTypeRegistry.RITUAL_PLINTH_EATS_SPIRIT.createPositionedEffect(this.f_58857_, new PositionEffectData(this.f_58858_), new ColorEffectData(spirit), RitualPlinthAbsorbItemParticleEffect.createData(altarProvider.getItemPos(), stack));
            this.absorptionProgress.remove(altarProvider);
            BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)accessPointBlockPos);
        }
        for (SpiritJarBlockEntity jar : jars) {
            if (!spirit.equals(jar.type) || jar.count <= 0) continue;
            this.absorptionProgress.compute((Object)jar, (p, i) -> i == null ? 1 : i + 1);
            if (this.absorptionProgress.get((Object)jar) < 5) continue;
            BlockPos jarPosition = jar.m_58899_();
            int absorbedAmount = Math.min(jar.count, this.ritualTier == null ? 4 : this.ritualTier.spiritThreshold / 16);
            increase += absorbedAmount;
            jar.count -= absorbedAmount;
            if (jar.count == 0) {
                jar.type = null;
            }
            this.f_58857_.m_5594_(null, jarPosition, (SoundEvent)SoundRegistry.RITUAL_ABSORBS_SPIRIT.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.f_58857_.f_46441_.m_188501_() * 0.2f);
            ParticleEffectTypeRegistry.RITUAL_PLINTH_EATS_SPIRIT.createPositionedEffect(this.f_58857_, new PositionEffectData(this.f_58858_), new ColorEffectData(spirit), RitualPlinthAbsorbItemParticleEffect.createData(jar.getItemPos(), spirit.spiritShard.get().m_7968_()));
            this.absorptionProgress.remove((Object)jar);
            BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)jarPosition);
        }
        for (ItemEntity itemEntity : itemEntities) {
            ItemStack item = itemEntity.m_32055_();
            Item item2 = item.m_41720_();
            if (!(item2 instanceof SpiritShardItem)) continue;
            SpiritShardItem spiritShardItem = (SpiritShardItem)item2;
            if (!spiritShardItem.type.equals(spirit)) continue;
            this.absorptionProgress.compute(itemEntity, (p, i) -> i == null ? 1 : i + 1);
            if (this.absorptionProgress.get(itemEntity) < 5) continue;
            this.f_58857_.m_5594_(null, itemEntity.m_20183_(), (SoundEvent)SoundRegistry.RITUAL_ABSORBS_SPIRIT.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.f_58857_.f_46441_.m_188501_() * 0.2f);
            ParticleEffectTypeRegistry.RITUAL_PLINTH_EATS_SPIRIT.createPositionedEffect(this.f_58857_, new PositionEffectData(this.f_58858_), new ColorEffectData(spirit), RitualPlinthAbsorbItemParticleEffect.createData(itemEntity.m_20182_().m_82520_(0.0, (double)(itemEntity.m_20206_() / 2.0f), 0.0), spirit.spiritShard.get().m_7968_()));
            increase += item.m_41613_();
            itemEntity.m_146870_();
            this.absorptionProgress.remove(itemEntity);
        }
        if (increase != 0) {
            this.spiritAmount += increase;
            this.progress = 60;
            MalumRitualTier oldTier = this.ritualTier;
            MalumRitualTier newTier = MalumRitualTier.figureOutTier(this.spiritAmount);
            if (newTier != null && !newTier.equals(oldTier)) {
                this.ritualTier = newTier;
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundRegistry.RITUAL_EVOLVES.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.f_58857_.f_46441_.m_188501_() * 0.2f);
                ParticleEffectTypeRegistry.RITUAL_PLINTH_CHANGES_TIER.createPositionedEffect(this.f_58857_, new PositionEffectData(this.f_58858_), new ColorEffectData(spirit));
            }
            BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.m_58899_());
        }
    }

    public void completeCharging() {
        this.ritualTier = MalumRitualTier.figureOutTier(this);
        boolean bl = this.setupComplete = this.ritualTier != null;
        if (!this.setupComplete) {
            MalumSpiritType spirit = this.ritualType.spirit;
            this.ritualType = null;
            this.spiritAmount = 0;
            ParticleEffectTypeRegistry.RITUAL_PLINTH_FAILURE.createPositionedEffect(this.f_58857_, new PositionEffectData(this.f_58858_), new ColorEffectData(spirit));
        }
        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)SoundRegistry.RITUAL_COMPLETED.get(), SoundSource.BLOCKS, 1.0f, 0.9f + this.f_58857_.f_46441_.m_188501_() * 0.2f);
        BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    public Vec3 getItemPos() {
        BlockPos blockPos = this.m_58899_();
        Vec3 offset = this.getCentralItemOffset();
        return new Vec3((double)blockPos.m_123341_() + offset.f_82479_, (double)blockPos.m_123342_() + offset.f_82480_, (double)blockPos.m_123343_() + offset.f_82481_);
    }

    public Vec3 getCentralItemOffset() {
        return PLINTH_ITEM_OFFSET;
    }

    public Vec3 getRitualIconPos() {
        BlockPos blockPos = this.m_58899_();
        Vec3 offset = this.getRitualIconOffset(0.0f);
        return new Vec3((double)blockPos.m_123341_() + offset.f_82479_, (double)blockPos.m_123342_() + offset.f_82480_, (double)blockPos.m_123343_() + offset.f_82481_);
    }

    public Vec3 getRitualIconOffset(float partialTicks) {
        return new Vec3(0.5, (double)(1.5f + Easing.CUBIC_OUT.ease(Math.min(this.activeDuration + partialTicks, 30.0f) / 30.0f, 0.0f, 2.0f, 1.0f)), 0.5);
    }

    public Vec3 getParticlePositionPosition(Direction direction) {
        BlockPos blockPos = this.m_58899_();
        float x = (float)blockPos.m_123341_() + 0.5f + (float)direction.m_122429_() * 0.51f;
        float y = (float)blockPos.m_123342_() + 0.875f;
        float z = (float)blockPos.m_123343_() + 0.5f + (float)direction.m_122431_() * 0.51f;
        return new Vec3((double)x, (double)y, (double)z);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.internalInventory.cast();
            }
            return this.exposedInventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.f_58858_;
        return new AABB((double)(pos.m_123341_() - 1), (double)pos.m_123342_(), (double)(pos.m_123343_() - 1), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 6), (double)(pos.m_123343_() + 1));
    }
}

