/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.curiosities.spirit_crucible.catalyzer;

import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.spirit_crucible.AugmentBlockEntityInventory;
import com.sammy.malum.common.block.curiosities.spirit_crucible.CrucibleAccelerationData;
import com.sammy.malum.common.block.curiosities.spirit_crucible.ICatalyzerAccelerationTarget;
import com.sammy.malum.common.block.curiosities.spirit_crucible.ICrucibleAccelerator;
import com.sammy.malum.common.block.curiosities.spirit_crucible.catalyzer.CatalyzerAcceleratorType;
import com.sammy.malum.common.item.augment.AbstractAugmentItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.block.BlockEntityRegistry;
import com.sammy.malum.registry.common.block.BlockRegistry;
import com.sammy.malum.visual_effects.SpiritCrucibleParticleEffects;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;
import team.lodestar.lodestone.systems.multiblock.HorizontalDirectionStructure;
import team.lodestar.lodestone.systems.multiblock.MultiBlockCoreEntity;
import team.lodestar.lodestone.systems.multiblock.MultiBlockStructure;

public class SpiritCatalyzerCoreBlockEntity
extends MultiBlockCoreEntity
implements ICrucibleAccelerator {
    private static final Vec3 CATALYZER_ITEM_OFFSET = new Vec3(0.5, 2.0, 0.5);
    private static final Vec3 CATALYZER_AUGMENT_OFFSET = new Vec3(0.5, 2.75, 0.5);
    public static final Supplier<HorizontalDirectionStructure> STRUCTURE = () -> HorizontalDirectionStructure.of((MultiBlockStructure.StructurePiece[])new MultiBlockStructure.StructurePiece[]{new MultiBlockStructure.StructurePiece(0, 1, 0, ((Block)BlockRegistry.SPIRIT_CATALYZER_COMPONENT.get()).m_49966_())});
    public LodestoneBlockEntityInventory inventory = new MalumBlockEntityInventory(1, 64, t -> !(t.m_41720_() instanceof SpiritShardItem)){

        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BlockHelper.updateAndNotifyState((Level)SpiritCatalyzerCoreBlockEntity.this.f_58857_, (BlockPos)SpiritCatalyzerCoreBlockEntity.this.f_58858_);
        }
    };
    public LodestoneBlockEntityInventory augmentInventory = new AugmentBlockEntityInventory(1, 1){

        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            SpiritCatalyzerCoreBlockEntity.this.needsSync = true;
            BlockHelper.updateAndNotifyState((Level)SpiritCatalyzerCoreBlockEntity.this.f_58857_, (BlockPos)SpiritCatalyzerCoreBlockEntity.this.f_58858_);
        }
    };
    public float burnTicks;
    public HashMap<MalumSpiritType, Integer> intensity;
    protected ICatalyzerAccelerationTarget target;

    public SpiritCatalyzerCoreBlockEntity(BlockEntityType<? extends SpiritCatalyzerCoreBlockEntity> type, MultiBlockStructure structure, BlockPos pos, BlockState state) {
        super(type, structure, pos, state);
    }

    public SpiritCatalyzerCoreBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends SpiritCatalyzerCoreBlockEntity>)((BlockEntityType)BlockEntityRegistry.SPIRIT_CATALYZER.get()), (MultiBlockStructure)STRUCTURE.get(), pos, state);
    }

    protected void m_183515_(CompoundTag compound) {
        if (this.burnTicks != 0.0f) {
            compound.m_128350_("burnTicks", this.burnTicks);
        }
        this.inventory.save(compound);
        this.augmentInventory.save(compound, "augmentInventory");
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        this.burnTicks = compound.m_128457_("burnTicks");
        this.inventory.load(compound);
        this.augmentInventory.load(compound, "augmentInventory");
        super.m_142466_(compound);
    }

    public InteractionResult onUse(Player player, InteractionHand hand) {
        if (this.f_58857_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
            ItemStack stack;
            ItemStack heldStack = player.m_21120_(hand);
            boolean augmentOnly = heldStack.m_41720_() instanceof AbstractAugmentItem;
            if ((augmentOnly || heldStack.m_41619_() && this.inventory.isEmpty()) && !(stack = this.augmentInventory.interact(player.m_9236_(), player, hand)).m_41619_()) {
                return InteractionResult.SUCCESS;
            }
            if (!augmentOnly) {
                this.inventory.interact(player.m_9236_(), player, hand);
            }
            if (heldStack.m_41619_()) {
                return InteractionResult.SUCCESS;
            }
        }
        return super.onUse(player, hand);
    }

    public void onBreak(@Nullable Player player) {
        if (!this.f_58857_.f_46443_) {
            this.inventory.dumpItems(this.f_58857_, this.f_58858_);
            this.augmentInventory.dumpItems(this.f_58857_, this.f_58858_);
        }
        super.onBreak(player);
    }

    public void tick() {
        CrucibleAccelerationData data;
        float ratio;
        if (this.target != null && this.target.canBeAccelerated() && this.burnTicks > 0.0f && (ratio = data.fuelUsageRate.getValue(data = this.target.getAccelerationData())) > 0.0f) {
            this.burnTicks -= ratio;
        }
        if (this.f_58857_.f_46443_) {
            if (this.intensity == null) {
                this.intensity = new HashMap();
            }
            if (this.target != null) {
                boolean canBeAccelerated = this.target.canBeAccelerated();
                MalumSpiritType activeSpiritType = this.target.getActiveSpiritType();
                if (activeSpiritType != null) {
                    this.intensity.putIfAbsent(activeSpiritType, 0);
                    if (canBeAccelerated) {
                        this.intensity.put(activeSpiritType, Math.min(60, this.intensity.get(activeSpiritType) + 1));
                    }
                }
                for (MalumSpiritType spiritType : this.intensity.keySet()) {
                    if (canBeAccelerated && spiritType.equals(activeSpiritType)) continue;
                    this.intensity.put(spiritType, Math.max(0, this.intensity.get(spiritType) - 1));
                }
            }
            SpiritCrucibleParticleEffects.passiveSpiritCatalyzerParticles(this);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addParticles(ICatalyzerAccelerationTarget target, MalumSpiritType spiritType) {
        if (this.burnTicks > 0.0f) {
            SpiritCrucibleParticleEffects.activeSpiritCatalyzerParticles(this, target, spiritType);
        }
    }

    @Override
    public boolean canStartAccelerating() {
        if (this.burnTicks > 0.0f) {
            return true;
        }
        return ForgeHooks.getBurnTime((ItemStack)this.inventory.getStackInSlot(0), (RecipeType)RecipeType.f_44108_) > 0;
    }

    @Override
    public boolean canContinueAccelerating() {
        ItemStack stack;
        if (this.m_58901_()) {
            return false;
        }
        if (this.burnTicks <= 0.0f && !(stack = this.inventory.getStackInSlot(0)).m_41619_()) {
            this.burnTicks = (float)ForgeHooks.getBurnTime((ItemStack)this.inventory.getStackInSlot(0), (RecipeType)RecipeType.f_44108_) / 2.0f;
            stack.m_41774_(1);
            this.inventory.updateData();
            BlockHelper.updateAndNotifyState((Level)this.f_58857_, (BlockPos)this.f_58858_);
        }
        return this.burnTicks != 0.0f;
    }

    @Override
    public ICrucibleAccelerator.CrucibleAcceleratorType getAcceleratorType() {
        return CatalyzerAcceleratorType.CATALYZER;
    }

    @Override
    public ItemStack getAugment() {
        return this.augmentInventory.getStackInSlot(0);
    }

    @Override
    public ICatalyzerAccelerationTarget getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(ICatalyzerAccelerationTarget target) {
        this.target = target;
    }

    public Vec3 getItemOffset() {
        return CATALYZER_ITEM_OFFSET;
    }

    public Vec3 getAugmentOffset() {
        return CATALYZER_AUGMENT_OFFSET;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventory.inventoryOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.f_58858_;
        return new AABB((double)(pos.m_123341_() - 1), (double)pos.m_123342_(), (double)(pos.m_123343_() - 1), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 4), (double)(pos.m_123343_() + 1));
    }
}

