/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.block.storage;

import com.sammy.malum.common.block.MalumBlockEntityInventory;
import com.sammy.malum.common.block.storage.IMalumSpecialItemAccessPoint;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.BlockHelper;
import team.lodestar.lodestone.systems.blockentity.ItemHolderBlockEntity;
import team.lodestar.lodestone.systems.blockentity.LodestoneBlockEntityInventory;

public abstract class MalumItemHolderBlockEntity
extends ItemHolderBlockEntity
implements IMalumSpecialItemAccessPoint {
    public MalumItemHolderBlockEntity(BlockEntityType<? extends MalumItemHolderBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new MalumBlockEntityInventory(1, 64){

            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                BlockHelper.updateAndNotifyState((Level)MalumItemHolderBlockEntity.this.f_58857_, (BlockPos)MalumItemHolderBlockEntity.this.f_58858_);
            }
        };
    }

    @Override
    public LodestoneBlockEntityInventory getSuppliedInventory() {
        return this.inventory;
    }

    @Override
    public Vec3 getItemPos(float partialTicks) {
        BlockPos blockPos = this.m_58899_();
        Vec3 offset = this.getItemOffset(partialTicks);
        return new Vec3((double)blockPos.m_123341_() + offset.f_82479_, (double)blockPos.m_123342_() + offset.f_82480_, (double)blockPos.m_123343_() + offset.f_82481_);
    }

    @Override
    public BlockPos getAccessPointBlockPos() {
        return this.f_58858_;
    }

    public void tick() {
        Item item;
        if (this.f_58857_.f_46443_ && (item = this.inventory.getStackInSlot(0).m_41720_()) instanceof SpiritShardItem) {
            SpiritShardItem item2 = (SpiritShardItem)item;
            MalumSpiritType type = item2.type;
            SpiritLightSpecs.rotatingLightSpecs(this.f_58857_, this.getItemPos(), type, 0.4f, 2);
        }
    }

    public abstract Vec3 getItemOffset(float var1);

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.f_58858_;
        return new AABB((double)(pos.m_123341_() - 1), (double)pos.m_123342_(), (double)(pos.m_123343_() - 1), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 2), (double)(pos.m_123343_() + 1));
    }
}

