/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.rotten;

import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.registry.common.MobEffectRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import com.sammy.malum.registry.common.item.ItemTagRegistry;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import team.lodestar.lodestone.helpers.CurioHelper;
import team.lodestar.lodestone.helpers.EntityHelper;
import team.lodestar.lodestone.helpers.RandomHelper;

public class CurioVoraciousRing
extends MalumCurioItem {
    public CurioVoraciousRing(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.ROTTEN);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(CurioVoraciousRing.positiveEffect("eat_rotten", new Object[0]));
        consumer.accept(CurioVoraciousRing.positiveEffect("growing_gluttony", new Object[0]));
    }

    public static void accelerateEating(LivingEntityUseItemEvent.Start event) {
        if (CurioHelper.hasCurioEquipped((LivingEntity)event.getEntity(), (Item)((Item)ItemRegistry.RING_OF_DESPERATE_VORACITY.get())) && event.getItem().m_204117_(ItemTagRegistry.GROSS_FOODS)) {
            event.setDuration((int)((float)event.getDuration() * 0.5f));
        }
    }

    public static void onEat(Level level, LivingEntity livingEntity, ItemStack food) {
        if (food.m_204117_(ItemTagRegistry.GROSS_FOODS) && CurioHelper.hasCurioEquipped((LivingEntity)livingEntity, (Item)((Item)ItemRegistry.RING_OF_DESPERATE_VORACITY.get()))) {
            MobEffectInstance gluttony = livingEntity.m_21124_((MobEffect)MobEffectRegistry.GLUTTONY.get());
            MobEffectInstance hunger = livingEntity.m_21124_(MobEffects.f_19612_);
            if (gluttony != null) {
                EntityHelper.extendEffect((MobEffectInstance)gluttony, (LivingEntity)livingEntity, (int)300, (int)3000);
            }
            if (hunger != null) {
                EntityHelper.shortenEffect((MobEffectInstance)hunger, (LivingEntity)livingEntity, (int)150);
            }
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.m_36324_().m_38707_(1, 1.0f);
            }
            livingEntity.m_5496_((SoundEvent)SoundRegistry.VORACIOUS_RING_FEEDS.get(), 0.5f, RandomHelper.randomBetween((RandomSource)level.f_46441_, (float)1.2f, (float)1.6f));
        }
    }
}

