/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.compability.jei.categories;

import com.sammy.malum.MalumMod;
import com.sammy.malum.client.screen.codex.ArcanaCodexHelper;
import com.sammy.malum.common.recipe.SpiritInfusionRecipe;
import com.sammy.malum.compability.jei.JEIHandler;
import com.sammy.malum.registry.common.item.ItemRegistry;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SpiritInfusionRecipeCategory
implements IRecipeCategory<SpiritInfusionRecipe> {
    public static final ResourceLocation UID = MalumMod.malumPath("spirit_infusion");
    private final IDrawable background;
    private final IDrawable overlay;
    private final IDrawable icon;

    public SpiritInfusionRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(142, 185);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("malum", "textures/gui/spirit_infusion_jei.png"), 0, 0, 142, 183);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ItemRegistry.SPIRIT_ALTAR.get()));
    }

    public void draw(SpiritInfusionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.overlay.draw(guiGraphics);
        int spiritOffset = recipe.spirits.size() > 5 ? (recipe.spirits.size() - 5) * 10 : 0;
        ArcanaCodexHelper.renderItemFrames(guiGraphics.m_280168_(), recipe.spirits.size(), 19, 48 + spiritOffset, true);
        if (!recipe.extraItems.isEmpty()) {
            int itemOffset = recipe.extraItems.size() > 5 ? (recipe.extraItems.size() - 5) * 10 : 0;
            ArcanaCodexHelper.renderItemFrames(guiGraphics.m_280168_(), recipe.extraItems.size(), 103, 48 + itemOffset, true);
        }
    }

    public RecipeType<SpiritInfusionRecipe> getRecipeType() {
        return JEIHandler.SPIRIT_INFUSION;
    }

    public Component getTitle() {
        return Component.m_237115_((String)("malum.jei." + UID.m_135815_()));
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpiritInfusionRecipe recipe, IFocusGroup focuses) {
        int spiritOffset = recipe.spirits.size() > 5 ? (recipe.spirits.size() - 5) * 10 : 0;
        int itemOffset = recipe.extraItems.size() > 5 ? (recipe.extraItems.size() - 5) * 10 : 0;
        JEIHandler.addItemsToJei(builder, RecipeIngredientRole.INPUT, 20, 49 + spiritOffset, true, recipe.spirits);
        JEIHandler.addItemsToJei(builder, RecipeIngredientRole.INPUT, 104, 49 + itemOffset, true, recipe.extraItems);
        builder.addSlot(RecipeIngredientRole.INPUT, 63, 57).addItemStacks(recipe.input.getStacks());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 63, 124).addItemStack(recipe.output);
    }
}

