/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.mojang.datafixers.util.Pair;
import com.sammy.malum.common.capability.MalumLivingEntityDataCapability;
import com.sammy.malum.common.packets.malignant_conversion.SyncMalignantConversionPacket;
import com.sammy.malum.core.listeners.MalignantConversionReloadListener;
import com.sammy.malum.registry.common.AttributeRegistry;
import com.sammy.malum.registry.common.PacketRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.network.PacketDistributor;

public class MalignantConversionHandler {
    public static final UUID NEGATIVE_MODIFIER_UUID = UUID.fromString("ff803d68-a615-4279-a59a-d847db2481d7");
    public static final HashMap<Attribute, UUID> POSITIVE_MODIFIER_UUIDS = new HashMap();
    public final HashMap<Attribute, Double> cachedAttributeValues = new HashMap();
    public boolean skipConversionLogic;

    public static void checkForAttributeChanges(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!livingEntity.m_9236_().f_46443_) {
            MalignantConversionHandler handler = MalumLivingEntityDataCapability.getCapability((LivingEntity)livingEntity).malignantConversionHandler;
            Attribute conversionAttribute = (Attribute)AttributeRegistry.MALIGNANT_CONVERSION.get();
            AttributeInstance conversionInstance = livingEntity.m_21051_(conversionAttribute);
            if (conversionInstance != null) {
                if (handler.skipConversionLogic) {
                    if (conversionInstance.m_22135_() == 0.0) {
                        return;
                    }
                    handler.skipConversionLogic = false;
                }
                Map<ResourceLocation, MalignantConversionReloadListener.MalignantConversionData> conversionData = MalignantConversionReloadListener.CONVERSION_DATA;
                for (MalignantConversionReloadListener.MalignantConversionData data : conversionData.values()) {
                    Attribute attribute = data.sourceAttribute();
                    AttributeInstance instance = livingEntity.m_21051_(attribute);
                    if (instance == null || !handler.cachedAttributeValues.containsKey(attribute)) continue;
                    MalignantConversionHandler.convertAttribute(handler, livingEntity, data.sourceAttribute(), data.consumptionRatio(), data.ignoreBaseValue(), data.targetAttributes(), false);
                }
                if (handler.cachedAttributeValues.containsKey(conversionAttribute) && handler.cachedAttributeValues.get(conversionAttribute).doubleValue() != conversionInstance.m_22135_()) {
                    for (MalignantConversionReloadListener.MalignantConversionData data : conversionData.values()) {
                        MalignantConversionHandler.convertAttribute(handler, livingEntity, data.sourceAttribute(), data.consumptionRatio(), data.ignoreBaseValue(), data.targetAttributes(), true);
                    }
                }
                handler.cachedAttributeValues.put(conversionAttribute, conversionInstance.m_22135_());
                if (conversionInstance.m_22135_() == 0.0) {
                    handler.skipConversionLogic = true;
                }
            }
        }
    }

    private static void convertAttribute(MalignantConversionHandler handler, LivingEntity livingEntity, Attribute sourceAttribute, double consumptionRatio, boolean ignoreBaseValue, List<Pair<Attribute, Double>> targetAttributes, boolean skipCacheComparison) {
        AttributeMap attributes = livingEntity.m_21204_();
        double malignantConversion = attributes.m_22181_((Attribute)AttributeRegistry.MALIGNANT_CONVERSION.get());
        AttributeInstance sourceInstance = livingEntity.m_21051_(sourceAttribute);
        if (sourceInstance != null) {
            boolean hasMalignantConversion;
            AttributeModifier originalModifier = sourceInstance.m_22111_(NEGATIVE_MODIFIER_UUID);
            if (originalModifier != null) {
                sourceInstance.m_22130_(originalModifier);
            }
            boolean bl = hasMalignantConversion = malignantConversion > 0.0;
            if (skipCacheComparison || handler.cachedAttributeValues.get(sourceAttribute).doubleValue() != sourceInstance.m_22135_()) {
                double cachedValue = sourceInstance.m_22135_() - (ignoreBaseValue ? sourceInstance.m_22115_() : 0.0);
                for (Pair<Attribute, Double> target : targetAttributes) {
                    Attribute targetAttribute = (Attribute)target.getFirst();
                    AttributeInstance targetInstance = livingEntity.m_21051_(targetAttribute);
                    if (targetInstance == null) continue;
                    UUID uuid = POSITIVE_MODIFIER_UUIDS.computeIfAbsent(sourceAttribute, MalignantConversionHandler::createPositiveModifierUUID);
                    targetInstance.m_22120_(uuid);
                    double bonus = cachedValue * malignantConversion * (Double)target.getSecond();
                    if (!(bonus > 0.0)) continue;
                    AttributeModifier modifier = new AttributeModifier(uuid, "Malignant Conversion: " + Component.m_237115_((String)targetAttribute.m_22087_()), bonus, AttributeModifier.Operation.ADDITION);
                    targetInstance.m_22118_(modifier);
                    if (!(livingEntity instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    PacketRegistry.MALUM_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncMalignantConversionPacket(targetAttribute, uuid));
                }
                handler.cachedAttributeValues.put(sourceAttribute, sourceInstance.m_22135_());
                if (hasMalignantConversion) {
                    AttributeModifier modifier = new AttributeModifier(NEGATIVE_MODIFIER_UUID, "Malignant Conversion: " + Component.m_237115_((String)sourceAttribute.m_22087_()), -malignantConversion * consumptionRatio, AttributeModifier.Operation.MULTIPLY_TOTAL);
                    sourceInstance.m_22118_(modifier);
                }
            }
            if (originalModifier != null && sourceInstance.m_22111_(NEGATIVE_MODIFIER_UUID) == null && hasMalignantConversion) {
                sourceInstance.m_22118_(originalModifier);
            }
        }
    }

    public static void syncPositiveUUIDS(Player player, Attribute attribute, UUID uuid) {
        AttributeInstance target = player.m_21051_(attribute);
        if (target != null) {
            POSITIVE_MODIFIER_UUIDS.put(attribute, uuid);
        }
    }

    private static UUID createPositiveModifierUUID(Attribute attribute) {
        return UUID.nameUUIDFromBytes(attribute.m_22087_().getBytes());
    }
}

