/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers.hiding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagRegistry;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;

public class HiddenTagHandler {
    private static final Map<TagKey<Item>, BooleanSupplier> ITEMS_TO_HIDE = new HashMap<TagKey<Item>, BooleanSupplier>();
    private static final HashMap<UUID, Runnable> INVOKED_WHEN_CONDITIONS_CHANGE = new HashMap();
    private static FeatureFlagRegistry FLAGS;
    private static final Map<TagKey<Item>, FeatureFlag> FEATURE_FLAGS;

    public static void hideTagWhen(TagKey<Item> item, BooleanSupplier condition) {
        ITEMS_TO_HIDE.put(item, condition);
    }

    public static void buildFeatureFlagSet(ResourceLocation name) {
        FeatureFlagRegistry.Builder builder = new FeatureFlagRegistry.Builder(name.toString());
        for (TagKey<Item> tag : ITEMS_TO_HIDE.keySet()) {
            FEATURE_FLAGS.put(tag, builder.m_247497_(tag.f_203868_()));
        }
        FLAGS = builder.m_245707_();
    }

    public static FeatureFlagSet createFeatureFlagSet() {
        HashSet<FeatureFlag> flags = new HashSet<FeatureFlag>();
        for (Map.Entry<TagKey<Item>, BooleanSupplier> entry : ITEMS_TO_HIDE.entrySet()) {
            FeatureFlag flag = FEATURE_FLAGS.get(entry.getKey());
            if (flag == null || entry.getValue().getAsBoolean()) continue;
            flags.add(flag);
        }
        return FLAGS.m_245769_(flags.toArray(new FeatureFlag[0]));
    }

    public static FeatureFlagSet createAllEnabledFlagSet() {
        return FLAGS.m_247355_();
    }

    public static UUID registerHiddenItemListener(Runnable runnable) {
        runnable.run();
        UUID uuid = UUID.randomUUID();
        INVOKED_WHEN_CONDITIONS_CHANGE.put(uuid, runnable);
        return uuid;
    }

    public static void removeListener(UUID listener) {
        INVOKED_WHEN_CONDITIONS_CHANGE.remove(listener);
    }

    public static void conditionsChanged() {
        INVOKED_WHEN_CONDITIONS_CHANGE.values().forEach(Runnable::run);
    }

    public static List<TagKey<Item>> tagsToHide() {
        ArrayList<TagKey<Item>> tags = new ArrayList<TagKey<Item>>();
        for (Map.Entry<TagKey<Item>, BooleanSupplier> entry : ITEMS_TO_HIDE.entrySet()) {
            if (!entry.getValue().getAsBoolean()) continue;
            tags.add(entry.getKey());
        }
        return tags;
    }

    static {
        FEATURE_FLAGS = new HashMap<TagKey<Item>, FeatureFlag>();
    }
}

