/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.helpers;

import com.sammy.malum.common.item.ISpiritAffiliatedItem;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.data.NBTEffectData;
import com.sammy.malum.visual_effects.networked.data.PositionEffectData;
import com.sammy.malum.visual_effects.networked.slash.SlashAttackParticleEffect;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ParticleHelper {
    public static SlashParticleEffectBuilder createSlashingEffect(ParticleEffectType effectType) {
        return new SlashParticleEffectBuilder(effectType);
    }

    public static class SlashParticleEffectBuilder {
        public final ParticleEffectType effectType;
        public float horizontalOffset;
        public float slashAngle;
        public boolean isMirrored;
        public MalumSpiritType spiritType;

        public SlashParticleEffectBuilder(ParticleEffectType effectType) {
            this.effectType = effectType;
        }

        public SlashParticleEffectBuilder setVertical() {
            return this.setVerticalSlashAngle().setHorizontalOffset(0.4f);
        }

        public SlashParticleEffectBuilder setHorizontalOffset(float horizontalOffset) {
            this.horizontalOffset = horizontalOffset;
            return this;
        }

        public SlashParticleEffectBuilder setVerticalSlashAngle() {
            return this.setSlashAngle(1.57f);
        }

        public SlashParticleEffectBuilder setRandomSlashAngle(RandomSource randomSource) {
            return this.setSlashAngle(randomSource.m_188501_() * 3.14f);
        }

        public SlashParticleEffectBuilder setSlashAngle(float slashAngle) {
            this.slashAngle = slashAngle;
            return this;
        }

        public SlashParticleEffectBuilder mirrorRandomly(RandomSource randomSource) {
            return this.setMirrored(randomSource.m_188499_());
        }

        public SlashParticleEffectBuilder setMirrored(boolean isMirrored) {
            this.isMirrored = isMirrored;
            return this;
        }

        public SlashParticleEffectBuilder setSpiritType(ISpiritAffiliatedItem spiritAffiliatedItem) {
            this.spiritType = spiritAffiliatedItem.getDefiningSpiritType();
            return this;
        }

        public SlashParticleEffectBuilder setSpiritType(MalumSpiritType spiritType) {
            this.spiritType = spiritType;
            return this;
        }

        public void spawnForwardSlashingParticle(Entity attacker) {
            this.spawnForwardSlashingParticle(attacker, attacker.m_20154_());
        }

        public void spawnForwardSlashingParticle(Entity attacker, Vec3 slashDirection) {
            float yRot = (float)(Mth.m_14136_((double)slashDirection.f_82479_, (double)slashDirection.f_82481_) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 up = left.m_82537_(slashDirection);
            Vec3 offset = slashDirection.m_82490_((double)0.4f).m_82549_(up.m_82490_((double)-0.3f));
            if (this.horizontalOffset != 0.0f) {
                offset = offset.m_82549_(left.m_82490_((double)this.horizontalOffset));
            }
            this.spawnForwardSlashingParticle(attacker, offset, slashDirection);
        }

        public void spawnForwardSlashingParticle(Entity attacker, Vec3 slashOffset, Vec3 slashDirection) {
            double xOffset = slashOffset.f_82479_;
            double yOffset = slashOffset.f_82480_ + (double)(attacker.m_20206_() * 0.5f);
            double zOffset = slashOffset.f_82481_;
            Vec3 position = attacker.m_20182_().m_82520_(xOffset, yOffset, zOffset);
            this.spawnSlashingParticle(attacker.m_9236_(), position, slashDirection);
        }

        public void spawnTargetBoundSlashingParticle(Entity attacker, LivingEntity target) {
            Vec3 direction = attacker.m_20154_();
            RandomSource random = attacker.m_9236_().m_213780_();
            float yRot = (float)(Mth.m_14136_((double)direction.f_82479_, (double)direction.f_82481_) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 up = left.m_82537_(direction);
            Vec3 slashDirection = target.m_20182_().m_82546_(attacker.m_20182_()).m_82541_();
            Vec3 offset = direction.m_82490_((double)-1.4f).m_82549_(up.m_82490_((double)-0.2f)).m_82546_(slashDirection.m_82490_((double)(0.5f + random.m_188501_() * 0.5f)));
            if (this.horizontalOffset != 0.0f) {
                offset = offset.m_82549_(left.m_82490_((double)this.horizontalOffset));
            }
            this.spawnTargetBoundSlashingParticle(attacker, target, offset, slashDirection);
        }

        public void spawnTargetBoundSlashingParticle(Entity attacker, LivingEntity target, Vec3 slashOffset, Vec3 slashDirection) {
            double xOffset = slashOffset.f_82479_;
            double yOffset = slashOffset.f_82480_ + (double)(attacker.m_20206_() * 0.5f);
            double zOffset = slashOffset.f_82481_;
            Vec3 position = target.m_20182_().m_82520_(xOffset, yOffset, zOffset);
            this.spawnSlashingParticle(attacker.m_9236_(), position, slashDirection);
        }

        public void spawnSlashingParticle(Level level, Vec3 slashPosition, Vec3 slashDirection) {
            this.effectType.createPositionedEffect(level, new PositionEffectData(slashPosition), SlashAttackParticleEffect.createData(slashDirection, this.isMirrored, this.slashAngle, this.spiritType));
        }

        public static interface SlashEffectDataSupplier {
            public NBTEffectData createData(Vec3 var1, boolean var2, float var3);
        }
    }
}

