/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.exhaust;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.machinery.misc.exhaust.ExhaustBlock;
import com.drmangotea.tfmg.registry.TFMGFluids;
import com.simibubi.create.Create;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class ExhaustBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    protected LazyOptional<IFluidHandler> fluidCapability;
    public FluidTank tankInventory = this.createInventory();
    public int smokeTimer = 0;

    public ExhaustBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(1000, this::onFluidStackChanged){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().m_6212_((Fluid)TFMGFluids.CARBON_DIOXIDE.getSource());
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidate() {
        super.invalidate();
        this.fluidCapability.invalidate();
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        this.m_6596_();
        this.sendData();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
    }

    public void tick() {
        super.tick();
        if (this.tankInventory.isEmpty()) {
            return;
        }
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)ExhaustBlock.FACING);
        float fillRatio = (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
        int drainRate = 10 + (int)(40.0f * fillRatio);
        if (this.tankInventory.getFluidAmount() > 0) {
            this.tankInventory.drain(drainRate, IFluidHandler.FluidAction.EXECUTE);
            this.smokeTimer = 100;
        }
        if (this.smokeTimer > 0) {
            --this.smokeTimer;
            if ((this.f_58857_.m_46467_() + (long)this.m_58899_().hashCode()) % (long)Math.max(1, 10 - (int)(9.0f * fillRatio)) == 0L) {
                int particleRotation = switch (direction) {
                    case Direction.DOWN -> 1;
                    case Direction.NORTH -> 2;
                    case Direction.SOUTH -> 3;
                    case Direction.EAST -> 4;
                    case Direction.WEST -> 5;
                    default -> 0;
                };
                ExhaustBlockEntity.makeParticles(this.f_58857_, this.m_58899_(), particleRotation);
            }
        }
    }

    public static void makeParticles(Level level, BlockPos pos, int particleRotation) {
        Random random = Create.RANDOM;
        switch (particleRotation) {
            case 1: {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123778_, (double)((float)pos.m_123341_() + random.nextFloat(1.0f)), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + random.nextFloat(1.0f)), 0.0, 0.08, 0.0);
                break;
            }
            case 2: {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123778_, (double)((float)pos.m_123341_() + random.nextFloat(1.0f)), (double)((float)pos.m_123342_() + random.nextFloat(1.0f)), (double)pos.m_123343_(), 0.0, 0.08, 0.0);
                break;
            }
            case 3: {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123778_, (double)((float)pos.m_123341_() + random.nextFloat(1.0f)), (double)((float)pos.m_123342_() + random.nextFloat(1.0f)), (double)(pos.m_123343_() + 1), 0.0, 0.08, 0.0);
                break;
            }
            case 4: {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123778_, (double)(pos.m_123341_() + 1), (double)((float)pos.m_123342_() + random.nextFloat(1.0f)), (double)((float)pos.m_123343_() + random.nextFloat(1.0f)), 0.0, 0.08, 0.0);
                break;
            }
            case 5: {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123778_, (double)pos.m_123341_(), (double)((float)pos.m_123342_() + random.nextFloat(1.0f)), (double)((float)pos.m_123343_() + random.nextFloat(1.0f)), 0.0, 0.08, 0.0);
                break;
            }
            default: {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123778_, (double)((float)pos.m_123341_() + random.nextFloat(1.0f)), (double)(pos.m_123342_() + 1), (double)((float)pos.m_123343_() + random.nextFloat(1.0f)), 0.0, 0.08, 0.0);
            }
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
        compound.m_128379_("Active", this.smokeTimer > 0);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }
}

