/*
 * Decompiled with CFR 0.152.
 */
package net.hyrrx.hardcoretruedarkness;

import net.hyrrx.hardcoretruedarkness.HardcoreTrueDarkness;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="hardcoretruedarkness", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.IntValue PITCH_BLACK_UNTIL_BLOCK_LIGHT_CONFIG = BUILDER.comment("Block light level at or below which areas will become pitch black during full 'true darkness' (inclusive). Example: 0 or 1.").defineInRange("pitchBlackUntilBlockLight", 0, 0, 15);
    private static final ForgeConfigSpec.IntValue DIMMING_ENDS_AT_BLOCK_LIGHT_CONFIG = BUILDER.comment("Block light level at which the darkness dimming effect completely stops (exclusive). Light levels from pitchBlackUntilBlockLight up to (this value - 1) will be progressively less dimmed. Example: 7 (means level 6 is last affected, level 7 is normal).").defineInRange("dimmingEndsAtBlockLight", 7, 0, 16);
    private static final ForgeConfigSpec.LongValue NIGHT_START_TICKS_CONFIG = BUILDER.comment("Tick of the day when 'true darkness' night begins (e.g., 13000 for standard night start).").defineInRange("nightStartTicks", 13000L, 0L, 23999L);
    private static final ForgeConfigSpec.LongValue NIGHT_END_TICKS_CONFIG = BUILDER.comment("Tick of the day when 'true darkness' night ends (e.g., 23000 for standard night end before dawn).").defineInRange("nightEndTicks", 23000L, 0L, 23999L);
    private static final ForgeConfigSpec.LongValue TRANSITION_DURATION_TICKS_CONFIG = BUILDER.comment("Duration in ticks for the darkness to fade in/out (e.g., 400 ticks = 20 seconds). Set to 0 for instant change.").defineInRange("transitionDurationTicks", 400L, 0L, 2400L);
    private static final ForgeConfigSpec.BooleanValue IGNORE_DARKNESS_WITH_NIGHT_VISION_CONFIG = BUILDER.comment("If true, the darkness effect will be disabled when the player has Night Vision.").define("ignoreDarknessWithNightVision", true);
    private static final ForgeConfigSpec.BooleanValue FORCE_CAVE_DARKNESS_CONFIG = BUILDER.comment("If true, areas with sky light at or below 'caveSkyLightThreshold' (typically caves) will be treated as if it's full night for darkness calculation, regardless of the actual time of day. This ensures caves are always truly dark if not lit by block light.").define("forceCaveDarkness", true);
    private static final ForgeConfigSpec.IntValue CAVE_SKY_LIGHT_THRESHOLD_CONFIG = BUILDER.comment("Sky light level (0-15) at or below which 'forceCaveDarkness' applies. 0 means no sky light access (deep underground). Higher values could affect areas under dense tree cover if too high. If caves still seem too bright with 'forceCaveDarkness' enabled, try increasing this value (e.g., to 1 or 2) to account for minor sky light leaks.").defineInRange("caveSkyLightThreshold", 1, 0, 15);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static int pitchBlackUntilBlockLight;
    public static int dimmingEndsAtBlockLight;
    public static long nightStartTicks;
    public static long nightEndTicks;
    public static long transitionDurationTicks;
    public static boolean ignoreDarknessWithNightVision;
    public static boolean forceCaveDarkness;
    public static int caveSkyLightThreshold;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SPEC) {
            Config.loadConfigValues();
            HardcoreTrueDarkness.LOGGER.info("Config loaded for {}", (Object)"hardcoretruedarkness");
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SPEC) {
            Config.loadConfigValues();
            HardcoreTrueDarkness.LOGGER.info("Config reloaded for {}", (Object)"hardcoretruedarkness");
        }
    }

    private static void loadConfigValues() {
        pitchBlackUntilBlockLight = (Integer)PITCH_BLACK_UNTIL_BLOCK_LIGHT_CONFIG.get();
        dimmingEndsAtBlockLight = (Integer)DIMMING_ENDS_AT_BLOCK_LIGHT_CONFIG.get();
        nightStartTicks = (Long)NIGHT_START_TICKS_CONFIG.get();
        nightEndTicks = (Long)NIGHT_END_TICKS_CONFIG.get();
        transitionDurationTicks = (Long)TRANSITION_DURATION_TICKS_CONFIG.get();
        ignoreDarknessWithNightVision = (Boolean)IGNORE_DARKNESS_WITH_NIGHT_VISION_CONFIG.get();
        forceCaveDarkness = (Boolean)FORCE_CAVE_DARKNESS_CONFIG.get();
        caveSkyLightThreshold = (Integer)CAVE_SKY_LIGHT_THRESHOLD_CONFIG.get();
        if (dimmingEndsAtBlockLight <= pitchBlackUntilBlockLight) {
            HardcoreTrueDarkness.LOGGER.warn("Config warning: dimmingEndsAtBlockLight ({}) is not greater than pitchBlackUntilBlockLight ({}). This will result in a sharp cutoff rather than a smooth dimming gradient for higher light levels.", (Object)dimmingEndsAtBlockLight, (Object)pitchBlackUntilBlockLight);
        }
        HardcoreTrueDarkness.LOGGER.debug("Config Values - PitchBlackUntil: {}, DimmingEndsAt: {}, NightStart: {}, NightEnd: {}, TransitionTicks: {}, IgnoreWithNightVision: {}, ForceCaveDarkness: {}, CaveSkyLightThreshold: {}", new Object[]{pitchBlackUntilBlockLight, dimmingEndsAtBlockLight, nightStartTicks, nightEndTicks, transitionDurationTicks, ignoreDarknessWithNightVision, forceCaveDarkness, caveSkyLightThreshold});
    }
}

