/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionDataBuilder;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionLoader;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.tools.modules.ArmorModuleBuilder;

public abstract class AbstractToolDefinitionDataProvider
extends GenericDataProvider {
    private final Map<ResourceLocation, ToolDefinitionDataBuilder> allTools = new HashMap<ResourceLocation, ToolDefinitionDataBuilder>();
    private final String modId;

    public AbstractToolDefinitionDataProvider(PackOutput packOutput, String modId) {
        super(packOutput, PackOutput.Target.DATA_PACK, "tinkering/tool_definitions");
        this.modId = modId;
    }

    protected abstract void addToolDefinitions();

    protected ToolDefinitionDataBuilder define(ResourceLocation id) {
        return this.allTools.computeIfAbsent(id, i -> ToolDefinitionDataBuilder.builder());
    }

    protected ToolDefinitionDataBuilder define(ItemLike item) {
        return this.define(BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_()));
    }

    protected ToolDefinitionDataBuilder define(ToolDefinition definition) {
        return this.define(definition.getId());
    }

    protected ArmorDataBuilder defineArmor(ModifiableArmorMaterial armorMaterial) {
        return new ArmorDataBuilder(armorMaterial);
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addToolDefinitions();
        Map relevantDefinitions = ToolDefinitionLoader.getInstance().getRegisteredToolDefinitions().stream().filter(def -> def.getId().m_135827_().equals(this.modId)).collect(Collectors.toMap(ToolDefinition::getId, Function.identity()));
        for (ToolDefinition definition : relevantDefinitions.values()) {
            ResourceLocation name = definition.getId();
            if (this.allTools.containsKey(name)) continue;
            throw new IllegalStateException(String.format("Missing tool definition for '%s'", name));
        }
        ArrayList<CompletableFuture> tasks = new ArrayList<CompletableFuture>();
        for (Map.Entry<ResourceLocation, ToolDefinitionDataBuilder> entry : this.allTools.entrySet()) {
            ResourceLocation id = entry.getKey();
            ToolDefinition definition = (ToolDefinition)relevantDefinitions.get(id);
            if (definition == null) {
                throw new IllegalStateException("Unknown tool definition with ID " + id);
            }
            tasks.add(this.saveJson(cache, id, ToolDefinitionData.LOADABLE.serialize((Object)entry.getValue().build())));
        }
        return AbstractToolDefinitionDataProvider.allOf(tasks);
    }

    protected class ArmorDataBuilder {
        private final ResourceLocation name;
        private final ToolDefinitionDataBuilder[] builders;
        private final List<ArmorItem.Type> slotTypes;

        private ArmorDataBuilder(ModifiableArmorMaterial armorMaterial) {
            this.name = armorMaterial.getId();
            this.builders = new ToolDefinitionDataBuilder[4];
            ImmutableList.Builder slotTypes = ImmutableList.builder();
            for (ArmorItem.Type slotType : ArmorItem.Type.values()) {
                ToolDefinition definition = armorMaterial.getArmorDefinition(slotType);
                if (definition == null) continue;
                this.builders[slotType.ordinal()] = AbstractToolDefinitionDataProvider.this.define(definition);
                slotTypes.add((Object)slotType);
            }
            this.slotTypes = slotTypes.build();
        }

        protected ToolDefinitionDataBuilder getBuilder(ArmorItem.Type slotType) {
            ToolDefinitionDataBuilder builder = this.builders[slotType.ordinal()];
            if (builder == null) {
                throw new IllegalArgumentException("Unsupported slot type " + slotType + " for material " + this.name);
            }
            return builder;
        }

        @SafeVarargs
        public final <T extends ToolModule> ArmorDataBuilder module(ArmorItem.Type slotType, T module, ModuleHook<? super T> ... hooks) {
            this.getBuilder(slotType).module(module, hooks);
            return this;
        }

        public ArmorDataBuilder module(ArmorItem.Type slotType, ToolModule module) {
            this.getBuilder(slotType).module(module);
            return this;
        }

        public ArmorDataBuilder module(ArmorItem.Type slotType, ToolModule ... modules) {
            this.getBuilder(slotType).module(modules);
            return this;
        }

        @SafeVarargs
        public final <T extends ToolModule> ArmorDataBuilder module(T module, ModuleHook<? super T> ... hooks) {
            for (ArmorItem.Type armorSlot : this.slotTypes) {
                this.module(armorSlot, module, hooks);
            }
            return this;
        }

        public ArmorDataBuilder module(ToolModule module) {
            for (ArmorItem.Type armorSlot : this.slotTypes) {
                this.module(armorSlot, module);
            }
            return this;
        }

        public ArmorDataBuilder module(ToolModule ... modules) {
            for (ArmorItem.Type armorSlot : this.slotTypes) {
                this.module(armorSlot, modules);
            }
            return this;
        }

        @SafeVarargs
        public final <T extends ToolModule> ArmorDataBuilder module(ArmorModuleBuilder<T> builder, ModuleHook<? super T> ... hooks) {
            for (ArmorItem.Type armorSlot : this.slotTypes) {
                this.module(armorSlot, (ToolModule)builder.build(armorSlot), hooks);
            }
            return this;
        }

        public ArmorDataBuilder module(ArmorModuleBuilder<? extends ToolModule> builder) {
            for (ArmorItem.Type armorSlot : this.slotTypes) {
                this.module(armorSlot, builder.build(armorSlot));
            }
            return this;
        }

        @SafeVarargs
        public final <T extends ToolModule> ArmorDataBuilder modules(Function<List<ArmorItem.Type>, ArmorModuleBuilder<T>> constructor, ModuleHook<? super T> ... hooks) {
            return this.module(constructor.apply(this.slotTypes), hooks);
        }

        public ArmorDataBuilder modules(Function<List<ArmorItem.Type>, ArmorModuleBuilder<? extends ToolModule>> constructor) {
            return this.module(constructor.apply(this.slotTypes));
        }
    }
}

