/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.capacity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.armor.ModifyDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.CapacityBarHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.capacity.CapacitySourceModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record DamageToCapacityModule(IJsonPredicate<DamageSource> source, LevelingValue multiplier, boolean reduceDamage, @Nullable ModifierId owner, ModifierCondition<IToolStackView> condition) implements ModifierModule,
ModifyDamageModifierHook,
CapacitySourceModule,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.MODIFY_DAMAGE);
    public static final RecordLoadable<DamageToCapacityModule> LOADER = RecordLoadable.create((RecordField)DamageSourcePredicate.LOADER.requiredField("source", DamageToCapacityModule::source), (RecordField)LevelingValue.LOADABLE.requiredField("multiplier", DamageToCapacityModule::multiplier), (RecordField)BooleanLoadable.INSTANCE.requiredField("reduce_damage", DamageToCapacityModule::reduceDamage), (RecordField)OWNER_FIELD, ModifierCondition.TOOL_FIELD, DamageToCapacityModule::new);

    public RecordLoadable<DamageToCapacityModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public float modifyDamageTaken(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        if (this.condition.matches(tool, modifier) && this.source.matches((Object)source)) {
            ModifierEntry barModifier = this.barModifier(tool, modifier);
            CapacityBarHook bar = barModifier.getHook(ModifierHooks.CAPACITY_BAR);
            int capacity = bar.getCapacity(tool, barModifier);
            int current = bar.getAmount(tool);
            if (current < capacity) {
                int added = Math.min(capacity - current, Mth.m_14167_((float)(amount * this.multiplier.compute(modifier.getEffectiveLevel()))));
                bar.setAmount(tool, barModifier, current + added);
                if (this.reduceDamage) {
                    amount -= (float)added;
                }
            }
        }
        return amount;
    }

    public static Builder source(IJsonPredicate<DamageSource> source) {
        return new Builder(source);
    }

    public static class Builder
    extends CapacitySourceModule.Builder<Builder>
    implements LevelingValue.Builder<DamageToCapacityModule> {
        private final IJsonPredicate<DamageSource> source;
        private boolean reduceDamage = false;

        public Builder reduceDamage() {
            this.reduceDamage = true;
            return this;
        }

        @Override
        public DamageToCapacityModule amount(float flat, float eachLevel) {
            return new DamageToCapacityModule(this.source, new LevelingValue(flat, eachLevel), this.reduceDamage, this.owner, this.condition);
        }

        private Builder(IJsonPredicate<DamageSource> source) {
            this.source = source;
        }
    }
}

