/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.block;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.block.ActionSetBlockProperty;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.block.CTBlockIngredient;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.mixin.common.access.block.AccessBlockStateBase;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/block/BlockState")
@NativeTypeRegistration(value=BlockState.class, zenCodeName="crafttweaker.api.block.BlockState")
public class ExpandBlockState {
    @ZenCodeType.Method
    @ZenCodeType.Getter(value="soundType")
    public static SoundType getSoundType(BlockState internal) {
        return internal.m_60827_();
    }

    @ZenCodeType.Method
    public static BlockState rotate(BlockState internal, Rotation rotation) {
        return internal.m_60717_(rotation);
    }

    @ZenCodeType.Getter(value="block")
    @ZenCodeType.Caster(implicit=true)
    public static Block getBlock(BlockState internal) {
        return internal.m_60734_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="lightEmission")
    public static int getLightEmission(BlockState internal) {
        return internal.m_60791_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isSignalSource")
    public static boolean isSignalSource(BlockState internal) {
        return internal.m_60803_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="canOcclude")
    public static boolean canOcclude(BlockState internal) {
        return internal.m_60815_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isRandomlyTicking")
    public static boolean isRandomlyTicking(BlockState internal) {
        return internal.m_60823_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="hasBlockEntity")
    public static boolean hasBlockEntity(BlockState internal) {
        return internal.m_155947_();
    }

    @ZenCodeType.Method
    public static BlockState withProperty(BlockState internal, String name, String value) {
        Property property = internal.m_60734_().m_49965_().m_61081_(name);
        if (property == null) {
            CommonLoggers.api().warn("Invalid property name");
        } else {
            Optional propValue = property.m_6215_(value);
            if (propValue.isPresent()) {
                return (BlockState)internal.m_61124_(property, (Comparable)propValue.get());
            }
            CommonLoggers.api().warn("Invalid property value");
        }
        return internal;
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="propertyNames")
    public static List<String> getPropertyNames(BlockState internal) {
        ArrayList<String> props = new ArrayList<String>();
        for (Property prop : internal.m_61147_()) {
            props.add(prop.m_61708_());
        }
        return ImmutableList.copyOf(props);
    }

    @ZenCodeType.Method
    public static String getPropertyValue(BlockState internal, String name) {
        Property prop = internal.m_60734_().m_49965_().m_61081_(name);
        if (prop != null) {
            return internal.m_61143_(prop).toString();
        }
        CommonLoggers.api().warn("Invalid property name");
        return "";
    }

    @ZenCodeType.Method
    public static List<String> getAllowedValuesForProperty(BlockState internal, String name) {
        Property prop = internal.m_60734_().m_49965_().m_61081_(name);
        if (prop != null) {
            ArrayList<String> values = new ArrayList<String>();
            prop.m_6908_().forEach(v -> values.add(v.toString()));
            return values;
        }
        CommonLoggers.api().warn("Invalid property name");
        return ImmutableList.of();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="properties")
    public static Map<String, String> getProperties(BlockState internal) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Property key : internal.m_61147_()) {
            props.put(key.m_61708_(), internal.m_61143_(key).toString());
        }
        return ImmutableMap.copyOf(props);
    }

    @ZenCodeType.Method
    public static boolean hasProperty(BlockState internal, String name) {
        Property prop = internal.m_60734_().m_49965_().m_61081_(name);
        return prop != null;
    }

    @ZenCodeType.Method
    public static String asString(BlockState internal) {
        return internal.toString();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="destroySpeed")
    public static float getDestroySpeed(BlockState internal) {
        return ((AccessBlockStateBase)internal).crafttweaker$getDestroySpeed();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="destroySpeed")
    public static void setDestroySpeed(BlockState internal, float destroySpeed) {
        CraftTweakerAPI.apply(new ActionSetBlockProperty<Float>(internal, "Destroy Speed", Float.valueOf(destroySpeed), Float.valueOf(((AccessBlockStateBase)internal).crafttweaker$getDestroySpeed()), value -> ((AccessBlockStateBase)internal).crafttweaker$setDestroySpeed(value.floatValue())));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="commandString")
    @ZenCodeType.Caster
    public static String getCommandString(BlockState internal) {
        StringBuilder builder = new StringBuilder("<blockstate:");
        builder.append(ExpandBlock.getRegistryName(ExpandBlockState.getBlock(internal)));
        if (!ExpandBlockState.getProperties(internal).isEmpty()) {
            builder.append(":");
            builder.append(ExpandBlockState.getProperties(internal).entrySet().stream().map(kv -> (String)kv.getKey() + "=" + (String)kv.getValue()).collect(Collectors.joining(",")));
        }
        builder.append(">");
        return builder.toString();
    }

    @ZenCodeType.Caster(implicit=true)
    public static CTBlockIngredient asBlockIngredient(BlockState internal) {
        return new CTBlockIngredient.BlockStateIngredient(internal);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static CTBlockIngredient asList(BlockState internal, CTBlockIngredient other) {
        ArrayList<CTBlockIngredient> elements = new ArrayList<CTBlockIngredient>();
        elements.add(ExpandBlockState.asBlockIngredient(internal));
        elements.add(other);
        return new CTBlockIngredient.CompoundBlockIngredient(elements);
    }
}

