/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.expression;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.expression.CallArguments;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.ExpressionTransformer;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitor;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitorWithContext;
import org.openzen.zenscript.codemodel.scope.TypeScope;

public class GlobalCallExpression
extends Expression {
    public final String name;
    public final CallArguments arguments;
    public final Expression resolution;

    public GlobalCallExpression(CodePosition position, String name, CallArguments arguments, Expression resolution) {
        super(position, resolution.type, resolution.thrownType);
        this.name = name;
        this.arguments = arguments;
        this.resolution = resolution;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitGlobalCall(this);
    }

    @Override
    public <C, R> R accept(C context, ExpressionVisitorWithContext<C, R> visitor) {
        return visitor.visitGlobalCall(context, this);
    }

    @Override
    public Expression transform(ExpressionTransformer transformer) {
        CallArguments tArguments = this.arguments.transform(transformer);
        Expression tResolution = this.resolution.transform(transformer);
        return tArguments == this.arguments && tResolution == this.resolution ? this : new GlobalCallExpression(this.position, this.name, tArguments, tResolution);
    }

    @Override
    public Expression normalize(TypeScope scope) {
        return new GlobalCallExpression(this.position, this.name, this.arguments, this.resolution.normalize(scope));
    }
}

