/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.block.alchemist_cauldron;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.backwards_compat.FluidHelper;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.fluids.PotionFluid;
import io.redspace.ironsspellbooks.item.InkItem;
import io.redspace.ironsspellbooks.recipe_types.alchemist_cauldron.BrewAlchemistCauldronRecipe;
import io.redspace.ironsspellbooks.recipe_types.alchemist_cauldron.EmptyAlchemistCauldronRecipe;
import io.redspace.ironsspellbooks.recipe_types.alchemist_cauldron.FillAlchemistCauldronRecipe;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.registries.RecipeRegistry;
import io.redspace.ironsspellbooks.util.ModTags;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class AlchemistCauldronTile
extends BlockEntity
implements WorldlyContainer {
    public static int INPUT_SIZE = 4;
    public final NonNullList<ItemStack> inputItems = NonNullList.m_122780_((int)INPUT_SIZE, (Object)ItemStack.f_41583_);
    private final int[] cooktimes = new int[INPUT_SIZE];
    public AlchemistCauldronFluidHandler fluidInventory;
    private LazyOptional<IFluidHandler> fluidHandlerLazyOptional = LazyOptional.of(() -> this.fluidInventory);
    public static final Capability<IFluidHandler> FLUID_HANDLER = CapabilityManager.get((CapabilityToken)new CapabilityToken<IFluidHandler>(){});

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHandlerLazyOptional.invalidate();
    }

    public AlchemistCauldronTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockRegistry.ALCHEMIST_CAULDRON_TILE.get(), pWorldPosition, pBlockState);
        this.fluidInventory = new AlchemistCauldronFluidHandler();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState blockState, AlchemistCauldronTile cauldronTile) {
        for (int i = 0; i < cauldronTile.inputItems.size(); ++i) {
            ItemStack itemStack = (ItemStack)cauldronTile.inputItems.get(i);
            if (itemStack.m_41619_() || !cauldronTile.isBoiling(blockState)) {
                cauldronTile.cooktimes[i] = 0;
            } else {
                int n = i;
                cauldronTile.cooktimes[n] = cauldronTile.cooktimes[n] + 1;
            }
            if (cauldronTile.cooktimes[i] <= 100) continue;
            cauldronTile.tryMeltInput(itemStack);
            cauldronTile.cooktimes[i] = 0;
        }
        RandomSource random = Utils.random;
        if (cauldronTile.isBoiling(blockState)) {
            float waterLevel = Mth.m_14179_((float)((float)cauldronTile.getFluidAmount() / 1000.0f), (float)0.25f, (float)0.9f);
            MagicManager.spawnParticles(level, (ParticleOptions)ParticleTypes.f_123772_, (float)pos.m_123341_() + Mth.m_216283_((RandomSource)random, (float)0.2f, (float)0.8f), (float)pos.m_123342_() + waterLevel, (float)pos.m_123343_() + Mth.m_216283_((RandomSource)random, (float)0.2f, (float)0.8f), 1, 0.0, 0.0, 0.0, 0.0, false);
        }
    }

    public ItemStack tryExecuteRecipeInteractions(Level level, ItemStack itemStack) {
        ItemStack potionStack;
        SimpleContainer fillRecipeInput = new SimpleContainer(new ItemStack[]{itemStack});
        RecipeManager recipeManager = level.m_7465_();
        Optional<FillAlchemistCauldronRecipe> fillRecipe = recipeManager.m_44015_((RecipeType)RecipeRegistry.ALCHEMIST_CAULDRON_FILL_TYPE.get(), (Container)fillRecipeInput, level);
        if (fillRecipe.isEmpty() && FluidHelper.hasPotionContents(itemStack)) {
            FluidStack fluid = FluidHelper.isWater(itemStack) ? new FluidStack((Fluid)Fluids.f_76193_, 250) : PotionFluid.from(itemStack);
            fillRecipe = Optional.of(new FillAlchemistCauldronRecipe(IronsSpellbooks.id("generated"), Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack}), new ItemStack((ItemLike)Items.f_42590_), fluid, true, (Holder<SoundEvent>)BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11769_)));
        }
        if (fillRecipe.isPresent()) {
            FillAlchemistCauldronRecipe recipe = (FillAlchemistCauldronRecipe)fillRecipe.get();
            int amountThatCanFit = this.fluidInventory.fill(recipe.result(), IFluidHandler.FluidAction.SIMULATE);
            if (!(recipe.mustFitAll() && amountThatCanFit != recipe.result().getAmount() || amountThatCanFit == 0)) {
                this.fluidInventory.fill(recipe.result(), IFluidHandler.FluidAction.EXECUTE);
                this.m_6596_();
                level.m_247517_(null, this.m_58899_(), (SoundEvent)recipe.fillSound().m_203334_(), SoundSource.BLOCKS);
                return recipe.m_5874_((Container)fillRecipeInput, level.m_9598_());
            }
        }
        FluidStack topFluid = this.fluidInventory.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        EmptyAlchemistCauldronRecipe.Input emptyRecipeInput = new EmptyAlchemistCauldronRecipe.Input(itemStack, topFluid);
        Optional<EmptyAlchemistCauldronRecipe> emptyRecipe = recipeManager.m_44015_((RecipeType)RecipeRegistry.ALCHEMIST_CAULDRON_EMPTY_TYPE.get(), (Container)emptyRecipeInput, level);
        if (emptyRecipe.isEmpty() && itemStack.m_150930_(Items.f_42590_) && !(potionStack = PotionFluid.from(topFluid)).m_41619_()) {
            emptyRecipe = Optional.of(new EmptyAlchemistCauldronRecipe(IronsSpellbooks.id("generated"), Ingredient.f_43901_, potionStack, FluidHelper.copyWithAmount(topFluid, 250), (Holder<SoundEvent>)BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11770_)));
        }
        if (emptyRecipe.isPresent()) {
            EmptyAlchemistCauldronRecipe recipe = (EmptyAlchemistCauldronRecipe)emptyRecipe.get();
            this.fluidInventory.drain(recipe.fluid(), IFluidHandler.FluidAction.EXECUTE);
            level.m_247517_(null, this.m_58899_(), (SoundEvent)recipe.emptySound().m_203334_(), SoundSource.BLOCKS);
            this.m_6596_();
            return recipe.assemble(emptyRecipeInput, level.m_9598_());
        }
        return ItemStack.f_41583_;
    }

    public InteractionResult handleUse(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        ItemStack recipeResult = this.tryExecuteRecipeInteractions(level, itemStack);
        if (!recipeResult.m_41619_()) {
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)player.m_21120_(hand), (Player)player, (ItemStack)recipeResult));
            return InteractionResult.SUCCESS;
        }
        if (this.isValidInput(itemStack)) {
            if (!level.f_46443_) {
                for (int i = 0; i < this.inputItems.size(); ++i) {
                    ItemStack stack = (ItemStack)this.inputItems.get(i);
                    if (!stack.m_41619_()) continue;
                    ItemStack input = player.m_150110_().f_35937_ ? itemStack.m_41777_() : itemStack.m_41620_(1);
                    input.m_41764_(1);
                    this.inputItems.set(i, (Object)input);
                    player.m_21008_(hand, itemStack);
                    this.m_6596_();
                    break;
                }
            }
            return InteractionResult.SUCCESS;
        }
        if ((itemStack.m_41619_() || player.m_6047_()) && hand.equals((Object)InteractionHand.MAIN_HAND)) {
            for (ItemStack item : this.inputItems) {
                if (item.m_41619_()) continue;
                if (!level.f_46443_) {
                    ItemStack take = item.m_41620_(1);
                    if (player.m_21120_(hand).m_41619_()) {
                        player.m_21008_(hand, take);
                    } else if (!player.m_150109_().m_36054_(take)) {
                        player.m_36176_(take, false);
                    }
                    this.m_6596_();
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }

    public void tryMeltInput(ItemStack itemStack) {
        BrewAlchemistCauldronRecipe.Input input;
        Level level;
        if (this.f_58857_ == null || !((level = this.f_58857_) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean shouldMelt = false;
        boolean success = true;
        Optional<Object> byproduct = Optional.empty();
        if (itemStack.m_150930_((Item)ItemRegistry.SCROLL.get()) && this.fluidInventory.contains((TagKey<Fluid>)FluidTags.f_13131_, 250)) {
            if ((double)Utils.random.m_188501_() < (Double)ServerConfigs.SCROLL_RECYCLE_CHANCE.get()) {
                this.fluidInventory.drain(new FluidStack((Fluid)Fluids.f_76193_, 250), IFluidHandler.FluidAction.EXECUTE);
                this.fluidInventory.fill(new FluidStack(AlchemistCauldronTile.getInkFromScroll(itemStack).fluid().get(), 250), IFluidHandler.FluidAction.EXECUTE);
            } else {
                success = false;
            }
            shouldMelt = true;
        }
        if (!shouldMelt) {
            for (FluidStack fluid : this.fluidInventory.fluids()) {
                BrewAlchemistCauldronRecipe recipe;
                int totalNewFluid;
                input = new BrewAlchemistCauldronRecipe.Input(fluid, itemStack);
                Optional brewRecipeOpt = serverLevel.m_7465_().m_44015_((RecipeType)RecipeRegistry.ALCHEMIST_CAULDRON_BREW_TYPE.get(), (Container)input, (Level)serverLevel);
                if (!brewRecipeOpt.isPresent() || !this.fluidInventory.canFit((totalNewFluid = (recipe = (BrewAlchemistCauldronRecipe)brewRecipeOpt.get()).results().stream().mapToInt(FluidStack::getAmount).sum()) - recipe.fluidIn().getAmount()) || !this.fluidInventory.contains(recipe.fluidIn(), recipe.fluidIn().getAmount())) continue;
                shouldMelt = true;
                this.fluidInventory.drain(recipe.fluidIn(), IFluidHandler.FluidAction.EXECUTE);
                recipe.results().forEach(result -> this.fluidInventory.fill((FluidStack)result, IFluidHandler.FluidAction.EXECUTE));
                byproduct = recipe.byproduct();
            }
        }
        if (!shouldMelt && this.isBrewable(itemStack)) {
            for (FluidStack fluid : this.fluidInventory.fluids()) {
                ItemStack potionResult;
                ItemStack potionGhostStack = PotionFluid.from(fluid);
                if (potionGhostStack.m_41619_() || (potionResult = FluidHelper.getNonDestructiveBrewingResult(potionGhostStack, itemStack, (Level)serverLevel)).m_41619_()) continue;
                FluidStack fluidResult = FluidHelper.copyWithAmount(PotionFluid.from(potionResult), fluid.getAmount());
                this.fluidInventory.drain(fluid, IFluidHandler.FluidAction.EXECUTE);
                this.fluidInventory.fill(fluidResult, IFluidHandler.FluidAction.EXECUTE);
                shouldMelt = true;
            }
        }
        if (shouldMelt) {
            itemStack.m_41774_(1);
            if (byproduct.isPresent()) {
                for (int i = 0; i < this.inputItems.size(); ++i) {
                    ItemStack stack = (ItemStack)this.inputItems.get(i);
                    if (!stack.m_41619_()) continue;
                    input = ((ItemStack)byproduct.get()).m_41620_(1);
                    this.inputItems.set(i, (Object)input);
                    break;
                }
                Vec3 pos = Vec3.m_82514_((Vec3i)this.m_58899_(), (double)1.0);
                Containers.m_18992_((Level)this.f_58857_, (double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_, (ItemStack)((ItemStack)byproduct.get()).m_41620_(1));
            }
            this.m_6596_();
            if (success) {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11772_, SoundSource.MASTER, 1.0f, 1.0f);
                this.f_58857_.markAndNotifyBlock(this.m_58899_(), this.f_58857_.m_46745_(this.m_58899_()), this.m_58900_(), this.m_58900_(), 1, 1);
            } else {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11914_, SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
    }

    public boolean isValidInput(ItemStack itemStack) {
        return itemStack.m_150930_((Item)ItemRegistry.SCROLL.get()) || this.isBrewable(itemStack) || this.f_58857_ != null && this.f_58857_.m_7465_().m_44013_((RecipeType)RecipeRegistry.ALCHEMIST_CAULDRON_BREW_TYPE.get()).stream().anyMatch(holder -> holder.reagent().test(itemStack));
    }

    public boolean isBrewable(ItemStack itemStack) {
        return (Boolean)ServerConfigs.ALLOW_CAULDRON_BREWING.get() != false && this.f_58857_ != null && FluidHelper.isBrewingIngredient(itemStack, this.f_58857_);
    }

    public static InkItem getInkFromScroll(ItemStack scrollStack) {
        ISpellContainer spellContainer = ISpellContainer.get(scrollStack);
        SpellData spellData = spellContainer.getSpellAtIndex(0);
        SpellRarity rarity = spellData.getSpell().getRarity(spellData.getLevel());
        return InkItem.getInkForRarity(rarity);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return false;
    }

    public void m_142466_(CompoundTag tag) {
        Utils.loadAllItems(tag, this.inputItems, "Items");
        this.fluidInventory.load("Results", tag, (HolderLookup.Provider)(this.f_58857_ == null ? null : this.f_58857_.m_9598_()));
        super.m_142466_(tag);
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        Utils.saveAllItems(tag, this.inputItems, "Items");
        this.fluidInventory.save("Results", tag, (HolderLookup.Provider)(this.f_58857_ == null ? null : this.f_58857_.m_9598_()));
        super.m_183515_(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        return packet;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.inputItems.clear();
        this.fluidInventory.clear();
        if (tag != null) {
            this.m_142466_(tag);
        }
    }

    public void drops() {
        SimpleContainer simpleContainer = new SimpleContainer(this.inputItems.size());
        for (int i = 0; i < this.inputItems.size(); ++i) {
            simpleContainer.m_6836_(i, (ItemStack)this.inputItems.get(i));
        }
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)simpleContainer);
        }
    }

    public int[] m_7071_(Direction pSide) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return pDirection != Direction.DOWN && this.isValidInput(pItemStack) && this.m_8020_(pIndex).m_41619_();
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return pDirection == Direction.DOWN;
    }

    public void m_6211_() {
        this.inputItems.clear();
        this.fluidInventory.clear();
    }

    public int m_6643_() {
        return INPUT_SIZE;
    }

    public boolean m_7983_() {
        return this.inputItems.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int pSlot) {
        return pSlot >= 0 && pSlot <= this.inputItems.size() ? (ItemStack)this.inputItems.get(pSlot) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return ContainerHelper.m_18969_(this.inputItems, (int)pSlot, (int)pAmount);
    }

    public ItemStack m_8016_(int pSlot) {
        return pSlot >= 0 && pSlot <= this.inputItems.size() ? (ItemStack)this.inputItems.remove(pSlot) : ItemStack.f_41583_;
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        if (pSlot >= 0 && pSlot <= this.inputItems.size()) {
            this.inputItems.set(pSlot, (Object)pStack);
        }
    }

    public boolean isBoiling(BlockState blockState) {
        return this.getFluidAmount() >= 1;
    }

    public int getFluidAmount() {
        return this.fluidInventory.fluidAmount();
    }

    public class AlchemistCauldronFluidHandler
    implements IFluidHandler {
        IFluidTank[] tanks = new IFluidTank[]{new CallbackFluidTank(1000), new CallbackFluidTank(1000), new CallbackFluidTank(1000), new CallbackFluidTank(1000)};

        public int getTanks() {
            return this.tanks.length;
        }

        public FluidStack getFluidInTank(int tank) {
            return tank < 0 || tank > this.tanks.length ? FluidStack.EMPTY : (this.tanks[tank].getFluidAmount() == 0 ? FluidStack.EMPTY : this.tanks[tank].getFluid());
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public int fluidAmount() {
            return this.fluids().stream().mapToInt(FluidStack::getAmount).sum();
        }

        public boolean canFit(int fluidAmount) {
            return fluidAmount + this.fluidAmount() <= 1000;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return tank >= 0 && tank <= this.tanks.length && this.tanks[tank].isFluidValid(stack);
        }

        public boolean isTankCompatible(IFluidTank tank, FluidStack stack) {
            return tank.isFluidValid(stack) && FluidHelper.isSameFluidSameComponents(tank.getFluid(), stack);
        }

        public void onContentsChanged() {
            AlchemistCauldronTile.this.m_6596_();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid().m_205067_(ModTags.CAULDRON_FLUID_DISALLOW)) {
                return 0;
            }
            int resourceLocation = -1;
            int emptyLocation = -1;
            int remainingCapacity = 1000 - this.fluidAmount();
            if (remainingCapacity == 0) {
                return 0;
            }
            for (int i = 0; i < this.tanks.length; ++i) {
                if (this.isTankCompatible(this.tanks[i], resource)) {
                    resourceLocation = i;
                    break;
                }
                if (emptyLocation != -1 || !this.tanks[i].getFluid().isEmpty()) continue;
                emptyLocation = i;
            }
            FluidStack copy = FluidHelper.copyWithAmount(resource, Math.min(remainingCapacity, resource.getAmount()));
            if (resourceLocation >= 0) {
                return this.tanks[resourceLocation].fill(copy, action);
            }
            if (emptyLocation >= 0) {
                return this.tanks[emptyLocation].fill(copy, action);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            for (int i = 0; i < this.tanks.length; ++i) {
                IFluidTank tank = this.tanks[i];
                if (!this.isTankCompatible(tank, resource)) continue;
                FluidStack result = tank.drain(resource, action);
                for (int j = i; j < this.tanks.length - 1; ++j) {
                    for (int k = j + 1; k < this.tanks.length && this.tanks[j].getFluid().isEmpty() && !this.tanks[k].getFluid().isEmpty(); ++k) {
                        IFluidTank tmp = this.tanks[j];
                        this.tanks[j] = this.tanks[k];
                        this.tanks[k] = tmp;
                    }
                }
                return result;
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            for (int i = this.tanks.length - 1; i >= 0; --i) {
                IFluidTank tank = this.tanks[i];
                if (tank.getFluid().isEmpty()) continue;
                return tank.drain(maxDrain, action);
            }
            return FluidStack.EMPTY;
        }

        public boolean contains(FluidStack stack, int minAmount) {
            for (IFluidTank tank : this.tanks) {
                if (!this.isTankCompatible(tank, stack)) continue;
                return tank.getFluidAmount() >= minAmount;
            }
            return false;
        }

        public boolean contains(Holder<Fluid> fluid, int minAmount) {
            for (IFluidTank tank : this.tanks) {
                if (!tank.getFluid().getFluid().equals(fluid.m_203334_())) continue;
                return tank.getFluidAmount() >= minAmount;
            }
            return false;
        }

        public boolean contains(TagKey<Fluid> fluid, int minAmount) {
            for (IFluidTank tank : this.tanks) {
                if (!tank.getFluid().getFluid().m_205067_(fluid)) continue;
                return tank.getFluidAmount() >= minAmount;
            }
            return false;
        }

        public List<FluidStack> fluids() {
            return Arrays.stream(this.tanks).map(IFluidTank::getFluid).filter(f -> !f.isEmpty()).toList();
        }

        public void clear() {
            for (IFluidTank tank : this.tanks) {
                tank.drain(tank.getCapacity(), IFluidHandler.FluidAction.EXECUTE);
            }
        }

        public void save(String name, CompoundTag tag, HolderLookup.Provider access) {
            ListTag fluids = new ListTag();
            for (IFluidTank tank : this.tanks) {
                if (tank.getFluid().isEmpty()) continue;
                fluids.add((Object)tank.getFluid().writeToNBT(new CompoundTag()));
            }
            tag.m_128365_(name, (Tag)fluids);
        }

        public void load(String name, CompoundTag tag, HolderLookup.Provider access) {
            if (tag.m_128425_(name, 9)) {
                ListTag fluids = tag.m_128437_(name, 10);
                int i = 0;
                try {
                    for (Tag l : fluids) {
                        FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)l));
                        this.tanks[i++].fill(stack, IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                catch (Exception e) {
                    IronsSpellbooks.LOGGER.error("Alchemist Cauldron Handler Failed to load fluid, skipping: {}", (Object)e.getMessage());
                }
            }
        }

        public class CallbackFluidTank
        extends FluidTank {
            public CallbackFluidTank(int capacity) {
                super(capacity);
            }

            protected void onContentsChanged() {
                super.onContentsChanged();
                AlchemistCauldronFluidHandler.this.onContentsChanged();
            }
        }
    }
}

