/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.client.screen.roboSurgeon;

import com.maxwell.cyber_ware_port.common.network.ClientPacketHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cyber_ware_port", value={Dist.CLIENT})
public class SurgeryOverlay {
    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() != VanillaGuiOverlay.HELMET.type()) {
            return;
        }
        int progress = ClientPacketHandler.currentProgress;
        int max = ClientPacketHandler.maxProgress;
        if (progress <= 0) {
            return;
        }
        float alpha = 0.0f;
        if (progress < 30) {
            alpha = (float)progress / 30.0f;
        } else if (progress > max - 20) {
            float remaining = max - progress;
            alpha = remaining / 20.0f;
        } else {
            alpha = 1.0f;
        }
        alpha = Math.max(0.0f, Math.min(1.0f, alpha));
        if (alpha > 0.0f) {
            SurgeryOverlay.renderBlackout(event.getGuiGraphics(), alpha);
        }
    }

    private static void renderBlackout(GuiGraphics g, float alpha) {
        Minecraft mc = Minecraft.m_91087_();
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        g.m_280168_().m_85836_();
        g.m_280168_().m_252880_(0.0f, 0.0f, 2000.0f);
        int color = (int)(alpha * 255.0f) << 24;
        g.m_280509_(0, 0, width, height, color);
        g.m_280168_().m_85849_();
        RenderSystem.disableBlend();
    }
}

