/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.client.upgrades.cyberEye;

import com.maxwell.cyber_ware_port.client.ClientCyberwareSettings;
import com.maxwell.cyber_ware_port.common.capability.CyberwareCapabilityProvider;
import com.maxwell.cyber_ware_port.common.item.base.ICyberware;
import com.maxwell.cyber_ware_port.common.network.A_PacketHandler;
import com.maxwell.cyber_ware_port.common.network.ToggleCyberwarePacket;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.joml.Matrix4f;

public class CyberwareMenuScreen
extends Screen {
    private static final ResourceLocation HUD_COLOR_ICON = ResourceLocation.fromNamespaceAndPath((String)"cyber_ware_port", (String)"textures/gui/hud_color.png");
    private static final ResourceLocation HUD_POS_ICON = ResourceLocation.fromNamespaceAndPath((String)"cyber_ware_port", (String)"textures/gui/hud_pos.png");
    private static final ResourceLocation HUD_RESET_ICON = ResourceLocation.fromNamespaceAndPath((String)"cyber_ware_port", (String)"textures/gui/hud_reset.png");
    private static final float INNER_RADIUS = 40.0f;
    private static final float OUTER_RADIUS = 100.0f;
    private static final float ITEM_RADIUS = 70.0f;
    private final List<ToggleablePart> parts = new ArrayList<ToggleablePart>();
    private boolean isHudMoveMode = false;
    private boolean isDraggingHud = false;
    private int dragOffsetX = 0;
    private int dragOffsetY = 0;
    private static final int HUD_WIDTH = 80;
    private static final int HUD_HEIGHT = 25;
    private static final int POS_BTN_X = 338;
    private static final int POS_BTN_Y = 63;
    private static final int BTN_SIZE = 16;
    public boolean isColorSettingsOpen = false;
    private EditBox hexInput;
    private static final int[] PRESET_COLORS = new int[]{-16711681, -16711936, -65536, -256, -1, -65281, -16776961, Short.MIN_VALUE};

    public CyberwareMenuScreen() {
        super((Component)Component.m_237115_((String)"gui.cyber_ware_port.menu"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.parts.clear();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
                ItemStackHandler handler = data.getInstalledCyberware();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ICyberware cw;
                    Item patt3434$temp;
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.m_41619_() || !((patt3434$temp = stack.m_41720_()) instanceof ICyberware) || !(cw = (ICyberware)patt3434$temp).canToggle(stack)) continue;
                    this.parts.add(new ToggleablePart(i, stack, cw));
                }
            });
        }
        int boxWidth = 80;
        int boxHeight = 20;
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.hexInput = new EditBox(this.f_96547_, centerX - boxWidth / 2, centerY + 30, boxWidth, boxHeight, (Component)Component.m_237113_((String)"Color Hex"));
        this.hexInput.m_94199_(8);
        this.hexInput.m_94144_(ClientCyberwareSettings.getHudColorAsHex());
        this.hexInput.m_94182_(true);
        this.hexInput.m_94194_(false);
        this.hexInput.m_94151_(ClientCyberwareSettings::setHudColorFromHex);
        this.m_142416_((GuiEventListener)this.hexInput);
    }

    public void m_86600_() {
        super.m_86600_();
        this.hexInput.m_94120_();
        this.handleMovementInput();
    }

    private void handleMovementInput() {
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        if (this.hexInput.m_93696_()) {
            return;
        }
        this.updateKey(this.f_96541_.f_91066_.f_92085_);
        this.updateKey(this.f_96541_.f_91066_.f_92087_);
        this.updateKey(this.f_96541_.f_91066_.f_92086_);
        this.updateKey(this.f_96541_.f_91066_.f_92088_);
        this.updateKey(this.f_96541_.f_91066_.f_92089_);
        this.updateKey(this.f_96541_.f_91066_.f_92091_);
        this.updateKey(this.f_96541_.f_91066_.f_92090_);
    }

    private void updateKey(KeyMapping keyMapping) {
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        int keyCode = keyMapping.getKey().m_84873_();
        boolean isDown = InputConstants.m_84830_((long)window, (int)keyCode);
        keyMapping.m_7249_(isDown);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.isColorSettingsOpen && this.hexInput.m_93696_()) {
            if (this.hexInput.m_7933_(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (keyCode == 256) {
                this.toggleColorSettings();
                return true;
            }
        }
        if (this.isHudMoveMode && (keyCode == 256 || keyCode == this.f_96541_.f_91066_.f_92092_.getKey().m_84873_())) {
            this.isHudMoveMode = false;
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.isColorSettingsOpen && this.hexInput.m_93696_() && this.hexInput.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        if (this.isColorSettingsOpen || this.isHudMoveMode) {
            g.m_280024_(0, 0, this.f_96543_, this.f_96544_, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        if (!this.isColorSettingsOpen && !this.isHudMoveMode) {
            this.renderRadialMenu(g, centerX, centerY, mouseX, mouseY);
        }
        this.renderHudPreview(g, mouseX, mouseY);
        if (!this.isHudMoveMode) {
            this.renderIconButton(g, HUD_COLOR_ICON, 338, 83, mouseX, mouseY, "HUD Color Settings");
            if (!this.isColorSettingsOpen) {
                this.renderIconButton(g, HUD_POS_ICON, 338, 63, mouseX, mouseY, "Move HUD Position");
            }
        }
        if (this.isColorSettingsOpen) {
            this.renderColorSettings(g, centerX, centerY, mouseX, mouseY);
        }
        if (this.isHudMoveMode) {
            g.m_280137_(this.f_96547_, "HUD MOVE MODE", centerX, 40, -16711936);
            g.m_280137_(this.f_96547_, "Drag HUD to move / Press ESC to finish", centerX, 55, -1);
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private void renderIconButton(GuiGraphics g, ResourceLocation texture, int x, int y, int mouseX, int mouseY, String tooltip) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        float[] rgba = ClientCyberwareSettings.getColorFloats();
        RenderSystem.setShaderColor((float)rgba[0], (float)rgba[1], (float)rgba[2], (float)rgba[3]);
        g.m_280411_(texture, x, y, 16, 16, 0.0f, 0.0f, 8, 8, 8, 8);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (mouseX >= x && mouseX <= x + 16 && mouseY >= y && mouseY <= y + 16) {
            g.m_280637_(x - 1, y - 1, 18, 18, -1);
            if (!this.isColorSettingsOpen && !this.isHudMoveMode) {
                g.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)tooltip), mouseX, mouseY);
            }
        }
    }

    private void renderRadialMenu(GuiGraphics g, int centerX, int centerY, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        Matrix4f matrix = g.m_280168_().m_85850_().m_252922_();
        float red = 1.0f;
        float green = 0.0f;
        float blue = 0.0f;
        float alpha = 0.4f;
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        int segments = 60;
        for (int i = 0; i <= segments; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)segments;
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            buffer.m_252986_(matrix, (float)centerX + cos * 100.0f, (float)centerY + sin * 100.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            buffer.m_252986_(matrix, (float)centerX + cos * 40.0f, (float)centerY + sin * 40.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        if (!this.parts.isEmpty()) {
            double angleStep = Math.PI * 2 / (double)this.parts.size();
            for (int i = 0; i < this.parts.size(); ++i) {
                ToggleablePart part = this.parts.get(i);
                double itemAngle = (double)i * angleStep - 1.5707963267948966;
                int x = centerX + (int)(70.0 * Math.cos(itemAngle));
                int y = centerY + (int)(70.0 * Math.sin(itemAngle));
                boolean isActive = part.item.isActive(part.stack);
                boolean isHovered = mouseX >= x - 12 && mouseX <= x + 12 && mouseY >= y - 12 && mouseY <= y + 12;
                g.m_280168_().m_85836_();
                if (isHovered) {
                    MutableComponent statusText = isActive ? Component.m_237115_((String)"cyberware.gui.active") : Component.m_237115_((String)"cyberware.gui.inactive");
                    g.m_280653_(this.f_96547_, (Component)statusText, x, y - 20, -256);
                }
                g.m_280480_(part.stack, x - 8, y - 8);
                int outlineColor = isActive ? -16711936 : -65536;
                g.m_280637_(x - 10, y - 10, 20, 20, outlineColor);
                if (isHovered) {
                    g.m_280153_(this.f_96547_, part.stack, mouseX, mouseY);
                }
                g.m_280168_().m_85849_();
            }
        }
    }

    private void renderColorSettings(GuiGraphics g, int centerX, int centerY, int mouseX, int mouseY) {
        int boxWidth = 80;
        this.hexInput.m_252865_(centerX - boxWidth / 2);
        this.hexInput.m_253211_(centerY + 15);
        this.hexInput.m_94194_(true);
        int swatchSize = 20;
        int gap = 4;
        int totalWidth = swatchSize * PRESET_COLORS.length + gap * (PRESET_COLORS.length - 1);
        int startX = centerX - totalWidth / 2;
        int startY = centerY - 15;
        for (int i = 0; i < PRESET_COLORS.length; ++i) {
            int color = PRESET_COLORS[i];
            int x = startX + (swatchSize + gap) * i;
            int y = startY;
            g.m_280509_(x, y, x + swatchSize, y + swatchSize, color);
            g.m_280637_(x, y, swatchSize, swatchSize, -7829368);
            if (mouseX >= x && mouseX <= x + swatchSize && mouseY >= y && mouseY <= y + swatchSize) {
                g.m_280637_(x - 1, y - 1, swatchSize + 2, swatchSize + 2, -1);
            }
            if (color != ClientCyberwareSettings.hudColor) continue;
            g.m_280637_(x - 2, y - 2, swatchSize + 4, swatchSize + 4, -256);
        }
        g.m_280137_(this.f_96547_, "HUD Color Palette", centerX, startY - 15, -1);
        g.m_280137_(this.f_96547_, "(Hex)", centerX, this.hexInput.m_252907_() + 20 + 2, -5592406);
    }

    private void renderHudPreview(GuiGraphics g, int mouseX, int mouseY) {
        if (this.f_96541_.f_91074_ == null) {
            return;
        }
        this.f_96541_.f_91074_.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(data -> {
            int hudX = ClientCyberwareSettings.hudX;
            int hudY = ClientCyberwareSettings.hudY;
            if (this.isHudMoveMode) {
                g.m_280637_(hudX - 1, hudY - 1, 82, 27, -16711936);
                g.m_280137_(this.f_96547_, "DRAG TO MOVE", hudX + 40, hudY - 10, -16711936);
                if (this.isDraggingHud || mouseX >= hudX && mouseX <= hudX + 80 && mouseY >= hudY && mouseY <= hudY + 25) {
                    g.m_280637_(hudX - 1, hudY - 1, 82, 27, -1);
                }
                int resetBtnX = hudX + 32;
                int resetBtnY = hudY + 25 + 5;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)HUD_RESET_ICON);
                float[] rgba = ClientCyberwareSettings.getColorFloats();
                RenderSystem.setShaderColor((float)rgba[0], (float)rgba[1], (float)rgba[2], (float)rgba[3]);
                g.m_280411_(HUD_RESET_ICON, resetBtnX, resetBtnY, 16, 16, 0.0f, 0.0f, 8, 8, 8, 8);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (mouseX >= resetBtnX && mouseX <= resetBtnX + 16 && mouseY >= resetBtnY && mouseY <= resetBtnY + 16) {
                    g.m_280637_(resetBtnX - 1, resetBtnY - 1, 18, 18, -1);
                    g.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)"Reset Position"), mouseX, mouseY);
                }
            }
        });
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int centerX = this.f_96543_ / 2;
            int centerY = this.f_96544_ / 2;
            if (!this.isHudMoveMode) {
                int colorBtnX = 338;
                int colorBtnY = 84;
                if (mouseX >= (double)colorBtnX && mouseX <= (double)(colorBtnX + 16) && mouseY >= (double)colorBtnY && mouseY <= (double)(colorBtnY + 16)) {
                    this.toggleColorSettings();
                    this.playClickSound();
                    return true;
                }
            }
            if (!this.isColorSettingsOpen && !this.isHudMoveMode && mouseX >= 338.0 && mouseX <= 354.0 && mouseY >= 64.0 && mouseY <= 80.0) {
                this.isHudMoveMode = true;
                this.playClickSound();
                return true;
            }
            if (this.isColorSettingsOpen) {
                if (this.hexInput.m_6375_(mouseX, mouseY, button)) {
                    this.m_7522_((GuiEventListener)this.hexInput);
                    return true;
                }
                this.m_7522_(null);
                this.hexInput.m_93692_(false);
                int swatchSize = 20;
                int gap = 4;
                int totalWidth = swatchSize * PRESET_COLORS.length + gap * (PRESET_COLORS.length - 1);
                int startX = centerX - totalWidth / 2;
                int startY = centerY - 15;
                for (int i = 0; i < PRESET_COLORS.length; ++i) {
                    int x = startX + (swatchSize + gap) * i;
                    int y = startY;
                    if (!(mouseX >= (double)x) || !(mouseX <= (double)(x + swatchSize)) || !(mouseY >= (double)y) || !(mouseY <= (double)(y + swatchSize))) continue;
                    ClientCyberwareSettings.hudColor = PRESET_COLORS[i];
                    this.hexInput.m_94144_(ClientCyberwareSettings.getHudColorAsHex());
                    this.playClickSound();
                    return true;
                }
                return true;
            }
            if (this.isHudMoveMode) {
                int hudX = ClientCyberwareSettings.hudX;
                int hudY = ClientCyberwareSettings.hudY;
                int resetBtnX = hudX + 32;
                int resetBtnY = hudY + 25 + 5;
                if (mouseX >= (double)resetBtnX && mouseX <= (double)(resetBtnX + 16) && mouseY >= (double)resetBtnY && mouseY <= (double)(resetBtnY + 16)) {
                    ClientCyberwareSettings.hudX = 10;
                    ClientCyberwareSettings.hudY = 10;
                    this.playClickSound();
                    return true;
                }
                if (mouseX >= (double)hudX && mouseX <= (double)(hudX + 80) && mouseY >= (double)hudY && mouseY <= (double)(hudY + 25)) {
                    this.isDraggingHud = true;
                    this.dragOffsetX = (int)mouseX - hudX;
                    this.dragOffsetY = (int)mouseY - hudY;
                    this.playClickSound();
                    return true;
                }
                return true;
            }
            if (!this.isColorSettingsOpen && !this.isHudMoveMode) {
                double angleStep = Math.PI * 2 / (double)this.parts.size();
                for (int i = 0; i < this.parts.size(); ++i) {
                    ToggleablePart part = this.parts.get(i);
                    double itemAngle = (double)i * angleStep - 1.5707963267948966;
                    int x = centerX + (int)(70.0 * Math.cos(itemAngle));
                    int y = centerY + (int)(70.0 * Math.sin(itemAngle));
                    if (!(mouseX >= (double)(x - 12)) || !(mouseX <= (double)(x + 12)) || !(mouseY >= (double)(y - 12)) || !(mouseY <= (double)(y + 12))) continue;
                    A_PacketHandler.INSTANCE.sendToServer((Object)new ToggleCyberwarePacket(part.slotId));
                    this.playClickSound();
                    part.item.toggle(part.stack);
                    return true;
                }
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void toggleColorSettings() {
        this.isColorSettingsOpen = !this.isColorSettingsOpen;
        this.hexInput.m_94194_(this.isColorSettingsOpen);
        if (!this.isColorSettingsOpen) {
            this.hexInput.m_93692_(false);
            this.m_7522_(null);
        }
    }

    private void playClickSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isHudMoveMode && this.isDraggingHud && button == 0) {
            ClientCyberwareSettings.hudX = (int)mouseX - this.dragOffsetX;
            ClientCyberwareSettings.hudY = (int)mouseY - this.dragOffsetY;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isDraggingHud) {
            this.isDraggingHud = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7043_() {
        return false;
    }

    private record ToggleablePart(int slotId, ItemStack stack, ICyberware item) {
    }
}

