/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.compat;

import com.maxwell.cyber_ware_port.common.block.cwb.recipe.EngineeringRecipe;
import com.maxwell.cyber_ware_port.common.item.BlueprintItem;
import com.maxwell.cyber_ware_port.compat.CyberwareJeiPlugin;
import com.maxwell.cyber_ware_port.init.ModBlocks;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class EngineeringRecipeCategory
implements IRecipeCategory<EngineeringRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public EngineeringRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(new ResourceLocation("cyber_ware_port", "textures/gui/engineering.png"), 0, 0, 176, 80);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.CYBERWARE_WORKBENCH.get()));
    }

    public RecipeType<EngineeringRecipe> getRecipeType() {
        return CyberwareJeiPlugin.ENGINEERING_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.cyber_ware_port.deconstruct");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EngineeringRecipe recipe, IFocusGroup focuses) {
        ItemStack blueprint;
        Ingredient inputIng;
        ItemStack[] inputItems;
        float bpChance;
        if (!recipe.m_7527_().isEmpty()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 15, 20).addIngredients((Ingredient)recipe.m_7527_().get(0));
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 15, 53).addItemStack(new ItemStack((ItemLike)Items.f_42516_))).addTooltipCallback((view, tooltip) -> tooltip.add(Component.m_237115_((String)"gui.cyber_ware_port.need_paper").m_130940_(ChatFormatting.GRAY)));
        int outputX = 71;
        int outputY = 17;
        List<EngineeringRecipe.OutputEntry> outputs = recipe.getOutputs();
        if (outputs != null) {
            int slotIdx = 0;
            for (EngineeringRecipe.OutputEntry entry : outputs) {
                if (slotIdx >= 6) break;
                int x = outputX + slotIdx % 2 * 18;
                int y = outputY + slotIdx / 2 * 18;
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, x, y).addItemStack(entry.stack())).addTooltipCallback((view, tooltip) -> {
                    float chance = entry.chance() * 100.0f;
                    tooltip.add(Component.m_237113_((String)String.format("%.0f%% Chance", Float.valueOf(chance))).m_130940_(ChatFormatting.YELLOW));
                });
                ++slotIdx;
            }
        }
        if ((bpChance = recipe.getBlueprintChance()) > 0.0f && !recipe.m_7527_().isEmpty() && (inputItems = (inputIng = (Ingredient)recipe.m_7527_().get(0)).m_43908_()).length > 0 && !(blueprint = BlueprintItem.createBlueprintFor(inputItems[0].m_41720_())).m_41619_()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 115, 53).addItemStack(blueprint)).addTooltipCallback((view, tooltip) -> tooltip.add(Component.m_237110_((String)"gui.cyber_ware_port.blueprint_chance", (Object[])new Object[]{String.format("%.0f", Float.valueOf(bpChance * 100.0f))}).m_130940_(ChatFormatting.BLUE)));
        }
    }
}

