/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.common.entity.Bird;
import com.starfish_studios.naturalist.core.registry.NaturalistEntityTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class BirdModel
extends GeoModel<Bird> {
    public ResourceLocation getTextureResource(Bird bird) {
        if (bird.m_6095_().equals(NaturalistEntityTypes.BLUEJAY.get())) {
            return new ResourceLocation("naturalist", "textures/entity/bird/bluejay.png");
        }
        if (bird.m_6095_().equals(NaturalistEntityTypes.CANARY.get())) {
            return new ResourceLocation("naturalist", "textures/entity/bird/canary.png");
        }
        if (bird.m_6095_().equals(NaturalistEntityTypes.CARDINAL.get())) {
            return new ResourceLocation("naturalist", "textures/entity/bird/cardinal.png");
        }
        if (bird.m_6095_().equals(NaturalistEntityTypes.FINCH.get())) {
            return new ResourceLocation("naturalist", "textures/entity/bird/finch.png");
        }
        if (bird.m_6095_().equals(NaturalistEntityTypes.SPARROW.get())) {
            return new ResourceLocation("naturalist", "textures/entity/bird/sparrow.png");
        }
        return new ResourceLocation("naturalist", "textures/entity/bird/robin.png");
    }

    public ResourceLocation getModelResource(Bird bird) {
        return new ResourceLocation("naturalist", "geo/entity/bird.geo.json");
    }

    public ResourceLocation getAnimationResource(Bird bird) {
        return new ResourceLocation("naturalist", "animations/bird.rp_anim.json");
    }

    public void setCustomAnimations(Bird entity, long instanceId, @Nullable AnimationState<Bird> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        if (animationState == null) {
            return;
        }
        EntityModelData extraDataOfType = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        head.setRotX(extraDataOfType.headPitch() * ((float)Math.PI / 180));
        head.setRotY(extraDataOfType.netHeadYaw() * ((float)Math.PI / 180));
    }
}

