/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.base;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.electricity.base.ConnectNeightborsPacket;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockValues;
import com.drmangotea.tfmg.content.electricity.base.ElectricalNetwork;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnection;
import com.drmangotea.tfmg.content.electricity.connection.cables.CableConnectorBlockEntity;
import com.drmangotea.tfmg.registry.TFMGPackets;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.theme.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.PacketDistributor;

public interface IElectric {
    public long getPos();

    public LevelAccessor getLevelAccessor();

    public boolean destroyed();

    public ElectricalNetwork getOrCreateElectricNetwork();

    default public boolean hasElectricitySlot(Direction direction) {
        return true;
    }

    default public void onPlaced() {
        if (!this.getLevelAccessor().m_5776_()) {
            TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new ConnectNeightborsPacket(BlockPos.m_122022_((long)this.getPos())));
        }
        ElectricalNetwork network = TFMG.NETWORK_MANAGER.getOrCreateNetworkFor(this);
        this.setNetwork(this.getPos());
        this.getData().electricalNetworkId = this.getPos();
        network.add(this);
        BlockPos pos = BlockPos.m_122022_((long)this.getPos());
        this.getData().checkForLoopsNextTick = true;
        if (this.getOrCreateElectricNetwork() != null) {
            this.getOrCreateElectricNetwork().checkForLoops(BlockPos.m_122022_((long)this.getPos()));
        }
        this.updateNextTick();
        this.onConnected();
        this.sendStuff();
    }

    default public int getMaxVoltage() {
        return 0;
    }

    default public int getMaxCurrent() {
        return 0;
    }

    default public void onConnected() {
        BlockPos pos = BlockPos.m_122022_((long)this.getPos());
        for (Direction d : Direction.values()) {
            BlockEntity blockEntity;
            if (!this.hasElectricitySlot(d) || !((blockEntity = this.getLevelAccessor().m_7702_(pos.m_121945_(d))) instanceof IElectric)) continue;
            IElectric be = (IElectric)blockEntity;
            if (be.hasElectricitySlot(d.m_122424_())) {
                if (be.destroyed()) continue;
                if (this.getOrCreateElectricNetwork() != null) {
                    this.getOrCreateElectricNetwork().add(be);
                }
                if (be.getData().getId() == this.getData().getId()) continue;
                be.setNetwork(this.getData().getId());
                be.onConnected();
                if (this.getLevelAccessor().m_5776_()) continue;
                this.sendStuff();
                continue;
            }
            if (be.getData().getId() == this.getData().getId()) continue;
            be.updateNextTick();
        }
        this.sendStuff();
    }

    default public void lazyTickElectricity() {
        if (this.getData().failTimer >= 4) {
            this.blockFail();
            this.getData().failTimer = 0;
            this.sendStuff();
        } else if (this.getData().voltage > this.getMaxVoltage() && this.getMaxVoltage() > 0 || this.getCurrent() > (float)this.getMaxCurrent() && this.getMaxCurrent() > 0) {
            ++this.getData().failTimer;
        }
    }

    default public void tickElectricity() {
        if (this.getData().checkForLoopsNextTick) {
            this.getOrCreateElectricNetwork().checkForLoops(this.m_58899_());
            this.getData().checkForLoopsNextTick = false;
        }
        if (this.getData().connectNextTick) {
            this.onPlaced();
            this.getData().connectNextTick = false;
        }
        if (this.getData().updateNextTick) {
            this.updateNetwork();
            this.getData().updateNextTick = false;
        }
        if (this.getData().updatePowerNextTick) {
            this.updateUnpowered(new ArrayList<BlockPos>());
            this.getData().updatePowerNextTick = false;
        }
        if (this.getData().setVoltageNextTick) {
            this.setVoltage(this.getData().voltageSupply);
            this.getData().setVoltageNextTick = false;
        }
    }

    default public BlockPos m_58899_() {
        return BlockPos.m_122022_((long)this.getPos());
    }

    default public void updateUnpowered(List<BlockPos> alreadyChecked) {
        alreadyChecked.add(BlockPos.m_122022_((long)this.getPos()));
        this.updateNextTick();
        IElectric iElectric = this;
        if (iElectric instanceof CableConnectorBlockEntity) {
            CableConnectorBlockEntity connectorBE = (CableConnectorBlockEntity)iElectric;
            for (CableConnection connection : connectorBE.connections) {
                CableConnectorBlockEntity be2;
                BlockEntity blockEntity = this.getLevelAccessor().m_7702_(connection.blockPos1);
                if (!(blockEntity instanceof CableConnectorBlockEntity) || alreadyChecked.contains(BlockPos.m_122022_((long)(be2 = (CableConnectorBlockEntity)blockEntity).getPos()))) continue;
                be2.updateUnpowered(alreadyChecked);
            }
        }
        for (Direction direction : Direction.values()) {
            IElectric be;
            BlockEntity blockEntity = this.getLevelAccessor().m_7702_(BlockPos.m_122022_((long)this.getPos()).m_121945_(direction));
            if (!(blockEntity instanceof IElectric) || alreadyChecked.contains(BlockPos.m_122022_((long)(be = (IElectric)blockEntity).getPos()))) continue;
            be.updateUnpowered(alreadyChecked);
        }
    }

    default public boolean makeMultimeterTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"multimeter.header", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        if (this.getData().notEnoughtPower) {
            CreateLang.translate((String)"multimeter.not_enough_power", (Object[])new Object[0]).color(Color.RED).forGoggles(tooltip, 1);
        }
        if (this.voltageGeneration() > 0) {
            CreateLang.translate((String)"multimeter.power_generated", (Object[])new Object[0]).add(Component.m_237113_((String)TFMGUtils.formatUnits(this.powerGeneration(), "W"))).color(8728138).forGoggles(tooltip, 1);
            CreateLang.translate((String)"multimeter.voltage_generated", (Object[])new Object[0]).add(Component.m_237113_((String)TFMGUtils.formatUnits(this.voltageGeneration(), "V"))).color(1210265).forGoggles(tooltip, 1);
            CreateLang.text((String)"----------------------------").style(ChatFormatting.WHITE).forGoggles(tooltip);
        }
        CreateLang.text((String)("   R = " + TFMGUtils.formatUnits(this.voltageGeneration() > 0 ? (double)this.getGeneratorResistance() : (double)this.resistance(), "\u03a9"))).color(13207913).forGoggles(tooltip, 1);
        CreateLang.text((String)("   U = " + TFMGUtils.formatUnits(this.getData().getVoltage(), "V"))).color(0x4BBBCC).forGoggles(tooltip, 1);
        CreateLang.text((String)("   I = " + TFMGUtils.formatUnits(this.getCurrent(), "A"))).color(2269510).forGoggles(tooltip, 1);
        CreateLang.text((String)("   P = " + TFMGUtils.formatUnits(this.getPowerUsage(), "W"))).color(13388660).forGoggles(tooltip, 1);
        if (this.getData().group.id != -1) {
            CreateLang.text((String)"----------------------------").style(ChatFormatting.WHITE).forGoggles(tooltip);
            CreateLang.translate((String)"multimeter.group", (Object[])new Object[0]).add(CreateLang.number((double)this.getData().group.id)).color(14211879).forGoggles(tooltip, 1);
        }
        if (isPlayerSneaking) {
            CreateLang.text((String)"----------------------------").style(ChatFormatting.WHITE).forGoggles(tooltip);
            CreateLang.translate((String)"multimeter.network_power_generation", (Object[])new Object[0]).add(Component.m_237113_((String)TFMGUtils.formatUnits(this.getNetworkPowerGeneration(), "W"))).color(13388660).forGoggles(tooltip, 1);
            CreateLang.translate((String)"multimeter.network_power_consumption", (Object[])new Object[0]).add(Component.m_237113_((String)TFMGUtils.formatUnits(this.getNetworkPowerUsage(), "W"))).color(13388660).forGoggles(tooltip, 1);
        }
        return true;
    }

    default public void updateNearbyNetworks(IElectric member) {
    }

    public ElectricBlockValues getData();

    default public boolean canWork() {
        return !this.getData().notEnoughtPower;
    }

    default public void blockFail() {
        this.getLevelAccessor().m_46961_(BlockPos.m_122022_((long)this.getPos()), false);
    }

    default public int getPowerUsage() {
        return (int)((float)this.getData().getVoltage() * this.getCurrent());
    }

    default public int getNetworkPowerUsage(IElectric blocked) {
        int power = 0;
        for (IElectric member : this.getOrCreateElectricNetwork().members) {
            if (member.getPos() != blocked.getPos()) {
                power += member.getPowerUsage();
                continue;
            }
            blocked.updateNextTick();
        }
        return power;
    }

    default public int getNetworkPowerUsage() {
        int power = 0;
        for (IElectric member : this.getOrCreateElectricNetwork().members) {
            power += member.getPowerUsage();
        }
        return power;
    }

    default public int getNetworkPowerGeneration() {
        int power = 0;
        for (IElectric member : this.getOrCreateElectricNetwork().members) {
            power += member.powerGeneration();
        }
        return power;
    }

    default public void onNetworkChanged(int oldVoltage, int oldPower) {
    }

    default public float getGeneratorResistance() {
        if (this.getData().voltageSupply == 0) {
            return 0.0f;
        }
        if ((float)this.getData().networkPowerGeneration * (float)this.getNetworkResistance() == 0.0f) {
            return 0.0f;
        }
        return (float)this.powerGeneration() / (float)this.getData().networkPowerGeneration * (float)this.getNetworkResistance();
    }

    default public float getGeneratorLoad() {
        if (this.getNetworkPowerUsage() == 0) {
            return 0.0f;
        }
        return (float)this.powerGeneration() / (float)this.getData().networkPowerGeneration * (float)this.getNetworkPowerUsage();
    }

    public float resistance();

    public int voltageGeneration();

    public int powerGeneration();

    public int frequencyGeneration();

    public int getNetworkResistance();

    default public int getMaxAmps() {
        return (int)this.getCurrent();
    }

    default public float getCurrent() {
        return this.getData().getVoltage() == 0 || this.resistance() == 0.0f ? 0.0f : (float)this.getData().getVoltage() / this.resistance();
    }

    default public float getCableCurrent() {
        float current = 0.0f;
        ArrayList<Integer> groups = new ArrayList<Integer>();
        for (IElectric member : this.getOrCreateElectricNetwork().members) {
            if (!member.canBeInGroups() || groups.contains(member.getData().group.id)) continue;
            current += member.getCurrent();
            groups.add(member.getData().group.id);
        }
        return current;
    }

    public void updateNextTick();

    public void updateNetwork();

    public void sendStuff();

    public void setVoltage(int var1);

    public void setFrequency(int var1);

    public void setNetworkResistance(int var1);

    public void setNetwork(long var1);

    default public boolean canBeInGroups() {
        return false;
    }
}

