/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.metallurgy.blast_stove;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.recipes.HotBlastRecipe;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class BlastStoveBlockEntity
extends FluidTankBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer.Fluid {
    private static final int MAX_SIZE = 2;
    protected LazyOptional<IFluidHandler> primaryCapability;
    protected LazyOptional<IFluidHandler> secondaryCapability;
    public FluidTank primaryOutputInventory;
    public FluidTank secondaryOutputInventory;
    public FluidTank primaryInputInventory;
    public FluidTank secondaryInputInventory;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    public boolean updateConnectivity;
    public int width;
    public int height;
    private static final Object HotBlastRecipesKey = new Object();
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    public int timer = 0;

    public BlastStoveBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        this.primaryOutputInventory = TFMGUtils.createTank(8000, true, false, this::onFluidStackChanged);
        this.secondaryOutputInventory = TFMGUtils.createTank(8000, true, false, this::onFluidStackChanged);
        this.primaryInputInventory = TFMGUtils.createTank(8000, false, this::onFluidStackChanged);
        this.secondaryInputInventory = TFMGUtils.createTank(8000, false, this::onFluidStackChanged);
        this.primaryCapability = LazyOptional.of(() -> new CombinedTankWrapper(new IFluidHandler[]{this.primaryOutputInventory, this.secondaryInputInventory}));
        this.secondaryCapability = LazyOptional.of(() -> new CombinedTankWrapper(new IFluidHandler[]{this.primaryInputInventory, this.secondaryOutputInventory}));
        this.updateConnectivity = false;
        this.height = 1;
        this.width = 1;
        this.refreshCapability();
    }

    public void updateBoilerState() {
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (!this.isController()) {
            return;
        }
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7918_(xOffset, yOffset, zOffset));
                    if (!(blockEntity instanceof BlastStoveBlockEntity)) continue;
                    BlastStoveBlockEntity fbe = (BlastStoveBlockEntity)blockEntity;
                    fbe.refreshCapability();
                }
            }
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.refreshCapability();
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    public void tick() {
        HotBlastRecipe recipe;
        super.tick();
        if (this.isController() && !this.primaryInputInventory.isEmpty() && !this.secondaryInputInventory.isEmpty() && this.primaryOutputInventory.getSpace() != 0 && this.secondaryOutputInventory.getSpace() != 0 && (recipe = this.getMatchingRecipes()) != null) {
            if ((float)this.timer >= (float)this.getSpeedModifier() / ((float)this.getTotalTankSize() * 0.3f)) {
                if ((this.primaryOutputInventory.isEmpty() || this.primaryOutputInventory.getFluid().isFluidEqual(recipe.getPrimaryResult())) && (this.secondaryOutputInventory.isEmpty() || this.secondaryOutputInventory.getFluid().isFluidEqual(recipe.getSecondaryResult()))) {
                    this.primaryInputInventory.setFluid(new FluidStack(this.primaryInputInventory.getFluid().copy(), this.primaryInputInventory.getFluidAmount() - recipe.getPrimaryIngredient().getRequiredAmount()));
                    this.secondaryInputInventory.setFluid(new FluidStack(this.secondaryInputInventory.getFluid().copy(), this.secondaryInputInventory.getFluidAmount() - recipe.getSecondaryIngredient().getRequiredAmount()));
                    this.primaryOutputInventory.setFluid(new FluidStack(recipe.getPrimaryResult(), this.primaryOutputInventory.getFluidAmount() + recipe.getPrimaryResult().getAmount()));
                    this.secondaryOutputInventory.setFluid(new FluidStack(recipe.getSecondaryResult(), this.secondaryOutputInventory.getFluidAmount() + recipe.getSecondaryResult().getAmount()));
                }
            } else {
                ++this.timer;
            }
        }
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    public int getSpeedModifier() {
        return 100;
    }

    protected Object getRecipeCacheKey() {
        return HotBlastRecipesKey;
    }

    protected HotBlastRecipe getMatchingRecipes() {
        List list = RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.f_58857_, r -> r instanceof HotBlastRecipe);
        for (int i = 0; i < list.toArray().length; ++i) {
            HotBlastRecipe recipe = (HotBlastRecipe)((Object)list.get(i));
            if (!recipe.getPrimaryIngredient().test(this.primaryInputInventory.getFluid()) || !recipe.getSecondaryIngredient().test(this.secondaryInputInventory.getFluid())) continue;
            return recipe;
        }
        return null;
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
    }

    public BlastStoveBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(this.controller);
        if (tileEntity instanceof BlastStoveBlockEntity) {
            return (BlastStoveBlockEntity)tileEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
    }

    public void removeController(boolean keepFluids) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onFluidStackChanged(this.primaryOutputInventory.getFluid());
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    public void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.primaryCapability;
        LazyOptional<IFluidHandler> oldSecondaryCap = this.secondaryCapability;
        this.primaryCapability = LazyOptional.of(() -> this.handlerForCapability());
        this.secondaryCapability = LazyOptional.of(() -> this.handlerForSecondaryCapability());
        oldCap.invalidate();
        oldSecondaryCap.invalidate();
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? new CombinedTankWrapper(new IFluidHandler[]{this.primaryOutputInventory, this.secondaryInputInventory}) : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new CombinedTankWrapper(new IFluidHandler[]{this.primaryOutputInventory, this.secondaryInputInventory}));
    }

    private IFluidHandler handlerForSecondaryCapability() {
        return this.isController() ? new CombinedTankWrapper(new IFluidHandler[]{this.primaryInputInventory, this.secondaryOutputInventory}) : (this.getControllerBE() != null ? this.getControllerBE().handlerForSecondaryCapability() : new CombinedTankWrapper(new IFluidHandler[]{this.primaryInputInventory, this.secondaryOutputInventory}));
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().m_82363_((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.width = compound.m_128451_("Size");
            this.height = compound.m_128451_("Height");
            this.primaryOutputInventory.readFromNBT(compound.m_128469_("primaryOutputInventory"));
            this.primaryInputInventory.readFromNBT(compound.m_128469_("primaryInputInventory"));
            this.secondaryOutputInventory.readFromNBT(compound.m_128469_("secondaryOutputInventory"));
            this.secondaryInputInventory.readFromNBT(compound.m_128469_("secondaryInputInventory"));
            if (this.primaryOutputInventory.getSpace() < 0) {
                this.primaryOutputInventory.drain(-this.primaryOutputInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (!clientPacket) {
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.m_58898_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            }
            this.invalidateRenderBoundingBox();
        }
    }

    public float getFillState() {
        return (float)this.primaryOutputInventory.getFluidAmount() / (float)this.primaryOutputInventory.getCapacity();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        CreateLang.translate((String)"goggles.blast_stove.header", (Object[])new Object[0]).forGoggles(tooltip);
        CreateLang.builder().add(CreateLang.translate((String)"goggles.blast_stove.tank1", (Object[])new Object[0])).add(CreateLang.number((double)((IFluidHandler)this.getControllerBE().secondaryCapability.orElseGet(null)).getFluidInTank(0).getAmount()).add(mb).add(((IFluidHandler)this.getControllerBE().secondaryCapability.orElseGet(null)).getFluidInTank(0).getFluid() == Fluids.f_76191_ ? CreateLang.text((String)"") : CreateLang.text((String)(" " + ((IFluidHandler)this.getControllerBE().secondaryCapability.orElseGet(null)).getFluidInTank(0).getDisplayName().getString()))).style(ChatFormatting.DARK_GREEN)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)8000.0).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        CreateLang.builder().add(CreateLang.translate((String)"goggles.blast_stove.tank2", (Object[])new Object[0])).add(CreateLang.number((double)((IFluidHandler)this.getControllerBE().primaryCapability.orElseGet(null)).getFluidInTank(1).getAmount()).add(mb).add(((IFluidHandler)this.getControllerBE().primaryCapability.orElseGet(null)).getFluidInTank(1).getFluid() == Fluids.f_76191_ ? CreateLang.text((String)"") : CreateLang.text((String)(" " + ((IFluidHandler)this.getControllerBE().primaryCapability.orElseGet(null)).getFluidInTank(1).getDisplayName().getString()))).style(ChatFormatting.DARK_GREEN)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)8000.0).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        CreateLang.builder().add(CreateLang.translate((String)"goggles.blast_stove.tank3", (Object[])new Object[0])).add(CreateLang.number((double)((IFluidHandler)this.getControllerBE().primaryCapability.orElseGet(null)).getFluidInTank(0).getAmount()).add(mb).add(((IFluidHandler)this.getControllerBE().primaryCapability.orElseGet(null)).getFluidInTank(0).getFluid() == Fluids.f_76191_ ? CreateLang.text((String)"") : CreateLang.text((String)(" " + ((IFluidHandler)this.getControllerBE().primaryCapability.orElseGet(null)).getFluidInTank(0).getDisplayName().getString()))).style(ChatFormatting.YELLOW)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)8000.0).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        CreateLang.builder().add(CreateLang.translate((String)"goggles.blast_stove.tank4", (Object[])new Object[0])).add(CreateLang.number((double)((IFluidHandler)this.getControllerBE().secondaryCapability.orElseGet(null)).getFluidInTank(1).getAmount()).add(mb).add(((IFluidHandler)this.getControllerBE().secondaryCapability.orElseGet(null)).getFluidInTank(1).getFluid() == Fluids.f_76191_ ? CreateLang.text((String)"") : CreateLang.text((String)(" " + ((IFluidHandler)this.getControllerBE().secondaryCapability.orElseGet(null)).getFluidInTank(1).getDisplayName().getString()))).style(ChatFormatting.YELLOW)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)8000.0).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128365_("primaryOutputInventory", (Tag)this.primaryOutputInventory.writeToNBT(new CompoundTag()));
            compound.m_128365_("primaryInputInventory", (Tag)this.primaryInputInventory.writeToNBT(new CompoundTag()));
            compound.m_128365_("secondaryOutputInventory", (Tag)this.secondaryOutputInventory.writeToNBT(new CompoundTag()));
            compound.m_128365_("secondaryInputInventory", (Tag)this.secondaryInputInventory.writeToNBT(new CompoundTag()));
            compound.m_128405_("Size", this.width);
            compound.m_128405_("Height", this.height);
        }
        this.forEachBehaviour(tb -> tb.write(compound, clientPacket));
        if (!clientPacket) {
            return;
        }
        if (this.queuedSync) {
            compound.m_128379_("LazySync", true);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.primaryCapability.isPresent()) {
            this.refreshCapability();
        }
        if (!this.secondaryCapability.isPresent()) {
            this.refreshCapability();
        }
        if (side == null) {
            return LazyOptional.empty();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (side.m_122434_() == Direction.Axis.Y) {
                return this.primaryCapability.cast();
            }
            if (this.getController().m_123342_() == this.m_58899_().m_123342_()) {
                return this.secondaryCapability.cast();
            }
        } else {
            return super.getCapability(cap, side);
        }
        return LazyOptional.empty();
    }

    public FluidTank getTankInventory() {
        return this.primaryOutputInventory;
    }

    public int getTotalTankSize() {
        return this.width * this.width * this.height;
    }

    public static int getMaxSize() {
        return 2;
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get() * 1000;
    }

    public static int getMaxHeight() {
        return (Integer)AllConfigs.server().fluids.fluidTankMaxHeight.get();
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        this.onFluidStackChanged(this.primaryOutputInventory.getFluid());
        this.updateBoilerState();
        this.m_6596_();
        this.updateConnectivity = true;
        this.sendData();
        this.m_6596_();
    }

    public void setExtraData(@Nullable Object data) {
        if (data instanceof Boolean) {
            this.window = (Boolean)data;
        }
    }

    @Nullable
    public Object getExtraData() {
        return this.window;
    }

    public Object modifyExtraData(Object data) {
        if (data instanceof Boolean) {
            Boolean windows = (Boolean)data;
            windows = windows | this.window;
            return windows;
        }
        return data;
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return BlastStoveBlockEntity.getMaxHeight();
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 2;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean hasTank() {
        return true;
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }
}

