/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.winding_machine;

import com.drmangotea.tfmg.content.machinery.misc.winding_machine.SpoolItem;
import com.drmangotea.tfmg.content.machinery.misc.winding_machine.WindingMachineBlock;
import com.drmangotea.tfmg.recipes.WindingRecipe;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindingMachineBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    LerpedFloat spoolSpeed = LerpedFloat.linear();
    float angle;
    public SmartInventory inventory;
    public LazyOptional<IItemHandlerModifiable> itemCapability;
    public ItemStack spool = ItemStack.f_41583_;
    public WindingRecipe recipe;
    public int amountWinded = 0;
    public boolean update = false;
    protected ScrollValueBehaviour turnPercentage;

    public WindingMachineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(10);
        this.inventory = new SmartInventory(1, (SyncedBlockEntity)this).withMaxStackSize(1).whenContentsChanged(i -> this.onContentsChanged());
        this.itemCapability = LazyOptional.of(() -> this.inventory);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 100;
        this.turnPercentage = new ScrollValueBehaviour((Component)CreateLang.translateDirect((String)"winding_machine.turn_percentage", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new WindingMachineValueBox());
        this.turnPercentage.between(1, max);
        this.turnPercentage.value = 20;
        behaviours.add((BlockEntityBehaviour)this.turnPercentage);
    }

    public void onContentsChanged() {
        this.findRecipe();
        if (this.inventory.m_7983_()) {
            this.amountWinded = 0;
        }
    }

    public void findRecipe() {
        Optional optional = TFMGRecipeTypes.WINDING.find(new RecipeWrapper((IItemHandlerModifiable)this.inventory), this.f_58857_);
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (Container)this.inventory, TFMGRecipeTypes.WINDING.getType(), WindingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            this.recipe = (WindingRecipe)((Object)assemblyRecipe.get());
            return;
        }
        if (optional.isEmpty()) {
            this.recipe = null;
            return;
        }
        WindingRecipe windingRecipe = (WindingRecipe)((Object)optional.get());
        if (windingRecipe.getIngredient().test(this.inventory.m_8020_(0))) {
            this.recipe = windingRecipe;
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.onContentsChanged();
        if (this.spool.m_150930_((Item)TFMGItems.EMPTY_SPOOL.get()) && !((Boolean)this.m_58900_().m_61143_((Property)WindingMachineBlock.POWERED)).booleanValue()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)WindingMachineBlock.POWERED, (Comparable)Boolean.valueOf(true)), 2);
            this.update = true;
        }
        if (!this.spool.m_150930_((Item)TFMGItems.EMPTY_SPOOL.get()) && ((Boolean)this.m_58900_().m_61143_((Property)WindingMachineBlock.POWERED)).booleanValue()) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)WindingMachineBlock.POWERED, (Comparable)Boolean.valueOf(false)), 2);
            this.update = true;
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"goggles.winding_machine.header", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        if (!this.spool.m_41619_()) {
            CreateLang.text((String)this.spool.m_41611_().getString().replace("[", "").replace("]", "")).color(this.spool.m_150949_()).forGoggles(tooltip);
            CreateLang.translate((String)"goggles.winding_machine.turns", (Object[])new Object[0]).add(CreateLang.number((double)this.spool.m_41784_().m_128451_("Amount"))).color(this.spool.m_150949_()).forGoggles(tooltip);
            if (this.recipe != null) {
                CreateLang.text((String)"").add(CreateLang.translate((String)"goggles.winding_machine.progress", (Object[])new Object[0])).add(CreateLang.number((double)this.amountWinded)).add(Component.m_237113_((String)("/" + this.recipe.getProcessingDuration()))).color(this.spool.m_150949_()).forGoggles(tooltip);
            }
        }
        return true;
    }

    public void tick() {
        super.tick();
        this.performRecipe();
        if (this.update) {
            this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
            this.update = false;
        }
        if (this.f_58857_.f_46443_) {
            this.manageRotation();
        }
    }

    public void performRecipe() {
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inventory.m_8020_(0).m_150930_((Item)TFMGItems.ELECTROMAGNETIC_COIL.get()) && this.spool.m_150930_((Item)TFMGItems.COPPER_SPOOL.get()) && this.spool.m_41784_().m_128451_("Amount") > 0 && this.inventory.m_8020_(0).m_41784_().m_128451_("Turns") < this.turnPercentage.getValue() * 10 && this.inventory.m_8020_(0).m_41784_().m_128451_("Turns") < this.turnPercentage.getValue() * 10) {
            this.spool.m_41784_().m_128405_("Amount", this.spool.m_41784_().m_128451_("Amount") - 1);
            this.inventory.m_8020_(0).m_41784_().m_128405_("Turns", this.inventory.m_8020_(0).m_41784_().m_128451_("Turns") + 1);
            return;
        }
        if (this.inventory.m_8020_(0).m_150930_(TFMGBlocks.RESISTOR.m_5456_()) && this.spool.m_150930_((Item)TFMGItems.CONSTANTAN_SPOOL.get()) && this.spool.m_41784_().m_128451_("Amount") > 0 && this.inventory.m_8020_(0).m_41784_().m_128451_("Resistance") < this.turnPercentage.getValue() * 10 && this.inventory.m_8020_(0).m_41784_().m_128451_("Resistance") < this.turnPercentage.getValue() * 10) {
            this.spool.m_41784_().m_128405_("Amount", this.spool.m_41784_().m_128451_("Amount") - 1);
            this.inventory.m_8020_(0).m_41784_().m_128405_("Resistance", this.inventory.m_8020_(0).m_41784_().m_128451_("Resistance") + 1);
            return;
        }
        if (this.spool.m_41784_().m_128451_("Amount") == 0 && !this.spool.m_150930_((Item)TFMGItems.EMPTY_SPOOL.get()) && this.spool.m_41720_() instanceof SpoolItem) {
            this.spool = TFMGItems.EMPTY_SPOOL.asStack();
        }
        if (this.recipe == null) {
            return;
        }
        if (this.amountWinded >= this.recipe.getProcessingDuration()) {
            this.inventory.setStackInSlot(0, (ItemStack)this.recipe.rollResults().get(0));
            this.recipe = null;
            this.amountWinded = 0;
            this.sendData();
            this.m_6596_();
        } else {
            if (this.spool.m_41619_() || this.spool.m_150930_((Item)TFMGItems.EMPTY_SPOOL.get())) {
                return;
            }
            if (this.spool.m_41784_().m_128451_("Amount") > 0) {
                if (this.recipe.getSpool().test(this.spool)) {
                    this.spool.m_41784_().m_128405_("Amount", this.spool.m_41784_().m_128451_("Amount") - 1);
                    ++this.amountWinded;
                }
            } else {
                this.inventory.setStackInSlot(0, (ItemStack)this.recipe.rollResults().get(0));
                this.sendData();
                this.m_6596_();
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void manageRotation() {
        float targetSpeed = (float)Math.min(Math.abs((double)this.getSpeed() * 1.5), 30.0);
        this.spoolSpeed.updateChaseTarget(targetSpeed);
        this.spoolSpeed.tickChaser();
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128365_("Spool", (Tag)this.spool.serializeNBT());
        compound.m_128405_("AmountWinded", this.amountWinded);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.spool = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Spool"));
        this.amountWinded = compound.m_128451_("AmountWinded");
        if (clientPacket) {
            this.spoolSpeed.chase((double)this.getGeneratedSpeed(), 0.0625, LerpedFloat.Chaser.EXP);
        }
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inventory);
        Containers.m_18992_((Level)this.m_58904_(), (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)this.spool);
    }

    public static class WindingMachineValueBox
    extends ValueBoxTransform.Sided {
        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)4.0, (double)16.05);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction == state.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        }
    }
}

