/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.vat.base;

import com.drmangotea.tfmg.content.machinery.vat.base.IVatMachine;
import com.drmangotea.tfmg.content.machinery.vat.base.VatBlock;
import com.drmangotea.tfmg.content.machinery.vat.base.VatEvaluationPacket;
import com.drmangotea.tfmg.content.machinery.vat.base.VatInventory;
import com.drmangotea.tfmg.mixin.accessor.TankSegmentAccessor;
import com.drmangotea.tfmg.recipes.VatMachineRecipe;
import com.drmangotea.tfmg.registry.TFMGPackets;
import com.simibubi.create.api.boiler.BoilerHeater;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.network.PacketDistributor;

public class VatBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer.Fluid {
    private static final int MAX_SIZE = 3;
    public VatInventory inputInventory;
    public VatInventory outputInventory;
    public SmartFluidTankBehaviour inputTank;
    public SmartFluidTankBehaviour outputTank;
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected LazyOptional<IItemHandlerModifiable> itemCapability;
    protected boolean forceFluidLevelUpdate;
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity;
    protected boolean updateCapability;
    protected boolean window = false;
    protected int luminosity;
    protected int width;
    protected int height;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    public LerpedFloat[] fluidLevel = new LerpedFloat[8];
    public Map<BlockPos, String> machineMap = new HashMap<BlockPos, String>();
    public Map<BlockPos, Boolean> operationalMachinesMap = new HashMap<BlockPos, Boolean>();
    public boolean areMachinesValid = true;
    boolean evaluateNextTick = true;
    float efficiency = 1.0f;
    int timer = 0;
    public VatMachineRecipe recipe;
    int heatLevel = 0;
    HeatCondition heatCondition = HeatCondition.NONE;
    private static final Object vatRecipeKey = new Object();

    public VatBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        for (int i = 0; i < 8; ++i) {
            this.fluidLevel[i] = LerpedFloat.linear();
        }
        this.window = false;
        this.inputInventory = new VatInventory(4, this);
        this.outputInventory = new VatInventory(4, this);
        this.itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventory}));
        this.forceFluidLevelUpdate = true;
        this.updateConnectivity = false;
        this.updateCapability = false;
        this.height = 1;
        this.width = 1;
        this.refreshCapability();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 4, 4000, true).whenFluidUpdates(this::onInventoryChanged);
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 4, 4000, true).whenFluidUpdates(this::onInventoryChanged).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        behaviours.add((BlockEntityBehaviour)this.outputTank);
        this.fluidCapability = LazyOptional.of(() -> {
            LazyOptional inputCap = this.inputTank.getCapability();
            LazyOptional outputCap = this.outputTank.getCapability();
            return new CombinedTankWrapper(new IFluidHandler[]{(IFluidHandler)outputCap.orElse(null), (IFluidHandler)inputCap.orElse(null)});
        });
    }

    protected Object getRecipeCacheKey() {
        return vatRecipeKey;
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.recipe == null && this.isController()) {
            this.recipe = this.getMatchingRecipe();
        }
        this.updateTemperature();
        if (this.f_58857_.f_46443_ && !(this.f_58857_ instanceof PonderLevel)) {
            int tankNumber = 0;
            for (int i = 0; i < 8; ++i) {
                IFluidHandler fluidHandler = (IFluidHandler)this.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
                if (fluidHandler == null) continue;
                this.fluidLevel[i].chase((double)fluidHandler.getFluidInTank(tankNumber).getAmount() / (double)this.inputTank.getPrimaryHandler().getCapacity(), 0.5, LerpedFloat.Chaser.EXP);
                this.getFillState();
                ++tankNumber;
            }
        }
    }

    public void updateTemperature() {
        if (!this.isController()) {
            return;
        }
        int prevHeat = this.heatLevel;
        this.heatLevel = 0;
        this.heatCondition = HeatCondition.NONE;
        BlockPos pos1 = this.controller == null ? this.m_58899_() : this.controller;
        VatBlockEntity be = this.getControllerBE() == null ? this : this.getControllerBE();
        for (int xOffset = 0; xOffset < be.width; ++xOffset) {
            for (int zOffset = 0; zOffset < be.width; ++zOffset) {
                BlockState blockState;
                BlockPos pos = pos1.m_7918_(xOffset, -1, zOffset);
                float heat = BoilerHeater.findHeat((Level)this.f_58857_, (BlockPos)pos, (BlockState)(blockState = this.f_58857_.m_8055_(pos)));
                if (!(heat > 0.0f)) continue;
                this.heatLevel += (int)heat;
            }
        }
        if (this.heatLevel >= 2) {
            this.heatCondition = HeatCondition.HEATED;
        }
        if (this.heatLevel >= 4) {
            this.heatCondition = HeatCondition.SUPERHEATED;
        }
        if (this.heatLevel != prevHeat) {
            this.notifyUpdate();
        }
    }

    public VatMachineRecipe getMatchingRecipe() {
        List list = RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.f_58857_, r -> r instanceof VatMachineRecipe);
        for (Recipe recipe1 : list) {
            int i;
            VatMachineRecipe testedRecipe = (VatMachineRecipe)recipe1;
            if (this.getTotalTankSize() < testedRecipe.minSize) continue;
            boolean doesntMatch = false;
            if (!Objects.equals(testedRecipe.machines, this.machineMap.values().stream().toList()) || !this.areMachinesValid || !testedRecipe.allowedVatTypes.contains(((VatBlock)this.m_58900_().m_60734_()).vatType)) continue;
            IFluidHandler fluidHandler = (IFluidHandler)this.getCapability(ForgeCapabilities.FLUID_HANDLER).orElseGet(null);
            IItemHandler itemHandler = (IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
            HashMap<Integer, Integer> isFluidFound = new HashMap<Integer, Integer>();
            for (int i2 = 0; i2 < testedRecipe.getFluidIngredients().size(); ++i2) {
                FluidIngredient ingredient = (FluidIngredient)testedRecipe.getFluidIngredients().get(i2);
                Integer foundAt = null;
                if (ingredient.getMatchingFluidStacks().isEmpty()) break;
                for (int y = 0; y < fluidHandler.getTanks(); ++y) {
                    FluidStack stack;
                    if (isFluidFound.containsValue(y) || !ingredient.test(stack = fluidHandler.getFluidInTank(y))) continue;
                    foundAt = y;
                    break;
                }
                if (foundAt != null) {
                    isFluidFound.put(i2, foundAt);
                    continue;
                }
                doesntMatch = true;
            }
            SmartInventory testInventory = new SmartInventory(8, (SyncedBlockEntity)this);
            for (i = 0; i < 4; ++i) {
                testInventory.setStackInSlot(i, this.inputInventory.getStackInSlot(i).m_41777_());
            }
            for (i = 0; i < 4; ++i) {
                testInventory.setStackInSlot(i + 4, this.outputInventory.getStackInSlot(i).m_41777_());
            }
            for (i = 0; i < testedRecipe.m_7527_().size(); ++i) {
                Ingredient ingredient = (Ingredient)testedRecipe.m_7527_().get(i);
                boolean found = false;
                for (int y = 0; y < 8; ++y) {
                    ItemStack stack = testInventory.getStackInSlot(y).m_41777_();
                    if (!ingredient.test(stack)) continue;
                    found = true;
                    testInventory.m_8020_(y).m_41774_(1);
                    break;
                }
                if (found) continue;
                doesntMatch = true;
                break;
            }
            if (doesntMatch) continue;
            HashMap<Fluid, Integer> fluids = new HashMap<Fluid, Integer>();
            ArrayList<FluidStack> totalFluidStacks = new ArrayList<FluidStack>();
            for (int i3 = 0; i3 < this.outputTank.getPrimaryHandler().getTanks(); ++i3) {
                totalFluidStacks.add(this.outputTank.getPrimaryHandler().getFluidInTank(i3));
            }
            totalFluidStacks.addAll((Collection<FluidStack>)testedRecipe.getFluidResults());
            for (FluidStack stack : totalFluidStacks) {
                if (stack.isEmpty()) continue;
                if (fluids.containsKey(stack.getFluid())) {
                    fluids.replace(stack.getFluid(), (Integer)fluids.get(stack.getFluid()) + stack.getAmount());
                    continue;
                }
                fluids.put(stack.getFluid(), stack.getAmount());
            }
            AtomicBoolean cantOutput = new AtomicBoolean(false);
            fluids.forEach((f, a) -> {
                if (a > 4000) {
                    cantOutput.set(true);
                }
            });
            HashMap<Item, Integer> items = new HashMap<Item, Integer>();
            ArrayList<ItemStack> totalItemStacks = new ArrayList<ItemStack>();
            for (int i4 = 0; i4 < this.outputInventory.getSlots(); ++i4) {
                totalItemStacks.add(this.outputInventory.getStackInSlot(i4));
            }
            totalItemStacks.addAll(testedRecipe.getRollableResultsAsItemStacks());
            for (ItemStack stack : totalItemStacks) {
                if (stack.m_41619_()) continue;
                if (items.containsKey(stack.m_41720_())) {
                    items.replace(stack.m_41720_(), (Integer)items.get(stack.m_41720_()) + stack.m_41613_());
                    continue;
                }
                items.put(stack.m_41720_(), stack.m_41613_());
            }
            items.forEach((f, a) -> {
                if (a > 64) {
                    cantOutput.set(true);
                }
            });
            if (cantOutput.get()) continue;
            return testedRecipe;
        }
        return null;
    }

    public void tick() {
        super.tick();
        this.handleRecipe();
        if (this.isController()) {
            for (BlockPos machinePos : this.machineMap.keySet()) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(machinePos);
                if (!(blockEntity instanceof IVatMachine)) continue;
                IVatMachine vatMachine = (IVatMachine)blockEntity;
                boolean operational = vatMachine.canOperate(this);
                this.operationalMachinesMap.put(machinePos, operational);
            }
        }
        this.areMachinesValid = this.operationalMachinesMap.values().stream().allMatch(op -> op == true);
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.evaluateNextTick) {
            if (!this.f_58857_.m_5776_()) {
                TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new VatEvaluationPacket(this.m_58899_()));
            }
            this.evaluate();
            this.evaluateNextTick = false;
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateCapability) {
            this.updateCapability = false;
            this.refreshCapability();
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        for (int i = 0; i < 8; ++i) {
            this.fluidLevel[i].tickChaser();
        }
    }

    public void handleRecipe() {
        if (this.recipe == null) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        if (this.heatLevel < this.recipe.heatLevel) {
            return;
        }
        if (this.recipe.getRequiredHeat() == HeatCondition.HEATED && this.heatCondition == HeatCondition.NONE) {
            return;
        }
        if (this.recipe.getRequiredHeat() == HeatCondition.SUPERHEATED && this.heatCondition != HeatCondition.SUPERHEATED) {
            return;
        }
        if (this.timer >= this.recipe.getProcessingDuration()) {
            SmartFluidTank outputFluidHandler = this.outputTank.getPrimaryHandler();
            IFluidHandler fluidHandler = (IFluidHandler)this.getCapability(ForgeCapabilities.FLUID_HANDLER).orElseGet(null);
            IItemHandler itemHandler = (IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseGet(null);
            block0: for (FluidIngredient ingredient : this.recipe.getFluidIngredients()) {
                for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                    FluidStack fluidInTank = fluidHandler.getFluidInTank(i);
                    if (!ingredient.test(new FluidStack(fluidInTank, 4000))) continue;
                    fluidHandler.getFluidInTank(i).setAmount(fluidInTank.getAmount() - ingredient.getRequiredAmount());
                    continue block0;
                }
            }
            block2: for (ProcessingOutput output : this.recipe.getRollableResults()) {
                int i;
                ItemStack itemStack = output.rollOutput();
                boolean handled = false;
                for (i = 0; i < this.outputInventory.getSlots(); ++i) {
                    ItemStack stackInSlot = this.outputInventory.getStackInSlot(i);
                    if (stackInSlot.m_41619_() || !stackInSlot.m_150930_(itemStack.m_41720_())) continue;
                    this.outputInventory.getStackInSlot(i).m_41764_(stackInSlot.m_41613_() + itemStack.m_41613_());
                    handled = true;
                    break;
                }
                if (handled) break;
                for (i = 0; i < this.outputInventory.getSlots(); ++i) {
                    ItemStack itemInSlot = this.outputInventory.getStackInSlot(i);
                    if (!itemInSlot.m_41619_()) continue;
                    this.outputInventory.setStackInSlot(i, itemStack);
                    continue block2;
                }
            }
            if (this.recipe != null) {
                block5: for (FluidIngredient ingredient : this.recipe.m_7527_()) {
                    for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                        ItemStack stackInInv = itemHandler.getStackInSlot(i);
                        if (!ingredient.test(new ItemStack((ItemLike)stackInInv.m_41720_(), 64))) continue;
                        stackInInv.m_41764_(stackInInv.m_41613_() - ingredient.m_43908_()[0].m_41613_());
                        continue block5;
                    }
                }
            }
            ArrayList handledFluidResults = new ArrayList();
            ArrayList<FluidStack> handledFluidStacks = new ArrayList<FluidStack>();
            List<SmartFluidTankBehaviour.TankSegment> tankSegments = List.of(this.outputTank.getTanks());
            if (this.recipe != null) {
                block7: for (FluidStack fluidStack : this.recipe.getFluidResults()) {
                    for (SmartFluidTankBehaviour.TankSegment tankSegment : tankSegments) {
                        SmartFluidTank tank = ((TankSegmentAccessor)tankSegment).tfmg$tank();
                        FluidStack fluidInTank = tank.getFluid();
                        if (handledFluidStacks.contains(fluidStack)) continue block7;
                        if (fluidInTank.getFluid().m_6212_(fluidStack.getFluid())) {
                            tank.fill(new FluidStack(fluidStack.copy(), fluidStack.getAmount()), IFluidHandler.FluidAction.EXECUTE);
                            handledFluidStacks.add(fluidStack);
                            continue block7;
                        }
                        if (handledFluidStacks.contains(fluidStack) || !fluidInTank.isEmpty()) continue;
                        tank.fill(new FluidStack(fluidStack.copy(), fluidStack.getAmount()), IFluidHandler.FluidAction.EXECUTE);
                        continue block7;
                    }
                }
            }
            this.recipe = null;
            this.timer = 0;
        } else {
            ++this.timer;
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    protected void onInventoryChanged() {
        if (!this.m_58898_()) {
            return;
        }
        this.recipe = this.getMatchingRecipe();
        FluidStack newFluidStack = this.inputTank.getPrimaryHandler().getFluid();
        FluidType attributes = newFluidStack.getFluid().getFluidType();
        int luminosity = (int)((float)attributes.getLightLevel(newFluidStack) / 1.2f);
        boolean reversed = attributes.isLighterThanAir();
        int maxY = (int)(this.getFillState() * (float)this.height + 1.0f);
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            boolean isBright;
            boolean bl = reversed ? this.height - yOffset <= maxY : (isBright = yOffset < maxY);
            int actualLuminosity = isBright ? luminosity : (luminosity > 0 ? 1 : 0);
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    VatBlockEntity vatAt = (VatBlockEntity)ConnectivityHandler.partAt((BlockEntityType)this.m_58903_(), (BlockGetter)this.f_58857_, (BlockPos)pos);
                    if (vatAt == null) continue;
                    this.f_58857_.m_46717_(pos, vatAt.m_58900_().m_60734_());
                    if (vatAt.luminosity == actualLuminosity) continue;
                    vatAt.setLuminosity(actualLuminosity);
                }
            }
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
    }

    protected void setLuminosity(int luminosity) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.luminosity == luminosity) {
            return;
        }
        this.luminosity = luminosity;
        this.sendData();
    }

    public VatBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof VatBlockEntity) {
            return (VatBlockEntity)blockEntity;
        }
        return null;
    }

    public void evaluate() {
        if (!this.isController()) {
            if (this.getControllerBE() == null) {
                return;
            }
            this.getControllerBE().evaluate();
            return;
        }
        Map<BlockPos, String> oldMachineMap = this.machineMap;
        this.machineMap = new HashMap<BlockPos, String>();
        this.heatLevel = 0;
        this.heatCondition = HeatCondition.NONE;
        boolean superheatedCount = false;
        float speed = 1.0f;
        for (int xOffset = 0; xOffset < this.width; ++xOffset) {
            for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                for (int yOffset = 0; yOffset < this.getHeight() + 2; ++yOffset) {
                    IVatMachine be;
                    BlockEntity blockEntity;
                    BlockPos pos = this.m_58899_().m_7495_().m_7918_(xOffset, yOffset, zOffset);
                    BlockState blockState = this.f_58857_.m_8055_(pos);
                    if (VatBlock.isVat(blockState) || !((blockEntity = this.f_58857_.m_7702_(pos)) instanceof IVatMachine) || (be = (IVatMachine)blockEntity).getOperationId().isEmpty() || !this.isAtValidLocation(be.getPositionRequirement(), pos)) continue;
                    be.vatUpdated(this);
                    this.machineMap.put(pos, be.getOperationId());
                    this.efficiency *= (float)(be.getWorkPercentage() / 100);
                }
            }
        }
        this.efficiency = speed;
        if (oldMachineMap != this.machineMap) {
            this.recipe = null;
        }
        this.notifyUpdate();
    }

    public boolean isAtValidLocation(IVatMachine.PositionRequirement requirement, BlockPos pos) {
        return switch (requirement) {
            default -> throw new IncompatibleClassChangeError();
            case IVatMachine.PositionRequirement.ANY -> true;
            case IVatMachine.PositionRequirement.BOTTOM -> {
                if (pos.m_123342_() == this.getController().m_123342_() - 1) {
                    yield true;
                }
                yield false;
            }
            case IVatMachine.PositionRequirement.TOP -> {
                if (pos.m_123342_() == this.getController().m_123342_() + this.height) {
                    yield true;
                }
                yield false;
            }
            case IVatMachine.PositionRequirement.ANY_CENTER -> this.isAtCenter(pos);
            case IVatMachine.PositionRequirement.BOTTOM_CENTER -> {
                if (this.isAtCenter(pos) && pos.m_123342_() == this.getController().m_123342_() - 1) {
                    yield true;
                }
                yield false;
            }
            case IVatMachine.PositionRequirement.TOP_CENTER -> this.isAtCenter(pos) && pos.m_123342_() == this.getController().m_123342_() + this.height;
        };
    }

    public boolean isAtCenter(BlockPos pos) {
        return this.width < 3 || pos.m_123341_() == this.getController().m_123341_() + 1 && pos.m_123343_() == this.getController().m_123343_() + 1;
    }

    public void applyVatSize(int blocks) {
        int overflow2;
        this.inputTank.forEach(s -> ((TankSegmentAccessor)s).tfmg$tank().setCapacity(blocks * VatBlockEntity.getCapacityMultiplier()));
        this.outputTank.forEach(s -> ((TankSegmentAccessor)s).tfmg$tank().setCapacity(blocks * VatBlockEntity.getCapacityMultiplier()));
        int overflow = this.inputTank.getPrimaryHandler().getFluidAmount() - this.inputTank.getPrimaryHandler().getCapacity();
        if (overflow > 0) {
            this.inputTank.getPrimaryHandler().drain(overflow, IFluidHandler.FluidAction.EXECUTE);
        }
        if ((overflow2 = this.outputTank.getPrimaryHandler().getFluidAmount() - this.outputTank.getPrimaryHandler().getCapacity()) > 0) {
            this.outputTank.getPrimaryHandler().drain(overflow2, IFluidHandler.FluidAction.EXECUTE);
        }
        this.forceFluidLevelUpdate = true;
        this.evaluateNextTick = true;
    }

    public void removeController(boolean keepFluids) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyVatSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onInventoryChanged();
        BlockState state = this.m_58900_();
        if (VatBlock.isVat(state)) {
            state = (BlockState)state.m_61124_((Property)VatBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_((Property)VatBlock.TOP, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_(VatBlock.SHAPE, (Comparable)((Object)(this.window ? VatBlock.Shape.WINDOW : VatBlock.Shape.PLAIN)));
            this.m_58904_().m_7731_(this.f_58858_, state, 22);
        }
        this.evaluateNextTick = true;
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    public void toggleWindows() {
        VatBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        if (((VatBlock)this.m_58900_().m_60734_()).vatType == "tfmg:firebrick_lined_vat") {
            return;
        }
        be.setWindows(!be.window);
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setWindows(boolean window) {
        this.window = window;
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    BlockState blockState = this.f_58857_.m_8055_(pos);
                    if (!VatBlock.isVat(blockState)) continue;
                    VatBlock.Shape shape = VatBlock.Shape.PLAIN;
                    if (window) {
                        if (this.width == 1) {
                            shape = VatBlock.Shape.WINDOW;
                        }
                        if (this.width == 2) {
                            VatBlock.Shape shape2 = xOffset == 0 ? (zOffset == 0 ? VatBlock.Shape.WINDOW_NW : VatBlock.Shape.WINDOW_SW) : (shape = zOffset == 0 ? VatBlock.Shape.WINDOW_NE : VatBlock.Shape.WINDOW_SE);
                        }
                        if (this.width == 3 && Math.abs(Math.abs(xOffset) - Math.abs(zOffset)) == 1) {
                            shape = VatBlock.Shape.WINDOW;
                        }
                    }
                    this.f_58857_.m_7731_(pos, (BlockState)blockState.m_61124_(VatBlock.SHAPE, (Comparable)((Object)shape)), 22);
                    this.f_58857_.m_7726_().m_7827_().m_7174_(pos);
                }
            }
        }
    }

    public void updateState() {
        if (!this.isController()) {
            return;
        }
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7918_(xOffset, yOffset, zOffset));
                    if (!(blockEntity instanceof VatBlockEntity)) continue;
                    VatBlockEntity fbe = (VatBlockEntity)blockEntity;
                    fbe.refreshCapability();
                }
            }
        }
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldFluidCap = this.fluidCapability;
        LazyOptional<IItemHandlerModifiable> oldItemCap = this.itemCapability;
        this.fluidCapability = this.getNewFluidCapability();
        this.itemCapability = this.getNewItemCapability();
        oldFluidCap.invalidate();
        oldItemCap.invalidate();
    }

    private LazyOptional<IFluidHandler> getNewFluidCapability() {
        LazyOptional inputCap = this.inputTank.getCapability();
        LazyOptional outputCap = this.outputTank.getCapability();
        IFluidHandler inputHandler = (IFluidHandler)inputCap.orElse(null);
        IFluidHandler outputHandler = (IFluidHandler)outputCap.orElse(null);
        if (inputHandler == null || outputHandler == null) {
            return LazyOptional.empty();
        }
        return this.isController() ? LazyOptional.of(() -> new CombinedTankWrapper(new IFluidHandler[]{inputHandler, outputHandler})) : (this.getControllerBE() != null ? this.getControllerBE().getNewFluidCapability() : LazyOptional.empty());
    }

    private LazyOptional<IItemHandlerModifiable> getNewItemCapability() {
        return this.isController() ? LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventory})) : (this.getControllerBE() != null ? this.getControllerBE().getNewItemCapability() : LazyOptional.empty());
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().m_82363_((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    @Nullable
    public VatBlockEntity getOtherVatBE(Direction direction) {
        BlockEntity otherBE = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
        if (otherBE instanceof VatBlockEntity) {
            return (VatBlockEntity)otherBE;
        }
        return null;
    }

    public void addMachineTooltip(String operationId, boolean isOperational, List<Component> tooltip) {
        LangBuilder operation = CreateLang.translate((String)("goggles.vat." + operationId.replace(":", ".")), (Object[])new Object[0]);
        if (!isOperational) {
            operation.add(CreateLang.text((String)" - ")).add(CreateLang.translate((String)"goggles.vat.not_operational", (Object[])new Object[0]).style(ChatFormatting.RED));
        }
        operation.forGoggles(tooltip);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!this.isController()) {
            return this.getControllerBE().addToGoggleTooltip(tooltip, isPlayerSneaking);
        }
        CreateLang.translate((String)"goggles.vat.header", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.translate((String)"goggles.vat.contents", (Object[])new Object[0]).forGoggles(tooltip);
        CreateLang.translate((String)"goggles.vat.attachments", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        for (Map.Entry<BlockPos, String> machines : this.machineMap.entrySet()) {
            boolean operational = this.operationalMachinesMap.getOrDefault(machines.getKey(), true);
            this.addMachineTooltip(machines.getValue(), operational, tooltip);
        }
        CreateLang.translate((String)"goggles.vat.heat_status", (Object[])new Object[0]).add(CreateLang.translate((String)(this.heatCondition == HeatCondition.NONE ? "goggles.vat.no_heat" : (this.heatCondition == HeatCondition.HEATED ? "goggles.vat.heated" : "goggles.vat.superheated")), (Object[])new Object[0])).color(this.heatCondition == HeatCondition.NONE ? 0x7A7A77 : (this.heatCondition == HeatCondition.HEATED ? 14590486 : 1492958)).forGoggles(tooltip);
        CreateLang.translate((String)"goggles.vat.contents", (Object[])new Object[0]).forGoggles(tooltip);
        IItemHandlerModifiable items = (IItemHandlerModifiable)this.itemCapability.orElse((Object)new ItemStackHandler());
        IFluidHandler fluids = (IFluidHandler)this.fluidCapability.orElse((Object)new FluidTank(0));
        boolean isEmpty = true;
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stackInSlot = items.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            CreateLang.text((String)"").add(Component.m_237115_((String)stackInSlot.m_41778_()).m_130940_(ChatFormatting.GRAY)).add(CreateLang.text((String)(" x" + stackInSlot.m_41613_())).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        for (int i = 0; i < fluids.getTanks(); ++i) {
            FluidStack fluidStack = fluids.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            CreateLang.text((String)"").add(CreateLang.fluidName((FluidStack)fluidStack).add(CreateLang.text((String)" ")).style(ChatFormatting.GRAY).add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (isEmpty) {
            tooltip.remove(0);
        }
        return true;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.luminosity = compound.m_128451_("Luminosity");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.window = compound.m_128471_("Window");
            this.width = compound.m_128451_("Size");
            this.height = compound.m_128451_("Height");
            this.inputTank.getPrimaryHandler().setCapacity(this.getTotalTankSize() * VatBlockEntity.getCapacityMultiplier());
            this.outputTank.getPrimaryHandler().setCapacity(this.getTotalTankSize() * VatBlockEntity.getCapacityMultiplier());
            if (this.inputTank.getPrimaryHandler().getSpace() < 0) {
                this.inputTank.getPrimaryHandler().drain(-this.inputTank.getPrimaryHandler().getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
            if (this.outputTank.getPrimaryHandler().getSpace() < 0) {
                this.outputTank.getPrimaryHandler().drain(-this.outputTank.getPrimaryHandler().getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
            this.inputInventory.deserializeNBT(compound.m_128469_("InputItems"));
            this.outputInventory.deserializeNBT(compound.m_128469_("OutputItems"));
        }
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.m_58898_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            }
            if (this.isController()) {
                this.inputTank.getPrimaryHandler().setCapacity(VatBlockEntity.getCapacityMultiplier() * this.getTotalTankSize());
                this.outputTank.getPrimaryHandler().setCapacity(VatBlockEntity.getCapacityMultiplier() * this.getTotalTankSize());
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float f = this.getFillState();
        }
        if (this.luminosity != prevLum && this.m_58898_()) {
            this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
        }
    }

    public float getFillState() {
        IFluidHandler fluidHandler = (IFluidHandler)this.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
            if (fluidHandler.getFluidInTank(i).isEmpty()) continue;
            return (float)fluidHandler.getFluidInTank(i).getAmount() / (float)fluidHandler.getTankCapacity(0);
        }
        return 0.0f;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128379_("Window", this.window);
            compound.m_128405_("Size", this.width);
            compound.m_128405_("Height", this.height);
            compound.m_128365_("InputItems", (Tag)this.inputInventory.serializeNBT());
            compound.m_128365_("OutputItems", (Tag)this.outputInventory.serializeNBT());
        }
        compound.m_128405_("Luminosity", this.luminosity);
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            compound.m_128379_("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            compound.m_128379_("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    public int getTotalTankSize() {
        return this.width * this.width * this.height;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.fluidCapability.isPresent() || !this.itemCapability.isPresent()) {
            this.refreshCapability();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidate() {
        super.invalidate();
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get() * 1000;
    }

    public static int getMaxHeight() {
        return 3;
    }

    public LerpedFloat[] getFluidLevel() {
        return this.fluidLevel;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (VatBlock.isVat(state)) {
            state = (BlockState)state.m_61124_((Property)VatBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().m_123342_() == this.m_58899_().m_123342_()));
            state = (BlockState)state.m_61124_((Property)VatBlock.TOP, (Comparable)Boolean.valueOf(this.getController().m_123342_() + this.height - 1 == this.m_58899_().m_123342_()));
            this.f_58857_.m_7731_(this.m_58899_(), state, 6);
        }
        if (this.isController()) {
            this.setWindows(this.window);
        }
        this.evaluateNextTick = true;
        this.onInventoryChanged();
        this.m_6596_();
    }

    public void setExtraData(@Nullable Object data) {
        if (data instanceof Boolean) {
            this.window = (Boolean)data;
        }
    }

    @Nullable
    public Object getExtraData() {
        return this.window;
    }

    public Object modifyExtraData(Object data) {
        if (data instanceof Boolean) {
            Boolean windows = (Boolean)data;
            windows = windows | this.window;
            return windows;
        }
        return data;
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return VatBlockEntity.getMaxHeight();
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getTimer() {
        return this.timer;
    }

    public float getRecipeCompletion() {
        if (this.recipe == null) {
            return 0.0f;
        }
        return (float)this.timer / (float)this.recipe.getProcessingDuration();
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean hasTank() {
        return true;
    }

    public int getTankSize(int tank) {
        return VatBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyVatSize(blocks);
    }

    public IFluidTank getTank(int tank) {
        return new FluidTank(1);
    }

    public FluidStack getFluid(int tank) {
        return this.inputTank.getPrimaryHandler().getFluid();
    }
}

