/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.datagen;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.TFMGRegistrateTags;
import com.drmangotea.tfmg.datagen.TFMGGeneratedEntriesProvider;
import com.drmangotea.tfmg.datagen.recipes.TFMGProcessingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.TFMGRecipeProvider;
import com.drmangotea.tfmg.datagen.recipes.values.TFMGStandardRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.create.TFMGMechanicalCraftingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.create.TFMGSequencedAssemblyRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.tfmg.CastingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.tfmg.IndustrialBlastingRecipeGen;
import com.drmangotea.tfmg.datagen.recipes.values.tfmg.VatRecipeGen;
import com.drmangotea.tfmg.ponder.TFMGPonderPlugin;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.data.event.GatherDataEvent;

public class TFMGDatagen {
    protected static final List<TFMGRecipeProvider> RECIPE_GENERATORS = new ArrayList<TFMGRecipeProvider>();

    public static void gatherData(GatherDataEvent event) {
        TFMGDatagen.addExtraRegistrateData();
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            TFMGGeneratedEntriesProvider generatedEntriesProvider = new TFMGGeneratedEntriesProvider(output, lookupProvider);
            generator.addProvider(true, (DataProvider)generatedEntriesProvider);
            RECIPE_GENERATORS.add(new IndustrialBlastingRecipeGen(output));
            RECIPE_GENERATORS.add(new CastingRecipeGen(output));
            RECIPE_GENERATORS.add(new VatRecipeGen(output));
            RECIPE_GENERATORS.add(new TFMGStandardRecipeGen(output));
            RECIPE_GENERATORS.add(new TFMGMechanicalCraftingRecipeGen(output));
            generator.addProvider(true, (DataProvider)new TFMGSequencedAssemblyRecipeGen(output));
            generator.addProvider(true, new DataProvider(){

                public String m_6055_() {
                    return "TFMG's Recipes";
                }

                public CompletableFuture<?> m_213708_(CachedOutput dc) {
                    return CompletableFuture.allOf((CompletableFuture[])RECIPE_GENERATORS.stream().map(gen -> gen.m_213708_(dc)).toArray(CompletableFuture[]::new));
                }
            });
            TFMGProcessingRecipeGen.registerAll(generator, output);
        }
    }

    private static void addExtraRegistrateData() {
        TFMGRegistrateTags.addGenerators();
        TFMG.REGISTRATE.addDataGenerator(ProviderType.LANG, provider -> {
            BiConsumer<String, String> langConsumer = (arg_0, arg_1) -> ((RegistrateLangProvider)provider).add(arg_0, arg_1);
            TFMGDatagen.provideDefaultLang("interface", langConsumer);
            TFMGDatagen.provideDefaultLang("tooltips", langConsumer);
            TFMGDatagen.providePonderLang(langConsumer);
        });
    }

    private static void providePonderLang(BiConsumer<String, String> consumer) {
        PonderIndex.addPlugin((PonderPlugin)new TFMGPonderPlugin());
        PonderIndex.getLangAccess().provideLang("tfmg", consumer);
    }

    private static void provideDefaultLang(String fileName, BiConsumer<String, String> consumer) {
        String path = "assets/tfmg/lang/default/" + fileName + ".json";
        JsonElement jsonElement = FilesHelper.loadJsonResource((String)path);
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", path));
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            consumer.accept(key, value);
        }
    }
}

